/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity.projectiles;

import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IThrowableEntity;
import thebetweenlands.common.entity.mobs.EntityTinySludgeWormHelper;
import thebetweenlands.common.herblore.elixir.ElixirEffectRegistry;
import thebetweenlands.common.item.tools.bow.EnumArrowType;
import thebetweenlands.common.registries.ItemRegistry;

public class EntityBLArrow
extends EntityArrow
implements IThrowableEntity {
    private static final DataParameter<String> DW_TYPE = EntityDataManager.func_187226_a(EntityBLArrow.class, (DataSerializer)DataSerializers.field_187194_d);

    public EntityBLArrow(World worldIn) {
        super(worldIn);
    }

    public EntityBLArrow(World worldIn, EntityLivingBase shooter) {
        super(worldIn, shooter);
    }

    public Entity getThrower() {
        return this.field_70250_c;
    }

    public void setThrower(Entity entity) {
        this.field_70250_c = entity;
    }

    public void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DW_TYPE, (Object)"");
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74778_a("arrowType", this.getArrowType().func_176610_l());
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.setType(EnumArrowType.getEnumFromString(nbt.func_74779_i("arrowType")));
    }

    protected void func_184548_a(EntityLivingBase living) {
        switch (this.getArrowType()) {
            case ANGLER_POISON: {
                living.func_70690_d(new PotionEffect(MobEffects.field_76436_u, 200, 2));
                break;
            }
            case OCTINE: {
                if (living.func_70027_ad()) {
                    living.func_70015_d(9);
                    break;
                }
                living.func_70015_d(5);
                break;
            }
            case BASILISK: {
                if (living.func_184222_aU()) {
                    living.func_70690_d(ElixirEffectRegistry.EFFECT_PETRIFY.createEffect(100, 1));
                    break;
                }
                living.func_70690_d(ElixirEffectRegistry.EFFECT_PETRIFY.createEffect(40, 1));
                break;
            }
            case WORM: {
                if (this.func_130014_f_().field_72995_K) break;
                EntityTinySludgeWormHelper worm = new EntityTinySludgeWormHelper(this.func_130014_f_());
                worm.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
                worm.func_70624_b(living);
                if (this.field_70250_c instanceof EntityPlayer) {
                    worm.setOwnerId(this.field_70250_c.func_110124_au());
                }
                this.func_130014_f_().func_72838_d((Entity)worm);
                this.func_70106_y();
                break;
            }
        }
    }

    protected void func_184549_a(RayTraceResult raytrace) {
        BlockPos pos;
        IBlockState state;
        super.func_184549_a(raytrace);
        if (raytrace.field_72308_g == null && raytrace.func_178782_a() != null && raytrace.field_178784_b != null && this.getArrowType() == EnumArrowType.OCTINE && ItemRegistry.OCTINE_INGOT.isTinder(new ItemStack((Item)ItemRegistry.OCTINE_INGOT), ItemStack.field_190927_a, state = this.field_70170_p.func_180495_p(pos = raytrace.func_178782_a().func_177972_a(raytrace.field_178784_b)))) {
            this.field_70170_p.func_175656_a(pos, Blocks.field_150480_ab.func_176223_P());
        }
    }

    public void setType(EnumArrowType type) {
        this.field_70180_af.func_187227_b(DW_TYPE, (Object)type.func_176610_l());
    }

    public EnumArrowType getArrowType() {
        return EnumArrowType.getEnumFromString((String)this.field_70180_af.func_187225_a(DW_TYPE));
    }

    protected ItemStack func_184550_j() {
        switch (this.getArrowType()) {
            case ANGLER_POISON: {
                return new ItemStack(ItemRegistry.POISONED_ANGLER_TOOTH_ARROW);
            }
            case OCTINE: {
                return new ItemStack(ItemRegistry.OCTINE_ARROW);
            }
            case BASILISK: {
                return new ItemStack(ItemRegistry.BASILISK_ARROW);
            }
            case WORM: {
                return new ItemStack(ItemRegistry.SLUDGE_WORM_ARROW);
            }
        }
        return new ItemStack(ItemRegistry.ANGLER_TOOTH_ARROW);
    }
}

