/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity.projectiles;

import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import thebetweenlands.client.render.particle.BLParticles;
import thebetweenlands.common.entity.mobs.EntityTarminion;

public class EntityThrownTarminion
extends EntityThrowable {
    private UUID ownerUUID = null;

    public EntityThrownTarminion(World world) {
        super(world);
    }

    public EntityThrownTarminion(World world, EntityLivingBase entity) {
        super(world, entity);
        this.ownerUUID = entity.func_110124_au();
    }

    public EntityThrownTarminion(World world, double x, double y, double z) {
        super(world, x, y, z);
    }

    public NBTTagCompound func_189511_e(NBTTagCompound nbt) {
        super.func_189511_e(nbt);
        nbt.func_186854_a("owner", this.ownerUUID);
        return nbt;
    }

    public void func_70020_e(NBTTagCompound nbt) {
        super.func_70020_e(nbt);
        this.ownerUUID = nbt.func_186857_a("owner");
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70122_E && this.field_70170_p.field_72995_K) {
            BLParticles.TAR_BEAST_DRIP.spawn(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v);
        }
    }

    protected void func_70184_a(RayTraceResult result) {
        if (result.field_72308_g != null && result.field_72308_g instanceof EntityLivingBase) {
            if (!(result.field_72308_g instanceof EntityTarminion)) {
                if (!this.field_70170_p.field_72995_K) {
                    result.field_72308_g.func_70097_a(DamageSource.func_76356_a((Entity)this, (Entity)this.func_85052_h()), 2.0f);
                    if (this.func_70027_ad() && !(result.field_72308_g instanceof EntityEnderman)) {
                        result.field_72308_g.func_70015_d(5);
                    }
                }
                if (this.field_70170_p.field_72995_K) {
                    for (int i = 0; i < 8; ++i) {
                        BLParticles.SPLASH_TAR.spawn(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v);
                    }
                }
            }
            if (!this.field_70170_p.field_72995_K) {
                EntityTarminion tarminion = this.spawnTarminion();
                if (result.field_72308_g instanceof EntityMob) {
                    tarminion.func_70624_b((EntityLivingBase)result.field_72308_g);
                }
            }
        } else if (result.field_72313_a == RayTraceResult.Type.BLOCK && !this.field_70170_p.field_72995_K) {
            this.spawnTarminion();
        }
    }

    private EntityTarminion spawnTarminion() {
        if (!this.field_70170_p.field_72995_K) {
            this.func_70106_y();
            EntityTarminion tarminion = new EntityTarminion(this.field_70170_p);
            tarminion.func_70903_f(true);
            if (this.ownerUUID != null) {
                tarminion.func_184754_b(this.ownerUUID);
            }
            Vec3d motionVec = new Vec3d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
            motionVec = motionVec.func_72432_b();
            double speed = 0.25;
            tarminion.field_70159_w = motionVec.field_72450_a * speed;
            tarminion.field_70181_x = motionVec.field_72448_b * speed;
            tarminion.field_70179_y = motionVec.field_72449_c * speed;
            tarminion.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0f, 0.0f);
            this.field_70170_p.func_72838_d((Entity)tarminion);
            return tarminion;
        }
        return null;
    }
}

