/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.inventory;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import thebetweenlands.api.event.EquipmentChangedEvent;
import thebetweenlands.api.item.IEquippable;
import thebetweenlands.common.capability.equipment.EquipmentEntityCapability;

public class InventoryEquipment
implements IInventory,
ITickable {
    protected final NonNullList<ItemStack> inventory;
    protected final NonNullList<ItemStack> prevTickStacks;
    protected final EquipmentEntityCapability capability;
    private int lastChangeCheck = 0;

    public InventoryEquipment(EquipmentEntityCapability capability, NonNullList<ItemStack> inventory) {
        this.capability = capability;
        this.inventory = inventory;
        this.prevTickStacks = NonNullList.func_191197_a((int)inventory.size(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < this.inventory.size(); ++i) {
            ItemStack stack = (ItemStack)this.inventory.get(i);
            if (stack.func_190926_b()) continue;
            this.prevTickStacks.set(i, (Object)(stack.func_190926_b() ? ItemStack.field_190927_a : stack.func_77946_l()));
        }
    }

    public String func_70005_c_() {
        return "container.bl.equipment";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public ITextComponent func_145748_c_() {
        return this.func_145818_k_() ? new TextComponentString(this.func_70005_c_()) : new TextComponentTranslation(this.func_70005_c_(), new Object[0]);
    }

    @Nullable
    public ItemStack func_70304_b(int index) {
        ItemStack stack = ItemStack.field_190927_a;
        if (index < this.func_70302_i_()) {
            stack = ItemStackHelper.func_188383_a(this.inventory, (int)index);
            this.func_70296_d();
        }
        return stack;
    }

    @Nullable
    public ItemStack func_70298_a(int index, int count) {
        ItemStack stack = ItemStack.field_190927_a;
        if (index < this.func_70302_i_()) {
            stack = ItemStackHelper.func_188382_a(this.inventory, (int)index, (int)count);
            this.func_70296_d();
        }
        return stack;
    }

    public void func_70299_a(int index, @Nonnull ItemStack stack) {
        if (index < this.func_70302_i_()) {
            this.inventory.set(index, (Object)stack);
            this.func_70296_d();
        }
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
        this.capability.markDirty();
        MinecraftForge.EVENT_BUS.post((Event)new EquipmentChangedEvent((Entity)this.capability.getEntity(), this.capability));
    }

    public boolean func_70300_a(EntityPlayer player) {
        return false;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return index < this.func_70302_i_();
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        for (int i = 0; i < this.inventory.size(); ++i) {
            this.inventory.set(i, (Object)ItemStack.field_190927_a);
        }
        this.func_70296_d();
    }

    public int func_70302_i_() {
        return this.inventory.size();
    }

    public boolean func_191420_l() {
        return this.inventory.size() <= 0;
    }

    @Nullable
    public ItemStack func_70301_a(int index) {
        return index >= this.func_70302_i_() ? ItemStack.field_190927_a : (ItemStack)this.inventory.get(index);
    }

    public void func_73660_a() {
        for (int i = 0; i < this.inventory.size(); ++i) {
            ItemStack stack = (ItemStack)this.inventory.get(i);
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof IEquippable)) continue;
            ((IEquippable)stack.func_77973_b()).onEquipmentTick(stack, (Entity)this.capability.getEntity(), this);
        }
        if (this.lastChangeCheck++ > 10) {
            this.detectChangesAndMarkDirty();
            this.lastChangeCheck = 0;
        }
    }

    protected void detectChangesAndMarkDirty() {
        for (int i = 0; i < this.inventory.size(); ++i) {
            ItemStack stack = (ItemStack)this.inventory.get(i);
            ItemStack prevStack = (ItemStack)this.prevTickStacks.get(i);
            if (ItemStack.func_77989_b((ItemStack)prevStack, (ItemStack)stack)) continue;
            this.prevTickStacks.set(i, (Object)(stack.func_190926_b() ? ItemStack.field_190927_a : stack.func_77946_l()));
            this.func_70296_d();
        }
    }
}

