/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.item.equipment;

import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.api.capability.IPuppetCapability;
import thebetweenlands.api.capability.IPuppeteerCapability;
import thebetweenlands.client.handler.ItemTooltipHandler;
import thebetweenlands.common.capability.equipment.EnumEquipmentInventory;
import thebetweenlands.common.capability.equipment.EquipmentHelper;
import thebetweenlands.common.entity.mobs.EntityFortressBossBlockade;
import thebetweenlands.common.item.equipment.ItemRing;
import thebetweenlands.common.registries.CapabilityRegistry;
import thebetweenlands.common.registries.ItemRegistry;
import thebetweenlands.common.registries.KeyBindRegistry;
import thebetweenlands.common.registries.SoundRegistry;
import thebetweenlands.util.NBTHelper;

public class ItemRingOfRecruitment
extends ItemRing {
    public static final String NBT_UUID = "ring_of_recruitment.uuid";

    public ItemRingOfRecruitment() {
        this.func_77656_e(100);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> list, ITooltipFlag flagIn) {
        list.addAll(ItemTooltipHandler.splitTooltip(I18n.func_135052_a((String)"tooltip.bl.ring.recruitment.bonus", (Object[])new Object[0]), 0));
        if (GuiScreen.func_146272_n()) {
            String toolTip = I18n.func_135052_a((String)"tooltip.bl.ring.recruitment", (Object[])new Object[]{KeyBindRegistry.RADIAL_MENU.getDisplayName(), Minecraft.func_71410_x().field_71474_y.field_74313_G.getDisplayName(), KeyBindRegistry.USE_RING.getDisplayName(), KeyBindRegistry.USE_SECONDARY_RING.getDisplayName()});
            list.addAll(ItemTooltipHandler.splitTooltip(toolTip, 1));
        } else {
            list.add(I18n.func_135052_a((String)"tooltip.bl.press.shift", (Object[])new Object[0]));
        }
    }

    @Override
    public void onEquipmentTick(ItemStack stack, Entity entity, IInventory inventory) {
        IPuppeteerCapability cap;
        if (!entity.field_70170_p.field_72995_K && entity instanceof EntityPlayer && (cap = (IPuppeteerCapability)entity.getCapability(CapabilityRegistry.CAPABILITY_PUPPETEER, null)) != null) {
            int puppets = cap.getPuppets().size();
            NBTTagCompound nbt = NBTHelper.getStackNBTSafe(stack);
            if (puppets == 0) {
                nbt.func_74757_a("ringActive", false);
            } else {
                nbt.func_74757_a("ringActive", true);
            }
        }
    }

    @Override
    public void onUnequip(ItemStack stack, Entity entity, IInventory inventory) {
        NBTTagCompound nbt = NBTHelper.getStackNBTSafe(stack);
        nbt.func_74757_a("ringActive", false);
        stack.func_77964_b(0);
    }

    @Override
    public void onEquip(ItemStack stack, Entity entity, IInventory inventory) {
        this.setRingUuid(stack, UUID.randomUUID());
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74767_n("ringActive");
    }

    @Override
    public void onKeybindState(EntityPlayer player, ItemStack stack, IInventory inventory, boolean active) {
        IPuppeteerCapability cap;
        if (!player.field_70170_p.field_72995_K && active && !player.func_184811_cZ().func_185141_a(ItemRegistry.RING_OF_RECRUITMENT) && (cap = (IPuppeteerCapability)player.getCapability(CapabilityRegistry.CAPABILITY_PUPPETEER, null)) != null && cap.getShield() != null) {
            List<Entity> targets = cap.getPuppets();
            HashSet<EntityFortressBossBlockade> spawned = new HashSet<EntityFortressBossBlockade>();
            for (Entity target : targets) {
                IPuppetCapability targetCap = (IPuppetCapability)target.getCapability(CapabilityRegistry.CAPABILITY_PUPPET, null);
                if (targetCap == null || !target.field_70122_E || (targetCap.getStay() || targetCap.getGuard()) && !(target.func_70032_d((Entity)player) < 6.0f)) continue;
                List collidingEntities = target.field_70170_p.func_72872_a(EntityFortressBossBlockade.class, target.func_174813_aQ().func_186662_g(0.5));
                for (EntityFortressBossBlockade collidingEntity : collidingEntities) {
                    if (spawned.contains(collidingEntity)) continue;
                    collidingEntity.func_70106_y();
                }
                EntityFortressBossBlockade blockade = new EntityFortressBossBlockade(target.field_70170_p, (Entity)player);
                blockade.func_70012_b(target.field_70165_t, target.field_70163_u - (double)0.15f, target.field_70161_v, target.field_70170_p.field_73012_v.nextFloat() * 360.0f, 0.0f);
                blockade.setMaxDespawnTicks(30 + target.field_70170_p.field_73012_v.nextInt(20));
                blockade.setTriangleSize(0.75f + target.field_70130_N * 0.5f);
                spawned.add(blockade);
                target.field_70170_p.func_72838_d((Entity)blockade);
            }
            if (!spawned.isEmpty()) {
                player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, (SoundEvent)SoundRegistry.FORTRESS_BOSS_SUMMON_PROJECTILES, SoundCategory.HOSTILE, 0.8f, 0.9f + player.field_70170_p.field_73012_v.nextFloat() * 0.15f);
                player.func_184811_cZ().func_185145_a(ItemRegistry.RING_OF_RECRUITMENT, 40);
            }
        }
    }

    @Nullable
    public UUID getRingUuid(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_186855_b(NBT_UUID)) {
            return stack.func_77978_p().func_186857_a(NBT_UUID);
        }
        return null;
    }

    public void setRingUuid(ItemStack stack, UUID uuid) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null) {
            nbt = new NBTTagCompound();
        }
        nbt.func_186854_a(NBT_UUID, uuid);
        stack.func_77982_d(nbt);
    }

    public int getRecruitmentCost(EntityLivingBase target) {
        float damageMultiplier = 0.5f;
        IAttributeInstance damageAttrib = target.func_110148_a(SharedMonsterAttributes.field_111264_e);
        if (damageAttrib != null) {
            damageMultiplier = 1.0f + Math.min((float)(damageAttrib.func_111126_e() - 2.0) / 10.0f, 0.5f);
        }
        return Math.min(60, Math.max(MathHelper.func_76141_d((float)(target.func_110138_aP() / 2.0f * damageMultiplier)), 10));
    }

    public static boolean isRingActive(Entity user, @Nullable IPuppetCapability recruited) {
        return !ItemRingOfRecruitment.getActiveRing(user, recruited).func_190926_b();
    }

    @Nullable
    public static ItemStack getActiveRing(Entity user, @Nullable IPuppetCapability recruited) {
        ItemStack ring;
        if (user instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)user;
            if (player.field_71067_cb <= 0 && player.field_71068_ca <= 0 && player.field_71106_cc <= 0.0f) {
                return ItemStack.field_190927_a;
            }
        }
        if (!(ring = EquipmentHelper.getEquipment(EnumEquipmentInventory.RING, user, ItemRegistry.RING_OF_RECRUITMENT)).func_190926_b()) {
            UUID recruitedRingUuid;
            UUID ringUuid = ((ItemRingOfRecruitment)ring.func_77973_b()).getRingUuid(ring);
            if (recruited != null && ringUuid != null && (recruitedRingUuid = recruited.getRingUuid()) != null && !ringUuid.equals(recruitedRingUuid)) {
                return ItemStack.field_190927_a;
            }
            return ring;
        }
        return ItemStack.field_190927_a;
    }
}

