/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.biome.spawning;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.management.PlayerChunkMapEntry;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import thebetweenlands.api.entity.spawning.IBiomeSpawnEntriesData;
import thebetweenlands.api.entity.spawning.ICustomSpawnEntriesProvider;
import thebetweenlands.common.config.BetweenlandsConfig;
import thebetweenlands.common.world.WorldProviderBetweenlands;
import thebetweenlands.common.world.biome.spawning.AreaMobSpawner;
import thebetweenlands.common.world.storage.BetweenlandsWorldStorage;

public class WorldMobSpawner
extends AreaMobSpawner {
    public static final WorldMobSpawner INSTANCE = new WorldMobSpawner();
    private static final int CHUNK_GEN_SPAWN_RUNS = 10;
    private static final int SPAWN_CHUNK_MAX_RANGE = 8;
    private static final int SPAWN_CHUNK_MIN_RANGE = 1;
    private static final int MAX_SPAWN_CHUNKS_PER_AREA = 280;

    public WorldMobSpawner() {
        this.setStrictDynamicLimit(false);
    }

    @Override
    public float getMaxEntitiesPerSpawnChunkFraction(int spawnerChunks) {
        return (float)BetweenlandsConfig.MOB_SPAWNING.maxEntitiesPerLoadedArea / 280.0f;
    }

    @Override
    public float getLoadedAreasCount(int spawnerChunks) {
        return (float)spawnerChunks / 280.0f;
    }

    @Override
    public IBiomeSpawnEntriesData getSpawnEntriesData(World world, BlockPos pos, ICustomSpawnEntriesProvider provider) {
        BetweenlandsWorldStorage worldStorage;
        if (provider instanceof Biome && (worldStorage = BetweenlandsWorldStorage.forWorld(world)) != null) {
            return worldStorage.getBiomeSpawnEntriesData((Biome)provider);
        }
        return null;
    }

    @Override
    protected void updateSpawnerChunks(WorldServer world, Set<ChunkPos> spawnerChunks) {
        spawnerChunks.clear();
        HashMap<ChunkPos, Boolean> eligibleChunks = new HashMap<ChunkPos, Boolean>();
        for (EntityPlayer entityPlayer : world.field_73010_i) {
            if (entityPlayer.func_175149_v()) continue;
            int cx = MathHelper.func_76128_c((double)(entityPlayer.field_70165_t / 16.0));
            int cz = MathHelper.func_76128_c((double)(entityPlayer.field_70161_v / 16.0));
            for (int xo = -8; xo <= 8; ++xo) {
                for (int zo = -8; zo <= 8; ++zo) {
                    PlayerChunkMapEntry playerchunkmapentry;
                    boolean isBorder = Math.abs(xo) > 1 || Math.abs(zo) > 1;
                    ChunkPos chunkpos = new ChunkPos(xo + cx, zo + cz);
                    if (!world.func_175723_af().func_177730_a(chunkpos) || (playerchunkmapentry = world.func_184164_w().func_187301_b(chunkpos.field_77276_a, chunkpos.field_77275_b)) == null || !playerchunkmapentry.func_187274_e()) continue;
                    if (!isBorder) {
                        eligibleChunks.put(chunkpos, false);
                        continue;
                    }
                    if (eligibleChunks.containsKey(chunkpos)) continue;
                    eligibleChunks.put(chunkpos, true);
                }
            }
        }
        for (Map.Entry entry : eligibleChunks.entrySet()) {
            if (!((Boolean)entry.getValue()).booleanValue()) continue;
            spawnerChunks.add((ChunkPos)entry.getKey());
        }
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            WorldServer world = DimensionManager.getWorld((int)BetweenlandsConfig.WORLD_AND_DIMENSION.dimensionId);
            if (world == null || world.field_73010_i.isEmpty()) {
                return;
            }
            if (world.field_73011_w instanceof WorldProviderBetweenlands && world.func_82736_K().func_82766_b("doMobSpawning") && world.func_82737_E() % 4L == 0L) {
                boolean spawnHostiles = ((WorldProviderBetweenlands)world.field_73011_w).getCanSpawnHostiles();
                boolean spawnAnimals = ((WorldProviderBetweenlands)world.field_73011_w).getCanSpawnAnimals();
                this.populate(world, spawnHostiles, spawnAnimals);
            }
        }
    }

    public void populateChunk(WorldServer world, int chunkX, int chunkZ) {
        if (world == null || world.field_73011_w.getDimension() != BetweenlandsConfig.WORLD_AND_DIMENSION.dimensionId) {
            return;
        }
        if (world.field_73011_w instanceof WorldProviderBetweenlands && world.func_82736_K().func_82766_b("doMobSpawning")) {
            boolean spawnHostiles = ((WorldProviderBetweenlands)world.field_73011_w).getCanSpawnHostiles();
            boolean spawnAnimals = ((WorldProviderBetweenlands)world.field_73011_w).getCanSpawnAnimals();
            int spawnedEntities = 0;
            spawnedEntities += this.populateChunk((World)world, new ChunkPos(chunkX, chunkZ), spawnHostiles, spawnAnimals, false, true, this.getSpawningAttempsPerChunk() * 10, 60, this.getSpawningAttemptsPerGroup(), this.getHardEntityLimit(), 1.0f);
        }
    }
}

