/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.event;

import com.google.common.base.Predicate;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import thebetweenlands.common.world.WorldProviderBetweenlands;
import thebetweenlands.common.world.event.BLEnvironmentEventRegistry;
import thebetweenlands.common.world.event.TimedEnvironmentEvent;

public class EventThunderstorm
extends TimedEnvironmentEvent {
    protected int updateLCG = new Random().nextInt();
    public static final ResourceLocation ID = new ResourceLocation("thebetweenlands", "thunderstorm");

    public EventThunderstorm(BLEnvironmentEventRegistry registry) {
        super(registry);
    }

    @Override
    protected boolean canActivate() {
        return this.getRegistry().heavyRain.isActive();
    }

    @Override
    public ResourceLocation getEventName() {
        return ID;
    }

    @Override
    public void update(World world) {
        super.update(world);
        if (!world.field_72995_K) {
            if (this.isActive() && !this.getRegistry().heavyRain.isActive()) {
                this.setActive(false);
            }
            if (this.isActive() && world.field_73011_w instanceof WorldProviderBetweenlands && world instanceof WorldServer) {
                WorldServer worldServer = (WorldServer)world;
                Iterator iterator = worldServer.getPersistentChunkIterable(worldServer.func_184164_w().func_187300_b());
                while (iterator.hasNext()) {
                    Chunk chunk = (Chunk)iterator.next();
                    if (!world.field_73011_w.canDoLightning(chunk) || world.field_73012_v.nextInt(30000) != 0) continue;
                    this.updateLCG = this.updateLCG * 3 + 1013904223;
                    int l = this.updateLCG >> 2;
                    BlockPos pos = this.adjustPosToNearbyEntity(worldServer, new BlockPos(chunk.field_76635_g * 16 + (l & 0xF), 0, chunk.field_76647_h * 16 + (l >> 8 & 0xF)));
                    if (!world.func_175727_C(pos)) continue;
                    world.func_72942_c((Entity)new EntityLightningBolt(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), false));
                }
            }
        }
    }

    protected BlockPos adjustPosToNearbyEntity(final WorldServer world, BlockPos pos) {
        BlockPos blockpos = world.func_175725_q(pos);
        AxisAlignedBB aabb = new AxisAlignedBB(blockpos, new BlockPos(blockpos.func_177958_n(), world.func_72800_K(), blockpos.func_177952_p())).func_186662_g(3.0);
        List list = world.func_175647_a(EntityLivingBase.class, aabb, (Predicate)new Predicate<EntityLivingBase>(){

            public boolean apply(@Nullable EntityLivingBase entity) {
                return entity != null && entity.func_70089_S() && world.func_175678_i(entity.func_180425_c());
            }
        });
        if (!list.isEmpty()) {
            return ((EntityLivingBase)list.get(world.field_73012_v.nextInt(list.size()))).func_180425_c();
        }
        if (blockpos.func_177956_o() == -1) {
            blockpos = blockpos.func_177981_b(2);
        }
        return blockpos;
    }

    @Override
    public int getOffTime(Random rnd) {
        return 5000 + rnd.nextInt(4000);
    }

    @Override
    public int getOnTime(Random rnd) {
        return 4000 + rnd.nextInt(4000);
    }
}

