/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.event;

import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Iterator;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.api.event.UpdateFogEvent;
import thebetweenlands.api.misc.Fog;
import thebetweenlands.api.misc.FogState;
import thebetweenlands.common.TheBetweenlands;
import thebetweenlands.common.block.container.BlockPresent;
import thebetweenlands.common.block.terrain.BlockSnowBetweenlands;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.registries.LootTableRegistry;
import thebetweenlands.common.registries.ModelRegistry;
import thebetweenlands.common.tile.TileEntityPresent;
import thebetweenlands.common.world.WorldProviderBetweenlands;
import thebetweenlands.common.world.event.BLEnvironmentEventRegistry;
import thebetweenlands.common.world.event.SeasonalEnvironmentEvent;

public class EventWinter
extends SeasonalEnvironmentEvent {
    public static final ResourceLocation ID = new ResourceLocation("thebetweenlands", "winter");
    private static final long WINTER_DATE = new GregorianCalendar(Calendar.getInstance().get(1), 11, 1, 0, 0).getTime().getTime();

    public EventWinter(BLEnvironmentEventRegistry registry) {
        super(registry);
    }

    @Override
    public long getStartDateInMs() {
        return WINTER_DATE;
    }

    @Override
    public int getDurationInDays() {
        return 31;
    }

    public static boolean isFroooosty(World world) {
        WorldProviderBetweenlands provider;
        if (world != null && (provider = WorldProviderBetweenlands.getProvider(world)) != null) {
            return provider.getEnvironmentEventRegistry().winter.isActive();
        }
        return false;
    }

    @Override
    public ResourceLocation getEventName() {
        return ID;
    }

    @Override
    public void setActive(boolean active) {
        if (active != this.isActive() && TheBetweenlands.proxy.getClientWorld() != null && TheBetweenlands.proxy.getClientPlayer() != null) {
            EventWinter.updateModelActiveState(active);
            EntityPlayer player = TheBetweenlands.proxy.getClientPlayer();
            int px = MathHelper.func_76128_c((double)player.field_70165_t) - 256;
            int py = MathHelper.func_76128_c((double)player.field_70163_u) - 256;
            int pz = MathHelper.func_76128_c((double)player.field_70161_v) - 256;
            TheBetweenlands.proxy.getClientWorld().func_147458_c(px, py, pz, px + 512, py + 512, pz + 512);
        }
        super.setActive(active);
    }

    @Override
    public void update(World world) {
        super.update(world);
        if (!world.field_72995_K && this.isActive() && world.field_73011_w instanceof WorldProviderBetweenlands && world instanceof WorldServer && world.field_73012_v.nextInt(10) == 0) {
            WorldServer worldServer = (WorldServer)world;
            Iterator iterator = worldServer.getPersistentChunkIterable(worldServer.func_184164_w().func_187300_b());
            while (iterator.hasNext()) {
                IBlockState stateAbove;
                Chunk chunk = (Chunk)iterator.next();
                int cbx = world.field_73012_v.nextInt(16);
                int cbz = world.field_73012_v.nextInt(16);
                BlockPos pos = chunk.func_177440_h(new BlockPos(chunk.func_76632_l().func_180334_c() + cbx, -999, chunk.func_76632_l().func_180333_d() + cbz)).func_177977_b();
                if (world.func_175623_d(pos.func_177984_a()) && world.func_180495_p(pos).func_177230_c() == BlockRegistry.SWAMP_WATER && world.field_73012_v.nextInt(3) == 0) {
                    boolean hasSuitableNeighbourBlock = false;
                    BlockPos.PooledMutableBlockPos checkPos = BlockPos.PooledMutableBlockPos.func_185346_s();
                    for (EnumFacing dir : EnumFacing.field_176754_o) {
                        checkPos.func_181079_c(pos.func_177958_n() + dir.func_82601_c(), pos.func_177956_o(), pos.func_177952_p() + dir.func_82599_e());
                        if (world.func_175667_e((BlockPos)checkPos)) {
                            IBlockState neighourState;
                            if (hasSuitableNeighbourBlock || (neighourState = world.func_180495_p((BlockPos)checkPos)).func_177230_c() != BlockRegistry.BLACK_ICE && !neighourState.isSideSolid((IBlockAccess)world, (BlockPos)checkPos, dir.func_176734_d())) continue;
                            hasSuitableNeighbourBlock = true;
                            continue;
                        }
                        hasSuitableNeighbourBlock = false;
                        break;
                    }
                    checkPos.func_185344_t();
                    if (hasSuitableNeighbourBlock) {
                        world.func_175656_a(pos, BlockRegistry.BLACK_ICE.func_176223_P());
                    }
                }
                if (world.field_73012_v.nextInt(3000) != 0 || world.func_184137_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 64.0, false) != null || !world.isSideSolid(pos, EnumFacing.UP) || (stateAbove = world.func_180495_p(pos.func_177984_a())).func_177230_c() != Blocks.field_150350_a && (!(stateAbove.func_177230_c() instanceof BlockSnowBetweenlands) || (Integer)stateAbove.func_177229_b((IProperty)BlockSnowBetweenlands.field_176315_a) > 5)) continue;
                world.func_175656_a(pos.func_177984_a(), BlockRegistry.PRESENT.func_176223_P().func_177226_a(BlockPresent.COLOR, (Comparable)EnumDyeColor.values()[world.field_73012_v.nextInt(EnumDyeColor.values().length)]));
                TileEntityPresent tile = BlockPresent.getTileEntity((IBlockAccess)world, pos.func_177984_a());
                if (tile == null) continue;
                tile.setLootTable(LootTableRegistry.PRESENT, world.field_73012_v.nextLong());
                tile.func_70296_d();
            }
        }
    }

    @Override
    protected void showStatusMessage(EntityPlayer player) {
        player.func_146105_b((ITextComponent)new TextComponentTranslation("chat.event.winter", new Object[0]), true);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        if (world != null && world.field_73011_w instanceof WorldProviderBetweenlands) {
            EventWinter.updateModelActiveState(((WorldProviderBetweenlands)world.field_73011_w).getEnvironmentEventRegistry().winter.isActive());
        } else {
            EventWinter.updateModelActiveState(false);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static void updateModelActiveState(boolean active) {
        ModelRegistry.WINTER_EVENT.setActive(active);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    @SideOnly(value=Side.CLIENT)
    public static void onUpdateFog(UpdateFogEvent event) {
        World world = event.getWorld();
        if (world.field_73011_w instanceof WorldProviderBetweenlands && ((WorldProviderBetweenlands)world.field_73011_w).getEnvironmentEventRegistry().winter.isActive()) {
            Fog targetFog = event.getAmbientFog();
            float interp = (float)MathHelper.func_151237_a((double)((Minecraft.func_71410_x().field_71439_g.field_70163_u - 110.0 + 10.0) / 10.0), (double)0.0, (double)1.0);
            float snowingStrength = ((WorldProviderBetweenlands)world.field_73011_w).getEnvironmentEventRegistry().snowfall.getSnowingStrength();
            FogState state = event.getFogState();
            Fog.MutableFog newFog = new Fog.MutableFog(event.getAmbientFog());
            float newStart = Math.min(2.0f + event.getFarPlaneDistance() * 0.8f / (1.0f + snowingStrength), targetFog.getStart());
            newFog.setStart(targetFog.getStart() + (newStart - targetFog.getStart()) * interp);
            float newEnd = Math.min(8.0f + event.getFarPlaneDistance() / (1.0f + snowingStrength * 0.5f), targetFog.getEnd());
            newFog.setEnd(targetFog.getEnd() + (newEnd - targetFog.getEnd()) * interp);
            float fogBrightness = MathHelper.func_76131_a((float)(0.2f * snowingStrength), (float)0.5f, (float)0.8f);
            newFog.setColor(targetFog.getRed() + (fogBrightness - targetFog.getRed()) * interp, targetFog.getGreen() + (fogBrightness - targetFog.getGreen()) * interp, targetFog.getBlue() + (fogBrightness - targetFog.getBlue()) * interp);
            newFog.setColorIncrement(Math.max(targetFog.getColorIncrement(), 0.008f));
            state.setTargetFog(newFog.toImmutable());
        }
    }
}

