/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.gen;

import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkPrimer;

public interface IBlockStateAccessOnly {
    public boolean isAirBlock(BlockPos var1);

    public IBlockState getBlockState(BlockPos var1);

    public void setBlockState(BlockPos var1, IBlockState var2);

    public void setBlockState(BlockPos var1, IBlockState var2, int var3);

    public static IBlockStateAccessOnly from(final World world) {
        return new IBlockStateAccessOnly(){

            @Override
            public boolean isAirBlock(BlockPos pos) {
                return world.func_175623_d(pos);
            }

            @Override
            public IBlockState getBlockState(BlockPos pos) {
                return world.func_180495_p(pos);
            }

            @Override
            public void setBlockState(BlockPos pos, IBlockState state) {
                world.func_175656_a(pos, state);
            }

            @Override
            public void setBlockState(BlockPos pos, IBlockState state, int flags) {
                world.func_180501_a(pos, state, flags);
            }
        };
    }

    public static IBlockStateAccessOnly from(final int chunkX, final int chunkZ, final ChunkPrimer primer) {
        return new IBlockStateAccessOnly(){

            @Override
            public boolean isAirBlock(BlockPos pos) {
                return primer.func_177856_a(pos.func_177958_n() - chunkX * 16, pos.func_177956_o(), pos.func_177952_p() - chunkZ * 16) == Blocks.field_150350_a.func_176223_P();
            }

            @Override
            public IBlockState getBlockState(BlockPos pos) {
                return primer.func_177856_a(pos.func_177958_n() - chunkX * 16, pos.func_177956_o(), pos.func_177952_p() - chunkZ * 16);
            }

            @Override
            public void setBlockState(BlockPos pos, IBlockState state) {
                primer.func_177855_a(pos.func_177958_n() - chunkX * 16, pos.func_177956_o(), pos.func_177952_p() - chunkZ * 16, state);
            }

            @Override
            public void setBlockState(BlockPos pos, IBlockState state, int flags) {
                primer.func_177855_a(pos.func_177958_n() - chunkX * 16, pos.func_177956_o(), pos.func_177952_p() - chunkZ * 16, state);
            }
        };
    }
}

