/*
 * Decompiled with CFR 0.152.
 */
package net.gobbob.mobends.client.gui.nodeeditor;

import java.util.ArrayList;
import java.util.List;
import net.gobbob.mobends.client.gui.GuiBendsMenu;
import net.gobbob.mobends.client.gui.nodeeditor.GuiAnimationSection;
import net.gobbob.mobends.client.gui.nodeeditor.GuiCalculation;
import net.gobbob.mobends.client.gui.nodeeditor.GuiParameterEditor;
import net.gobbob.mobends.pack.BendsAction;
import net.gobbob.mobends.pack.BendsCondition;
import net.gobbob.mobends.pack.BendsTarget;
import net.gobbob.mobends.util.Draw;
import net.gobbob.mobends.util.EnumAxis;
import net.minecraft.client.Minecraft;

public class GuiAnimationNode {
    public static final int HEIGHT = 15;
    public static int ADD_NODE_WIDTH = 20;
    private GuiAnimationSection parentSection;
    private GuiParameterEditor parameterEditor;
    private List<GuiCalculation> calculations;
    private EnumAxis axis;
    private BendsAction.EnumBoxProperty property;
    private BendsAction.EnumModifier modifier;
    private String model;
    private int width = 0;
    public boolean hover;
    private boolean selected;
    private int addNodeX;
    private boolean addNodeHover;
    private int modifierWidth;

    public GuiAnimationNode(GuiAnimationSection parentSection) {
        this.parentSection = parentSection;
        this.calculations = new ArrayList<GuiCalculation>();
        this.parameterEditor = this.parentSection.getNodeEditor().getParameterEditor();
        this.axis = null;
        this.property = BendsAction.EnumBoxProperty.ROT;
        this.addNodeX = 0;
        this.addNodeHover = false;
    }

    public GuiAnimationNode(GuiAnimationSection parentSection, BendsAction action) {
        this(parentSection);
        this.axis = action.axis;
        this.property = action.property;
        for (int i = 0; i < action.calculations.size(); ++i) {
            this.calculations.add(new GuiCalculation(this, action.calculations.get(i)));
        }
        this.setModel(action.model);
        this.setModifier(action.modifier);
    }

    public int display(int x, int y) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(GuiBendsMenu.ICONS_TEXTURE);
        int textureX = this.selected ? 28 : (this.hover ? 14 : 0);
        Draw.texturedModalRect(x + 16, y, textureX, 16, 3, 16);
        Draw.texturedModalRect(x + 16 + 3, y, this.width, 16, textureX + 3, 16, 1, 16);
        Draw.texturedModalRect(x + 16 + 3 + this.width, y, textureX + 4, 16, 1, 16);
        Draw.texturedModalRect(x + 16 + 3 + this.width + 1, y, 26, 16, textureX + 3, 16, 1, 16);
        Draw.texturedModalRect(x + 16 + 3 + this.width + 1 + 26, y, textureX + 5, 16, 9, 16);
        int propertyTextureX = 81 + this.property.ordinal() * 10;
        Draw.texturedModalRect(x + 16 + 3 + this.width + 4, y + 2, propertyTextureX, 0, 10, 10);
        Minecraft.func_71410_x().field_71466_p.func_175063_a(this.getModel(), (float)(x + 20), (float)(y + 3), 0xFFFFFF);
        Minecraft.func_71410_x().field_71466_p.func_175063_a(this.getAxisString(), (float)(x + 16 + 3 + this.width + 18), (float)(y + 3), 0xFFFFFF);
        if (this.modifier != null) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(GuiBendsMenu.ICONS_TEXTURE);
            int modifierTextureX = this.selected ? 34 : (this.hover ? 17 : 0);
            Draw.thsPuzzle(x + this.width + 46, y, 7, this.modifierWidth, 9, 16, modifierTextureX, 88);
            Minecraft.func_71410_x().field_71466_p.func_175063_a(this.getModifier().name(), (float)(x + this.width + 56), (float)(y + 3), 0xFFFFFF);
        }
        int xOffset = x + this.getVisualWidth();
        for (int i = 0; i < this.calculations.size(); ++i) {
            xOffset = this.calculations.get(i).display(xOffset, y);
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(GuiBendsMenu.ICONS_TEXTURE);
        Draw.texturedModalRect(x + this.addNodeX, y, this.addNodeHover ? 74 : 54, 24, 20, 16);
        return y += 15;
    }

    private String getAxisString() {
        return this.axis == null ? "?" : this.axis.toString();
    }

    public void setModel(String model) {
        this.model = model;
        this.width = Minecraft.func_71410_x().field_71466_p.func_78256_a(model) + 5;
        this.updateAddNodeX();
    }

    public String getModel() {
        return this.model;
    }

    public int getVisualWidth() {
        return this.width + 48 + (this.modifier != null ? this.modifierWidth + 7 : 0);
    }

    public void update(int x, int y, int mouseX, int mouseY) {
        int xOffset = x + this.getVisualWidth();
        for (int i = 0; i < this.calculations.size(); ++i) {
            this.calculations.get(i).update(xOffset, y, mouseX, mouseY);
            xOffset += this.calculations.get(i).getVisualWidth();
        }
        this.hover = mouseX >= x + 16 && mouseX < x + this.getVisualWidth() && mouseY >= y && mouseY < y + 15;
        this.addNodeHover = mouseX >= x + this.addNodeX && mouseX < x + this.addNodeX + ADD_NODE_WIDTH && mouseY >= y && mouseY < y + 15;
    }

    public GuiAnimationSection getParentSection() {
        return this.parentSection;
    }

    public boolean onMousePressed(int x, int y, int event) {
        boolean pressed = false;
        this.selected = this.hover;
        if (this.selected) {
            this.getParameterEditor().select(this);
        }
        for (int i = 0; i < this.calculations.size(); ++i) {
            if (!this.calculations.get(i).onMousePressed(x, y, event)) continue;
            pressed = true;
        }
        if (this.addNodeHover) {
            this.getParameterEditor().select(this.addCalculation());
            pressed = true;
        }
        return pressed || this.selected;
    }

    private GuiParameterEditor getParameterEditor() {
        return this.parameterEditor;
    }

    public void onMouseReleased(int x, int y, int event) {
    }

    public void applyChanges(BendsTarget target, BendsCondition condition) {
        BendsAction action = new BendsAction(this.model, this.property, this.axis, 1.0f);
        action.setModifier(this.modifier);
        condition.addAction(action);
        for (int i = 0; i < this.calculations.size(); ++i) {
            this.calculations.get(i).applyChanges(target, action);
        }
    }

    public void setProperty(BendsAction.EnumBoxProperty property) {
        this.property = property;
    }

    public BendsAction.EnumBoxProperty getProperty() {
        return this.property;
    }

    public void setAxis(EnumAxis axis) {
        this.axis = axis;
    }

    public EnumAxis getAxis() {
        return this.axis;
    }

    public void setModifier(BendsAction.EnumModifier modifier) {
        this.modifier = modifier;
        if (modifier != null) {
            this.modifierWidth = Minecraft.func_71410_x().field_71466_p.func_78256_a(modifier.name()) + 7;
        }
        this.updateAddNodeX();
    }

    public BendsAction.EnumModifier getModifier() {
        return this.modifier;
    }

    public GuiCalculation addCalculation() {
        GuiCalculation calculation = new GuiCalculation(this);
        this.calculations.add(calculation);
        this.addNodeX += calculation.getVisualWidth();
        this.getParentSection().getNodeEditor().onChange();
        return calculation;
    }

    public void removeCalculation(GuiCalculation guiCalculation) {
        if (this.calculations.remove(guiCalculation)) {
            this.addNodeX -= guiCalculation.getVisualWidth();
        }
        this.parentSection.getNodeEditor().onChange();
    }

    public void remove() {
        this.parentSection.removeNode(this);
    }

    public void updateAddNodeX() {
        this.addNodeX = this.getVisualWidth();
        for (int i = 0; i < this.calculations.size(); ++i) {
            this.addNodeX += this.calculations.get(i).getVisualWidth();
        }
    }

    public int getGlobalWidth() {
        int globalWidth = 32 + this.getVisualWidth();
        for (int i = 0; i < this.calculations.size(); ++i) {
            globalWidth += this.calculations.get(i).getVisualWidth();
        }
        return globalWidth;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }
}

