/*
 * Decompiled with CFR 0.152.
 */
package net.gobbob.mobends.client.gui.nodeeditor;

import net.gobbob.mobends.client.gui.GuiBendsMenu;
import net.gobbob.mobends.client.gui.nodeeditor.GuiAnimationNode;
import net.gobbob.mobends.client.gui.nodeeditor.GuiParameterEditor;
import net.gobbob.mobends.pack.BendsAction;
import net.gobbob.mobends.pack.BendsTarget;
import net.gobbob.mobends.util.Draw;
import net.minecraft.client.Minecraft;

public class GuiCalculation {
    public BendsAction.EnumOperator operator;
    public float number;
    public String globalVar = null;
    public int width = 0;
    public String displayedText;
    public boolean hover;
    private boolean selected;
    private GuiAnimationNode parentNode;
    private GuiParameterEditor parameterEditor;

    public GuiCalculation(GuiAnimationNode parentNode) {
        this.parentNode = parentNode;
        this.parameterEditor = parentNode.getParentSection().getNodeEditor().getParameterEditor();
        this.operator = BendsAction.EnumOperator.SET;
        this.number = 0.0f;
        this.globalVar = null;
        this.setDisplayedText(String.valueOf(this.number));
    }

    public GuiCalculation(GuiAnimationNode parentNode, BendsAction.Calculation calculation) {
        this(parentNode);
        this.operator = calculation.operator;
        this.number = calculation.number;
        this.globalVar = calculation.globalVar;
        if (this.globalVar != null) {
            this.setDisplayedText(this.globalVar + "");
        } else {
            this.setDisplayedText(String.valueOf(this.number));
        }
    }

    public int display(int x, int y) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(GuiBendsMenu.ICONS_TEXTURE);
        int textureX = this.isSelected() ? 36 : (this.hover ? 18 : 0);
        Draw.thsPuzzle(x, y, 8, this.width, 9, 16, textureX, 32);
        int operatorTextureX = 21 + this.operator.ordinal() * 6;
        Draw.texturedModalRect(x + 6, y + 4, operatorTextureX, 0, 6, 6);
        Minecraft.func_71410_x().field_71466_p.func_175063_a(this.displayedText, (float)(x + 17), (float)(y + 3), 0xFFFFFF);
        return x + this.getVisualWidth();
    }

    public void update(int x, int y, int mouseX, int mouseY) {
        this.hover = mouseX >= x && mouseX < x + this.getVisualWidth() && mouseY >= y && mouseY < y + 15;
    }

    public void setValue(float f) {
        this.number = f;
        this.globalVar = null;
        this.setDisplayedText(String.valueOf(this.number));
    }

    public float getValue() {
        return this.number;
    }

    public void setGlobalVariable(String arg0) {
        this.globalVar = arg0;
        if (this.globalVar != null) {
            this.setDisplayedText(this.globalVar + "");
        } else {
            this.setDisplayedText(String.valueOf(this.number));
        }
    }

    public String getGlobalVariable() {
        return this.globalVar;
    }

    public void setDisplayedText(String arg0) {
        this.displayedText = arg0;
        this.width = Minecraft.func_71410_x().field_71466_p.func_78256_a(this.displayedText) + 12;
    }

    public int getVisualWidth() {
        return this.width + 10;
    }

    public GuiParameterEditor getParameterEditor() {
        return this.parameterEditor;
    }

    public boolean onMousePressed(int x, int y, int event) {
        this.setSelected(this.hover);
        if (this.isSelected()) {
            this.getParameterEditor().select(this);
        }
        return this.isSelected();
    }

    public void onMouseReleased(int x, int y, int event) {
    }

    public GuiAnimationNode getParentNode() {
        return this.parentNode;
    }

    public void applyChanges(BendsTarget target, BendsAction action) {
        action.calculations.add(new BendsAction.Calculation(this.operator, this.number).setGlobalVar(this.globalVar));
    }

    public void remove() {
        this.parentNode.removeCalculation(this);
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }
}

