/*
 * Decompiled with CFR 0.152.
 */
package net.gobbob.mobends.client.gui.popup;

import java.util.ArrayList;
import java.util.List;
import net.gobbob.mobends.client.gui.GuiBendsMenu;
import net.gobbob.mobends.client.gui.popup.GuiPopUp;
import net.gobbob.mobends.util.Draw;
import net.gobbob.mobends.util.GUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;

public class GuiPopUpHelp
extends GuiPopUp {
    public static final int WIDTH = 200;
    protected int exitBtnX;
    protected int exitBtnY;
    protected boolean exitBtnHovered;
    protected List<Pair> definitions;

    public GuiPopUpHelp(int action) {
        super(I18n.func_135052_a((String)"mobends.gui.help", (Object[])new Object[0]), action, new String[0]);
        this.width = 200;
        this.height = 80;
        this.exitBtnHovered = false;
        this.definitions = new ArrayList<Pair>();
        this.definitions.add(new Pair(this.fontRenderer, "Left Click", "select nodes."));
        this.definitions.add(new Pair(this.fontRenderer, "Middle/Right Click", "scroll around the node editor."));
        int titleMaxWidth = 0;
        for (Pair pair : this.definitions) {
            if (pair.getTitleWidth() <= titleMaxWidth) continue;
            titleMaxWidth = pair.getTitleWidth();
        }
        for (Pair pair : this.definitions) {
            pair.updateLines(titleMaxWidth);
        }
    }

    @Override
    public void initGui(int x, int y) {
        super.initGui(x, y);
        this.exitBtnX = this.x + this.width - 10;
        this.exitBtnY = this.y - 2;
    }

    @Override
    public void display(int mouseX, int mouseY, float partialTicks) {
        super.display(mouseX, mouseY, partialTicks);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(GuiBendsMenu.ICONS_TEXTURE);
        int textureX = this.exitBtnHovered ? 42 : 30;
        Draw.texturedModalRect(this.exitBtnX, this.exitBtnY, textureX, 76, 12, 12);
        int yOffset = this.y + 24;
        for (Pair pair : this.definitions) {
            this.fontRenderer.func_175063_a(pair.getTitle(), (float)(this.x + 10), (float)yOffset, 0xFFFFAA);
            for (String line : pair.getDefinitionLines()) {
                this.fontRenderer.func_175063_a(line, (float)(this.x + 15 + pair.getTitleOffset()), (float)yOffset, 0xFFFFFF);
                yOffset += 10;
            }
            yOffset += 10;
        }
    }

    @Override
    public void update(int mouseX, int mouseY) {
        super.update(mouseX, mouseY);
        this.exitBtnHovered = mouseX >= this.exitBtnX && mouseX <= this.exitBtnX + 12 && mouseY >= this.exitBtnY && mouseY <= this.exitBtnY + 12;
    }

    @Override
    public int mouseClicked(int mouseX, int mouseY, int state) {
        if (this.exitBtnHovered) {
            return 0;
        }
        return -1;
    }

    private static class Pair {
        FontRenderer fontRenderer;
        String title;
        String definition;
        String[] definitionLines;
        int titleMaxWidth;

        public Pair(FontRenderer fontRenderer, String title, String definition) {
            this.title = title;
            this.definition = definition;
            this.fontRenderer = fontRenderer;
        }

        public String getTitle() {
            return this.title;
        }

        public String[] getDefinitionLines() {
            return this.definitionLines;
        }

        public int getTitleWidth() {
            return this.fontRenderer.func_78256_a(this.title);
        }

        public void updateLines(int titleMaxWidth) {
            this.titleMaxWidth = titleMaxWidth;
            this.definitionLines = GUtil.squashText(this.fontRenderer, this.definition, 200 - titleMaxWidth - 40);
            for (int i = 0; i < this.definitionLines.length; ++i) {
                this.definitionLines[i] = this.definitionLines[i].trim();
            }
        }

        public int getLines() {
            return this.definitionLines.length;
        }

        public int getTitleOffset() {
            return this.titleMaxWidth;
        }
    }
}

