/*
 * Decompiled with CFR 0.152.
 */
package net.gobbob.mobends.client.renderer;

import java.util.HashMap;
import net.gobbob.mobends.client.event.DataUpdateHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.util.math.Vec3d;

public class ArrowTrail {
    int id;
    TrailNode[] nodes;
    float spawnCooldown = 0.0f;
    static HashMap<Integer, ArrowTrail> trailMap = new HashMap();
    public static final int MAX_LENGTH = 10;
    public static final float MAX_SPAWN_COOLDOWN = 1.0f;
    public static long time = System.nanoTime() / 1000L;
    public static long lastTime = System.nanoTime() / 1000L;

    public ArrowTrail(int id) {
        this.id = id;
        this.spawnCooldown = 1.0f;
    }

    public void doRender(EntityArrow entity, double x, double y, double z, float partialTicks) {
        Vec3d forward = entity.func_189651_aD();
        forward = new Vec3d(-forward.field_72450_a, -forward.field_72448_b, forward.field_72449_c);
        Vec3d up = Vec3d.func_189986_a((float)(entity.field_70125_A + 90.0f), (float)entity.field_70177_z);
        up = new Vec3d(-up.field_72450_a, -up.field_72448_b, up.field_72449_c);
        Vec3d right = forward.func_72431_c(up);
        if (this.nodes == null) {
            this.nodes = new TrailNode[10];
            this.resetNodes(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, up, right);
        }
        if (this.spawnCooldown > 40.0f) {
            this.spawnCooldown = 0.0f;
            this.resetNodes(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, up, right);
        }
        while (this.spawnCooldown >= 1.0f) {
            for (int i = 9; i > 0; --i) {
                this.nodes[i].moveTo(this.nodes[i - 1]);
            }
            this.nodes[0].moveTo(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, up, right);
            this.spawnCooldown -= 1.0f;
        }
        this.renderNodes(entity, partialTicks);
    }

    public void resetNodes(double x, double y, double z, Vec3d up, Vec3d right) {
        for (int i = 0; i < 10; ++i) {
            this.nodes[i] = new TrailNode(x, y, z, up, right);
        }
    }

    public void renderNodes(EntityArrow entity, float partialTicks) {
        Entity viewEntity = Minecraft.func_71410_x().func_175606_aa();
        if (viewEntity == null) {
            return;
        }
        Vec3d viewPos = new Vec3d(viewEntity.field_70169_q + (viewEntity.field_70165_t - viewEntity.field_70169_q) * (double)partialTicks, viewEntity.field_70167_r + (viewEntity.field_70163_u - viewEntity.field_70167_r) * (double)partialTicks, viewEntity.field_70166_s + (viewEntity.field_70161_v - viewEntity.field_70166_s) * (double)partialTicks);
        float r = 1.0f;
        float g = 1.0f;
        float b = 1.0f;
        float a = 0.5f;
        GlStateManager.func_179131_c((float)r, (float)g, (float)b, (float)a);
        GlStateManager.func_179094_E();
        GlStateManager.func_179090_x();
        GlStateManager.func_179140_f();
        GlStateManager.func_179129_p();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexbuffer = tessellator.func_178180_c();
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        for (int i = 1; i < 10; ++i) {
            TrailNode node0 = this.nodes[i - 1];
            TrailNode node1 = this.nodes[i];
            Vec3d pos0 = new Vec3d(node0.x - viewPos.field_72450_a, node0.y - viewPos.field_72448_b, node0.z - viewPos.field_72449_c);
            Vec3d pos1 = new Vec3d(node1.x - viewPos.field_72450_a, node1.y - viewPos.field_72448_b, node1.z - viewPos.field_72449_c);
            float scale0 = (float)(10 - i) / 10.0f * 0.1f;
            float scale1 = (10.0f - (float)i - 1.0f) / 10.0f * 0.1f;
            if (i == 1) {
                scale1 = 0.0f;
            }
            Vec3d up0 = node0.up;
            Vec3d right0 = node0.right;
            Vec3d up1 = node1.up;
            Vec3d right1 = node1.right;
            vertexbuffer.func_181662_b(pos0.field_72450_a + -right0.field_72450_a * (double)scale0, pos0.field_72448_b + -right0.field_72448_b * (double)scale0, pos0.field_72449_c + -right0.field_72449_c * (double)scale0).func_187315_a(0.0, 0.15625).func_181675_d();
            vertexbuffer.func_181662_b(pos0.field_72450_a + right0.field_72450_a * (double)scale0, pos0.field_72448_b + right0.field_72448_b * (double)scale0, pos0.field_72449_c + right0.field_72449_c * (double)scale0).func_187315_a(0.0, 0.15625).func_181675_d();
            vertexbuffer.func_181662_b(pos1.field_72450_a + right1.field_72450_a * (double)scale1, pos1.field_72448_b + right1.field_72448_b * (double)scale1, pos1.field_72449_c + right1.field_72449_c * (double)scale1).func_187315_a(0.0, 0.15625).func_181675_d();
            vertexbuffer.func_181662_b(pos1.field_72450_a + -right1.field_72450_a * (double)scale1, pos1.field_72448_b + -right1.field_72448_b * (double)scale1, pos1.field_72449_c + -right1.field_72449_c * (double)scale1).func_187315_a(0.0, 0.15625).func_181675_d();
            vertexbuffer.func_181662_b(pos0.field_72450_a + -up0.field_72450_a * (double)scale0, pos0.field_72448_b + -up0.field_72448_b * (double)scale0, pos0.field_72449_c + -up0.field_72449_c * (double)scale0).func_187315_a(0.0, 0.15625).func_181675_d();
            vertexbuffer.func_181662_b(pos0.field_72450_a + up0.field_72450_a * (double)scale0, pos0.field_72448_b + up0.field_72448_b * (double)scale0, pos0.field_72449_c + up0.field_72449_c * (double)scale0).func_187315_a(0.0, 0.15625).func_181675_d();
            vertexbuffer.func_181662_b(pos1.field_72450_a + up1.field_72450_a * (double)scale1, pos1.field_72448_b + up1.field_72448_b * (double)scale1, pos1.field_72449_c + up1.field_72449_c * (double)scale1).func_187315_a(0.0, 0.15625).func_181675_d();
            vertexbuffer.func_181662_b(pos1.field_72450_a + -up1.field_72450_a * (double)scale1, pos1.field_72448_b + -up1.field_72448_b * (double)scale1, pos1.field_72449_c + -up1.field_72449_c * (double)scale1).func_187315_a(0.0, 0.15625).func_181675_d();
        }
        tessellator.func_78381_a();
        GlStateManager.func_179089_o();
        GlStateManager.func_179098_w();
        GlStateManager.func_179145_e();
        GlStateManager.func_179121_F();
    }

    public void renderAxis(EntityArrow entity, double x, double y, double z) {
        Vec3d forward = entity.func_189651_aD();
        forward = new Vec3d(-forward.field_72450_a, -forward.field_72448_b, forward.field_72449_c);
        Vec3d up = Vec3d.func_189986_a((float)(entity.field_70125_A + 90.0f), (float)entity.field_70177_z);
        up = new Vec3d(-up.field_72450_a, -up.field_72448_b, up.field_72449_c);
        Vec3d right = forward.func_72431_c(up);
        GlStateManager.func_179094_E();
        GlStateManager.func_179090_x();
        GlStateManager.func_179140_f();
        GlStateManager.func_179129_p();
        GlStateManager.func_179143_c((int)519);
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexbuffer = tessellator.func_178180_c();
        GlStateManager.func_179131_c((float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        vertexbuffer.func_181668_a(1, DefaultVertexFormats.field_181707_g);
        vertexbuffer.func_181662_b(0.0, 0.0, 0.0).func_187315_a(0.0, 0.15625).func_181675_d();
        vertexbuffer.func_181662_b(right.field_72450_a, right.field_72448_b, right.field_72449_c).func_187315_a(0.15625, 0.15625).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179131_c((float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f);
        vertexbuffer.func_181668_a(1, DefaultVertexFormats.field_181707_g);
        vertexbuffer.func_181662_b(0.0, 0.0, 0.0).func_187315_a(0.0, 0.15625).func_181675_d();
        vertexbuffer.func_181662_b(up.field_72450_a, up.field_72448_b, up.field_72449_c).func_187315_a(0.15625, 0.15625).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179131_c((float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f);
        vertexbuffer.func_181668_a(1, DefaultVertexFormats.field_181707_g);
        vertexbuffer.func_181662_b(0.0, 0.0, 0.0).func_187315_a(0.0, 0.15625).func_181675_d();
        vertexbuffer.func_181662_b(forward.field_72450_a, forward.field_72448_b, forward.field_72449_c).func_187315_a(0.15625, 0.15625).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179143_c((int)515);
        GlStateManager.func_179089_o();
        GlStateManager.func_179098_w();
        GlStateManager.func_179145_e();
        GlStateManager.func_179121_F();
    }

    private boolean shouldBeRemoved() {
        if (Minecraft.func_71410_x().field_71441_e == null) {
            return true;
        }
        return Minecraft.func_71410_x().field_71441_e.func_73045_a(this.id) == null;
    }

    public static ArrowTrail get(int id) {
        ArrowTrail trail;
        if (!trailMap.containsKey(id)) {
            trail = new ArrowTrail(id);
            trailMap.put(id, trail);
        } else {
            trail = trailMap.get(id);
        }
        return trail;
    }

    public static void renderTrail(EntityArrow entity, double x, double y, double z, float partialTicks) {
        ArrowTrail trail = ArrowTrail.get(entity.func_145782_y());
        trail.doRender(entity, x, y, z, partialTicks);
    }

    public static void cleanup() {
        Integer[] keySet = trailMap.keySet().toArray(new Integer[0]);
        for (int i = keySet.length - 1; i >= 0; --i) {
            if (!trailMap.get(keySet[i]).shouldBeRemoved()) continue;
            trailMap.remove(keySet[i]);
        }
    }

    public static void onRenderTick() {
        for (ArrowTrail trail : trailMap.values()) {
            trail.spawnCooldown += DataUpdateHandler.ticksPerFrame;
        }
    }

    static class TrailNode {
        double x;
        double y;
        double z;
        Vec3d up;
        Vec3d right;

        TrailNode(double x, double y, double z, Vec3d up, Vec3d right) {
            this.moveTo(x, y, z, up, right);
        }

        public void moveTo(TrailNode trailNode) {
            this.moveTo(trailNode.x, trailNode.y, trailNode.z, trailNode.up, trailNode.right);
        }

        public void moveTo(double x, double y, double z, Vec3d up, Vec3d right) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.up = up;
            this.right = right;
        }
    }
}

