/*
 * Decompiled with CFR 0.152.
 */
package com.jarhax.prestige;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.jarhax.prestige.api.Reward;
import com.jarhax.prestige.command.CommandPrestige;
import com.jarhax.prestige.compat.crt.IReward;
import com.jarhax.prestige.data.GlobalPrestigeData;
import com.jarhax.prestige.data.PlayerData;
import com.jarhax.prestige.events.CommonEventHandler;
import com.jarhax.prestige.packet.PacketAttemptPurchase;
import com.jarhax.prestige.packet.PacketEditPrestigeGUI;
import com.jarhax.prestige.packet.PacketGiveRewards;
import com.jarhax.prestige.packet.PacketOpenPrestigeGUI;
import com.jarhax.prestige.packet.PacketSyncPrestige;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.darkhax.bookshelf.BookshelfRegistry;
import net.darkhax.bookshelf.network.NetworkHandler;
import net.minecraft.command.ICommand;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber
@Mod(modid="prestige", name="Prestige", version="1.1.30", dependencies="required-after:bookshelf@[2.3.523,)", certificateFingerprint="d476d1b22b218a10d845928d1665d45fce301b27", acceptedMinecraftVersions="[1.12.2]")
public class Prestige {
    public static final Logger LOG = LogManager.getLogger((String)"Prestige");
    public static final NetworkHandler NETWORK = new NetworkHandler("prestige");
    public static final Map<String, Reward> REGISTRY = new HashMap<String, Reward>();
    public static final HashMap<String, List<IReward>> REWARDS = new HashMap();
    @SideOnly(value=Side.CLIENT)
    public static PlayerData clientPlayerData;
    public static final Gson GSON;
    public static File JSON_FILE;
    @Mod.Instance(value="prestige")
    public static Prestige INSTANCE;

    @Mod.EventHandler
    public void onPreInit(FMLPreInitializationEvent event) {
        NETWORK.register(PacketSyncPrestige.class, Side.CLIENT);
        NETWORK.register(PacketOpenPrestigeGUI.class, Side.CLIENT);
        NETWORK.register(PacketEditPrestigeGUI.class, Side.CLIENT);
        NETWORK.register(PacketAttemptPurchase.class, Side.SERVER);
        NETWORK.register(PacketGiveRewards.class, Side.SERVER);
        BookshelfRegistry.addCommand((ICommand)new CommandPrestige());
        JSON_FILE = new File(new File(event.getModConfigurationDirectory(), "prestige"), "rewards.json");
        MinecraftForge.EVENT_BUS.register((Object)new CommonEventHandler());
    }

    @Mod.EventHandler
    public void onFMLInitialization(FMLInitializationEvent event) {
        this.loadRewards();
    }

    public void saveRewards() {
        try {
            if (!JSON_FILE.exists()) {
                JSON_FILE.getParentFile().mkdirs();
                JSON_FILE.createNewFile();
            }
            BufferedWriter writer = new BufferedWriter(new FileWriter(JSON_FILE));
            String json = GSON.toJson((Object)REGISTRY.values().toArray());
            writer.write(json);
            writer.close();
        }
        catch (Exception e) {
            LOG.error("Unable to save Prestige JSON file!", (Throwable)e);
        }
    }

    public void loadRewards() {
        if (JSON_FILE.exists()) {
            REGISTRY.clear();
            try (FileReader reader = new FileReader(JSON_FILE);){
                Reward[] rewards;
                for (Reward reward : rewards = (Reward[])GSON.fromJson((Reader)reader, Reward[].class)) {
                    REGISTRY.put(reward.getIdentifier(), reward);
                }
            }
            catch (IOException e) {
                LOG.error("Unable to read Prestige JSON file!", (Throwable)e);
            }
        }
    }

    @Mod.EventHandler
    public void onServerStart(FMLServerStartingEvent event) {
        GlobalPrestigeData.loadAll();
    }

    @Mod.EventHandler
    public void onServerStop(FMLServerStoppingEvent event) {
        GlobalPrestigeData.saveAll();
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.player instanceof EntityPlayerMP) {
            LOG.info("Syncing requested for " + event.player.func_70005_c_() + ".");
            NETWORK.sendTo((IMessage)new PacketSyncPrestige(GlobalPrestigeData.getPlayerData(event.player)), (EntityPlayerMP)event.player);
        }
    }

    static {
        GSON = new GsonBuilder().setPrettyPrinting().excludeFieldsWithoutExposeAnnotation().create();
    }
}

