/*
 * Decompiled with CFR 0.152.
 */
package com.jarhax.prestige.client.gui;

import com.jarhax.prestige.Prestige;
import com.jarhax.prestige.api.Reward;
import com.jarhax.prestige.client.gui.GuiButtonTooltip;
import com.jarhax.prestige.client.gui.GuiPrestigeBase;
import com.jarhax.prestige.client.gui.objects.GuiObject;
import com.jarhax.prestige.client.gui.objects.GuiObjectBackGround;
import com.jarhax.prestige.client.gui.objects.GuiObjectBorder;
import com.jarhax.prestige.client.gui.objects.editing.GuiObjectEditingReward;
import com.jarhax.prestige.client.gui.objects.editing.GuiObjectItemStack;
import com.jarhax.prestige.client.gui.objects.editing.GuideLine;
import com.jarhax.prestige.client.utils.RenderUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiPrestigeEditing
extends GuiPrestigeBase {
    private GuiObjectBackGround backGround;
    private GuiObjectBorder border;
    private List<GuiObjectEditingReward> unplacedRewards;
    private List<GuiObjectItemStack> stackList;
    private GuiObjectEditingReward selectedReward;
    private int yOff = 0;
    private int stackYOff = 0;
    private GuiObjectEditingReward editingReward;
    private GuiTextField fieldName;
    private GuiTextField fieldDesc;
    private GuiTextField fieldCost;
    private GuiTextField fieldID;
    private GuiTextField fieldFilter;
    private GuiButtonTooltip buttonCreateNewReward;
    private GuiButtonTooltip buttonRemoveReward;
    private GuiButtonTooltip buttonUpdateReward;
    private GuiButtonTooltip buttonSave;
    private GuiButtonTooltip buttonReset;
    private final int north = 0;
    private final int east = 1;
    private final int south = 2;
    private final int west = 3;
    private int stackY = 162;
    public GuiObjectItemStack selectedStack;
    public static final File FILE_TEMP = new File(Prestige.JSON_FILE.getParentFile(), "backup_file.json");
    public boolean saveChanges;

    public void generateRewards() {
        this.unplacedRewards.clear();
        int offX = 0;
        int offY = 0;
        LinkedList<Reward> values = new LinkedList<Reward>(Prestige.REGISTRY.values());
        values.sort(Comparator.comparing(Reward::getIdentifier));
        for (Reward reward : values) {
            GuiObjectEditingReward rew;
            if (reward.isPlaced()) {
                rew = new GuiObjectEditingReward(this, reward);
                rew.setPlaced(true);
            } else {
                rew = new GuiObjectEditingReward(this, this.left - 96 + offX * 32, this.top + offY * 32, reward);
                rew.setPlaced(false);
            }
            this.unplacedRewards.add(rew);
            rew.setGridX(offX);
            rew.setGridY(offY);
            if (++offX != 2) continue;
            offX = 0;
            ++offY;
        }
    }

    public void generateStackList() {
        this.stackList.clear();
        this.stackYOff = 0;
        int offX = 0;
        int offY = 0;
        NonNullList stacks = NonNullList.func_191196_a();
        for (Item item : ForgeRegistries.ITEMS) {
            item.func_150895_a(CreativeTabs.field_78027_g, stacks);
        }
        NonNullList filtered = NonNullList.func_191196_a();
        String filter = this.fieldFilter.func_146179_b().toLowerCase();
        if (filter.length() > 0) {
            for (ItemStack stack : stacks) {
                if (stack == null) {
                    Prestige.LOG.error("INVALID ITEMSTACK!! " + stack);
                    continue;
                }
                if (filter.startsWith("@(") && filter.endsWith(")") && !filter.equalsIgnoreCase("@()")) {
                    String[] mods = filter.split("@\\(")[1].split("\\)")[0].split(";");
                    boolean valid = false;
                    for (String s : mods) {
                        s = s.trim();
                        if (!stack.func_77973_b().getRegistryName().func_110624_b().toLowerCase().startsWith(s.toLowerCase())) continue;
                        valid = true;
                    }
                    if (!valid) continue;
                    filtered.add((Object)stack);
                    continue;
                }
                if (stack.func_82833_r() == null || stack.func_82833_r().isEmpty() || !stack.func_82833_r().toLowerCase().contains(filter)) continue;
                filtered.add((Object)stack);
            }
        }
        if (filtered.isEmpty()) {
            filtered = stacks;
        }
        for (ItemStack stack : filtered) {
            GuiObjectItemStack st = new GuiObjectItemStack(this, this.left + this.guiWidth + 5 + offX * 18, this.top + this.stackY + offY * 18, stack);
            this.stackList.add(st);
            st.setGridX(offX);
            st.setGridY(offY);
            if (++offX != 5) continue;
            offX = 0;
            ++offY;
        }
        if (this.stackList.size() > 0) {
            this.selectedStack = this.stackList.get(0);
        }
    }

    public void func_73866_w_() {
        this.guiWidth = 256;
        this.guiHeight = 256;
        super.func_73866_w_();
        this.left = this.field_146294_l / 2 - this.guiWidth / 2;
        this.top = this.field_146295_m / 2 - this.guiHeight / 2;
        this.guiObjects = new LinkedHashMap();
        this.unplacedRewards = new LinkedList<GuiObjectEditingReward>();
        this.backGround = new GuiObjectBackGround(this, this.left, this.top, this.guiWidth, this.guiHeight);
        this.border = new GuiObjectBorder(this, this.left, this.top, this.guiWidth, this.guiHeight);
        int yOffset = 35;
        int count = 0;
        this.fieldID = new GuiTextField(0, this.field_146289_q, this.left + this.guiWidth + 5, this.top + yOffset + 28 * count++, 100, this.field_146289_q.field_78288_b + 4);
        this.fieldID.func_146203_f(Integer.MAX_VALUE);
        this.fieldName = new GuiTextField(0, this.field_146289_q, this.left + this.guiWidth + 5, this.top + yOffset + 28 * count++, 100, this.field_146289_q.field_78288_b + 4);
        this.fieldName.func_146203_f(Integer.MAX_VALUE);
        this.fieldDesc = new GuiTextField(0, this.field_146289_q, this.left + this.guiWidth + 5, this.top + yOffset + 28 * count++, 100, this.field_146289_q.field_78288_b + 4);
        this.fieldDesc.func_146203_f(Integer.MAX_VALUE);
        this.fieldCost = new GuiTextField(0, this.field_146289_q, this.left + this.guiWidth + 5, this.top + yOffset + 28 * count++, 100, this.field_146289_q.field_78288_b + 4);
        this.fieldCost.func_146203_f(Integer.MAX_VALUE);
        this.fieldFilter = new GuiTextField(0, this.field_146289_q, this.left + this.guiWidth + 5, this.top + yOffset + 28 * count++, 100, this.field_146289_q.field_78288_b + 4);
        this.fieldFilter.func_146203_f(Integer.MAX_VALUE);
        this.fieldCost.func_175205_a(input -> {
            if (input == null || input.isEmpty()) {
                return true;
            }
            try {
                Integer.parseInt(input);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        });
        this.fieldName.func_146184_c(true);
        this.fieldDesc.func_146184_c(true);
        this.fieldCost.func_146184_c(true);
        this.fieldID.func_146184_c(true);
        this.fieldFilter.func_146184_c(true);
        this.fieldCost.func_146180_a("0");
        count = 0;
        this.buttonCreateNewReward = new GuiButtonTooltip(0, this.left + this.guiWidth + 5 + 20 * count++, this.top, 20, 20, "+", this, "Add");
        this.buttonRemoveReward = new GuiButtonTooltip(1, this.left + this.guiWidth + 5 + 20 * count++, this.top, 20, 20, "-", this, "Remove");
        this.buttonUpdateReward = new GuiButtonTooltip(2, this.left + this.guiWidth + 5 + 20 * count++, this.top, 20, 20, "*", this, "Update");
        this.buttonSave = new GuiButtonTooltip(3, this.left + this.guiWidth + 5 + 20 * count++, this.top, 20, 20, "S", this, "Save");
        this.buttonReset = new GuiButtonTooltip(4, this.left + this.guiWidth + 5 + 20 * count, this.top, 20, 20, "R", this, "Reset");
        this.func_189646_b(this.buttonCreateNewReward);
        this.func_189646_b(this.buttonRemoveReward);
        this.func_189646_b(this.buttonUpdateReward);
        this.func_189646_b(this.buttonSave);
        this.func_189646_b(this.buttonReset);
        this.generateRewards();
        this.stackList = new LinkedList<GuiObjectItemStack>();
        this.generateStackList();
    }

    public void func_73876_c() {
        super.func_73876_c();
        for (GuiObject guiObject : this.guiObjects.values()) {
            guiObject.update();
        }
        this.guiObjects.values().forEach(object -> object.setVisible(true));
        for (GuiObject guiObject : this.guiObjects.values()) {
            if (guiObject.isAlwaysVisible()) continue;
            if (this.backGround.collides(guiObject)) {
                guiObject.setVisible(true);
                continue;
            }
            guiObject.setVisible(false);
        }
        this.unplacedRewards.stream().filter(obj -> !obj.isPlaced() && !obj.equals(this.selectedReward)).forEach(object -> object.setVisible(true));
        for (GuiObjectEditingReward guiObjectEditingReward : this.unplacedRewards) {
            if (!guiObjectEditingReward.isPlaced() || guiObjectEditingReward.equals(this.selectedReward) || guiObjectEditingReward.isAlwaysVisible()) continue;
            if (this.backGround.collides(guiObjectEditingReward)) {
                guiObjectEditingReward.setVisible(true);
                continue;
            }
            guiObjectEditingReward.setVisible(false);
        }
        if (this.editingReward != null) {
            this.fieldName.func_146178_a();
            this.fieldDesc.func_146178_a();
            this.fieldCost.func_146178_a();
            this.fieldID.func_146178_a();
            this.fieldFilter.func_146178_a();
        }
        this.buttonCreateNewReward.field_146125_m = this.editingReward == null;
        if (this.saveChanges) {
            this.saveChanges = false;
            this.saveTempFile();
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        GlStateManager.func_179094_E();
        this.backGround.draw(this.left, this.top, mouseX, mouseY, partialTicks);
        this.field_146297_k.func_110434_K().func_110577_a(new ResourceLocation("prestige", "textures/gui/gui_prestige_line.png"));
        ScaledResolution resolution = new ScaledResolution(this.field_146297_k);
        int scale = resolution.func_78325_e();
        GL11.glScissor((int)((this.left + 4) * scale), (int)((this.top - 1 + 4) * scale), (int)((this.guiWidth - 8) * scale), (int)((this.guiHeight + 1 - 8) * scale));
        GL11.glEnable((int)3089);
        for (GuiObjectEditingReward parent : this.unplacedRewards) {
            Vec3d start = new Vec3d((double)(parent.getX() + (float)(parent.getWidth() / 2)), (double)(parent.getY() + (float)(parent.getHeight() / 2)), 0.0);
            for (Reward child : parent.getReward().getChildren()) {
                if (child == null || child.getIdentifier() == null) {
                    Prestige.LOG.error("Child was not found! Please notify their parent: " + parent.getReward().getIdentifier());
                    continue;
                }
                GuiObjectEditingReward childObject = this.getObject(child.getIdentifier());
                if (childObject == null) continue;
                Vec3d end = new Vec3d((double)(child.getX() + childObject.getWidth() / 2), (double)(child.getY() + childObject.getHeight() / 2), 0.0);
                GlStateManager.func_179094_E();
                double angle = Math.atan2((float)child.getY() - parent.getY(), (float)child.getX() - parent.getX()) * 180.0 / Math.PI;
                GL11.glTranslated((double)(parent.getX() + (float)(parent.getWidth() / 2)), (double)(parent.getY() + (float)(parent.getHeight() / 2)), (double)0.0);
                GL11.glRotated((double)angle, (double)0.0, (double)0.0, (double)1.0);
                float length = (float)start.func_72438_d(end);
                RenderUtils.drawTexturedModalRect(0.0f, 0.0f, RenderUtils.remap((float)((double)System.nanoTime() / 1.0E9), 1.0f, 0.0f, 0.0f, 16.0f), 0.0f, length, 4.0f);
                GL11.glTranslated((double)(-(parent.getX() + (float)(parent.getWidth() / 2))), (double)(-(parent.getY() + (float)(parent.getHeight() / 2))), (double)0.0);
                GlStateManager.func_179121_F();
            }
        }
        GL11.glDisable((int)3089);
        GlStateManager.func_179094_E();
        for (GuiObject object : this.guiObjects.values()) {
            if (!object.isVisible()) continue;
            object.draw(this.left, this.top, mouseX, mouseY, partialTicks);
        }
        for (GuiObjectItemStack stack : this.stackList) {
            if (!stack.isVisible() || !(stack.getY() >= (float)(this.top + this.stackY)) || !(stack.getY() + (float)stack.getHeight() <= (float)(this.top + this.stackY + 90))) continue;
            if (this.selectedStack.equals(stack)) {
                RenderUtils.drawLineUntextured(stack.getX(), stack.getY(), stack.getX2() - 2.0f, stack.getY(), 0.0f, 0.8f, 0.8f, 2.0f);
                RenderUtils.drawLineUntextured(stack.getX(), stack.getY2() - 2.0f, stack.getX2() - 2.0f, stack.getY2() - 2.0f, 0.0f, 0.8f, 0.8f, 2.0f);
                RenderUtils.drawLineUntextured(stack.getX(), stack.getY(), stack.getX(), stack.getY2() - 2.0f, 0.0f, 0.8f, 0.8f, 2.0f);
                RenderUtils.drawLineUntextured(stack.getX2() - 2.0f, stack.getY(), stack.getX2() - 2.0f, stack.getY2() - 2.0f, 0.0f, 0.8f, 0.8f, 2.0f);
            }
            stack.draw(this.left, this.top, mouseX, mouseY, partialTicks);
        }
        for (GuiObjectEditingReward reward : this.unplacedRewards) {
            if (reward.equals(this.selectedReward) || !reward.isVisible() || !(reward.getY() >= (float)this.getTop()) || !(reward.getY() + (float)reward.getHeight() <= (float)(this.getTop() + this.getGuiHeight()))) continue;
            if (reward.equals(this.editingReward)) {
                GlStateManager.func_179131_c((float)0.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            reward.draw(this.left, this.top, mouseX, mouseY, partialTicks);
            if (!reward.equals(this.editingReward)) continue;
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GL11.glTranslated((double)0.0, (double)0.0, (double)500.0);
        this.border.draw(this.left, this.top, mouseX, mouseY, partialTicks);
        GL11.glTranslated((double)0.0, (double)0.0, (double)0.0);
        GlStateManager.func_179121_F();
        if (this.selectedReward != null) {
            if (this.selectedReward.isMoving()) {
                this.selectedReward.setX(mouseX - this.selectedReward.getWidth() / 2);
                this.selectedReward.setY(mouseY - this.selectedReward.getHeight() / 2);
            }
            if (this.backGround.collides(this.selectedReward)) {
                GlStateManager.func_179094_E();
                GL11.glTranslated((double)0.0, (double)0.0, (double)500.0);
                GL11.glColor4d((double)1.0, (double)1.0, (double)1.0, (double)1.0);
                RenderUtils.drawLineUntextured(this.selectedReward.getX() + (float)(this.selectedReward.getWidth() / 2), this.top, this.selectedReward.getX() + (float)(this.selectedReward.getWidth() / 2), mouseY, 1.0f, 1.0f, 1.0f, 2.0f);
                RenderUtils.drawLineUntextured(this.left, this.selectedReward.getY() + (float)(this.selectedReward.getHeight() / 2), mouseX, this.selectedReward.getY() + (float)(this.selectedReward.getHeight() / 2), 1.0f, 1.0f, 1.0f, 2.0f);
                RenderUtils.drawLineUntextured(this.selectedReward.getX(), this.selectedReward.getY(), this.selectedReward.getX() + (float)this.selectedReward.getWidth(), this.selectedReward.getY(), 1.0f, 1.0f, 1.0f, 2.0f);
                RenderUtils.drawLineUntextured(this.selectedReward.getX(), this.selectedReward.getY() + (float)this.selectedReward.getHeight(), this.selectedReward.getX() + (float)this.selectedReward.getWidth(), this.selectedReward.getY() + (float)this.selectedReward.getHeight(), 1.0f, 1.0f, 1.0f, 2.0f);
                RenderUtils.drawLineUntextured(this.selectedReward.getX(), this.selectedReward.getY(), this.selectedReward.getX(), this.selectedReward.getY() + (float)this.selectedReward.getHeight(), 1.0f, 1.0f, 1.0f, 2.0f);
                RenderUtils.drawLineUntextured(this.selectedReward.getX() + (float)this.selectedReward.getWidth(), this.selectedReward.getY(), this.selectedReward.getX() + (float)this.selectedReward.getWidth(), this.selectedReward.getY() + (float)this.selectedReward.getHeight(), 1.0f, 1.0f, 1.0f, 2.0f);
                List unplaced = this.unplacedRewards.stream().filter(GuiObjectEditingReward::isPlaced).collect(Collectors.toList());
                LinkedList guideLines = new LinkedList();
                GuideLine y1 = new GuideLine(this.selectedReward.getX(), this.selectedReward.getX() + (float)this.selectedReward.getWidth(), this.selectedReward.getY(), this.selectedReward.getY() + (float)this.selectedReward.getHeight());
                GuideLine y2 = new GuideLine(this.selectedReward.getX(), this.selectedReward.getX() + (float)this.selectedReward.getWidth(), this.selectedReward.getY(), this.selectedReward.getY() + (float)this.selectedReward.getHeight());
                GuideLine x1 = new GuideLine(this.selectedReward.getX(), this.selectedReward.getX() + (float)this.selectedReward.getWidth(), this.selectedReward.getY(), this.selectedReward.getY() + (float)this.selectedReward.getHeight());
                GuideLine x2 = new GuideLine(this.selectedReward.getX(), this.selectedReward.getX() + (float)this.selectedReward.getWidth(), this.selectedReward.getY(), this.selectedReward.getY() + (float)this.selectedReward.getHeight());
                guideLines.add(y1);
                guideLines.add(y2);
                guideLines.add(x1);
                guideLines.add(x2);
                for (GuiObjectEditingReward reward : unplaced) {
                    if (reward.equals(this.selectedReward) || !reward.isVisible()) continue;
                    if (this.selectedReward.getX() == reward.getX()) {
                        y1.setX(Math.min((double)reward.getX(), y1.getMinX()));
                        y2.setX(Math.min((double)(reward.getX() + (float)reward.getWidth()), y2.getMaxX()));
                        y1.setMinY(Math.min((double)reward.getY(), y1.getMinY()));
                        y1.setMaxY(Math.max((double)(reward.getY() + (float)reward.getHeight()), y1.getMaxY()));
                        y2.setMinY(Math.min((double)reward.getY(), y2.getMinY()));
                        y2.setMaxY(Math.max((double)(reward.getY() + (float)reward.getHeight()), y2.getMaxY()));
                        y1.setShouldDraw(true);
                        y2.setShouldDraw(true);
                    }
                    if (this.selectedReward.getX() + (float)this.selectedReward.getWidth() == reward.getX()) {
                        y2.setX(y2.getMaxX());
                        y2.setMinY(Math.min((double)reward.getY(), y2.getMinY()));
                        y2.setMaxY(Math.max((double)(reward.getY() + (float)reward.getHeight()), y2.getMaxY()));
                        y2.setShouldDraw(true);
                    }
                    if (this.selectedReward.getX() == reward.getX() + (float)reward.getWidth()) {
                        y1.setX(y1.getMinX());
                        y1.setMinY(Math.min((double)reward.getY(), y1.getMinY()));
                        y1.setMaxY(Math.max((double)(reward.getY() + (float)reward.getHeight()), y1.getMaxY()));
                        y1.setShouldDraw(true);
                    }
                    if (this.selectedReward.getY() == reward.getY()) {
                        x1.setY(Math.min((double)reward.getY(), x1.getMinY()));
                        x2.setY(Math.min((double)(reward.getY() + (float)reward.getHeight()), x2.getMaxY()));
                        x1.setMinX(Math.min((double)reward.getX(), x1.getMinX()));
                        x1.setMaxX(Math.max((double)(reward.getX() + (float)reward.getWidth()), x1.getMaxX()));
                        x2.setMinX(Math.min((double)reward.getX(), x2.getMinX()));
                        x2.setMaxX(Math.max((double)(reward.getX() + (float)reward.getWidth()), x2.getMaxX()));
                        x1.setShouldDraw(true);
                        x2.setShouldDraw(true);
                    }
                    if (this.selectedReward.getY() + (float)this.selectedReward.getHeight() == reward.getY()) {
                        x2.setY(Math.min((double)reward.getY(), x2.getMaxY()));
                        x2.setMinX(Math.min((double)reward.getX(), x2.getMinX()));
                        x2.setMaxX(Math.max((double)(reward.getX() + (float)reward.getWidth()), x2.getMaxX()));
                        x2.setShouldDraw(true);
                    }
                    if (this.selectedReward.getY() != reward.getY() + (float)reward.getHeight()) continue;
                    x1.setY(Math.min((double)(reward.getY() + (float)reward.getHeight()), x1.getMinY()));
                    x1.setMinX(Math.min((double)reward.getX(), x1.getMinX()));
                    x1.setMaxX(Math.max((double)(reward.getX() + (float)reward.getWidth()), x1.getMaxX()));
                    x1.setShouldDraw(true);
                }
                guideLines.forEach(GuideLine::draw);
                this.field_146289_q.func_175065_a(this.selectedReward.getX() - (float)(this.selectedReward.getWidth() / 2) - (float)this.left + "", (float)(this.left + 20), (float)(mouseY + 20), 0xFFFFFF, true);
                this.field_146289_q.func_175065_a(this.selectedReward.getY() - (float)(this.selectedReward.getWidth() / 2) - (float)this.top + "", (float)(mouseX + 20), (float)(this.top + 20), 0xFFFFFF, true);
                GL11.glTranslated((double)0.0, (double)0.0, (double)-500.0);
                GlStateManager.func_179121_F();
            }
            GlStateManager.func_179094_E();
            GL11.glTranslated((double)0.0, (double)0.0, (double)500.0);
            this.selectedReward.draw(this.left, this.top, mouseX, mouseY, partialTicks);
            GL11.glTranslated((double)0.0, (double)0.0, (double)-500.0);
            GlStateManager.func_179121_F();
        }
        boolean[] sides = new boolean[4];
        for (GuiObjectEditingReward reward : this.unplacedRewards) {
            if (!reward.isPlaced()) continue;
            if (sides[0] && sides[1] && sides[3] && sides[2]) break;
            if (!sides[3] && reward.getX() < (float)this.left) {
                sides[3] = true;
            }
            if (!sides[1] && reward.getX() > (float)(this.left + this.guiWidth)) {
                sides[1] = true;
            }
            if (!sides[0] && reward.getY() < (float)this.top) {
                sides[0] = true;
            }
            if (sides[2] || !(reward.getY() > (float)(this.top + this.guiHeight))) continue;
            sides[2] = true;
        }
        if (sides[0] || sides[1] || sides[3] || sides[2]) {
            this.field_146297_k.func_110434_K().func_110577_a(new ResourceLocation("prestige", "textures/gui/gui_prestige_line.png"));
            if (sides[0]) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)500.0f);
                RenderUtils.drawLineUntextured(this.left + this.guiWidth / 2 - 4, this.top + 25, this.left + this.guiWidth / 2, this.top + 20, 0.0f, 1.0f, 1.0f, 5.0f);
                RenderUtils.drawLineUntextured(this.left + this.guiWidth / 2 + 4, this.top + 25, this.left + this.guiWidth / 2, this.top + 20, 0.0f, 1.0f, 1.0f, 5.0f);
                RenderUtils.drawLineUntextured(this.left + this.guiWidth / 2 - 4, this.top + 25, this.left + this.guiWidth / 2 + 4, this.top + 25, 0.0f, 1.0f, 1.0f, 5.0f);
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-500.0f);
                GlStateManager.func_179121_F();
            }
            if (sides[2]) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)500.0f);
                RenderUtils.drawLineUntextured(this.left + this.guiWidth / 2 - 4, this.top + this.guiHeight - 25, this.left + this.guiWidth / 2, this.top + this.guiHeight - 20, 0.0f, 1.0f, 1.0f, 5.0f);
                RenderUtils.drawLineUntextured(this.left + this.guiWidth / 2 + 4, this.top + this.guiHeight - 25, this.left + this.guiWidth / 2, this.top + this.guiHeight - 20, 0.0f, 1.0f, 1.0f, 5.0f);
                RenderUtils.drawLineUntextured(this.left + this.guiWidth / 2 - 4, this.top + this.guiHeight - 25, this.left + this.guiWidth / 2 + 4, this.top + this.guiHeight - 25, 0.0f, 1.0f, 1.0f, 5.0f);
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-500.0f);
                GlStateManager.func_179121_F();
            }
            if (sides[1]) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)500.0f);
                RenderUtils.drawLineUntextured(this.left + this.guiWidth - 25, this.top + this.guiHeight / 2 - 4, this.left + this.guiWidth - 20, this.top + this.guiHeight / 2, 0.0f, 1.0f, 1.0f, 5.0f);
                RenderUtils.drawLineUntextured(this.left + this.guiWidth - 25, this.top + this.guiHeight / 2 + 4, this.left + this.guiWidth - 20, this.top + this.guiHeight / 2, 0.0f, 1.0f, 1.0f, 5.0f);
                RenderUtils.drawLineUntextured(this.left + this.guiWidth - 25, this.top + this.guiHeight / 2 - 4, this.left + this.guiWidth - 25, this.top + this.guiHeight / 2 + 4, 0.0f, 1.0f, 1.0f, 5.0f);
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-500.0f);
                GlStateManager.func_179121_F();
            }
            if (sides[3]) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)500.0f);
                RenderUtils.drawLineUntextured(this.left + 25, this.top + this.guiHeight / 2 - 4, this.left + 20, this.top + this.guiHeight / 2, 0.0f, 1.0f, 1.0f, 5.0f);
                RenderUtils.drawLineUntextured(this.left + 25, this.top + this.guiHeight / 2 + 4, this.left + 20, this.top + this.guiHeight / 2, 0.0f, 1.0f, 1.0f, 5.0f);
                RenderUtils.drawLineUntextured(this.left + 25, this.top + this.guiHeight / 2 - 4, this.left + 25, this.top + this.guiHeight / 2 + 4, 0.0f, 1.0f, 1.0f, 5.0f);
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-500.0f);
                GlStateManager.func_179121_F();
            }
        }
        this.field_146289_q.func_175063_a("Name: ", (float)this.fieldName.field_146209_f, (float)(this.fieldName.field_146210_g - 11), 0xFFFFFF);
        this.fieldName.func_146194_f();
        this.field_146289_q.func_175063_a("Description: ", (float)this.fieldDesc.field_146209_f, (float)(this.fieldDesc.field_146210_g - 11), 0xFFFFFF);
        this.fieldDesc.func_146194_f();
        this.field_146289_q.func_175063_a("Cost: ", (float)this.fieldCost.field_146209_f, (float)(this.fieldCost.field_146210_g - 11), 0xFFFFFF);
        this.fieldCost.func_146194_f();
        this.field_146289_q.func_175063_a("ID: ", (float)this.fieldID.field_146209_f, (float)(this.fieldID.field_146210_g - 11), 0xFFFFFF);
        this.fieldID.func_146194_f();
        this.field_146289_q.func_175063_a("Filter: ", (float)this.fieldFilter.field_146209_f, (float)(this.fieldFilter.field_146210_g - 11), 0xFFFFFF);
        this.fieldFilter.func_146194_f();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.buttonCreateNewReward.drawText(mouseX, mouseY);
        this.buttonUpdateReward.drawText(mouseX, mouseY);
        this.buttonRemoveReward.drawText(mouseX, mouseY);
        this.buttonSave.drawText(mouseX, mouseY);
        this.buttonReset.drawText(mouseX, mouseY);
        int butLeft = this.left + this.guiWidth + 5 + 90;
        int butLeftInner = butLeft + 2;
        int butRight = this.left + this.guiWidth + 5 + 90 + 10;
        RenderUtils.drawRect(butLeft, this.top + this.stackY, butRight, this.top + this.stackY + 10, -15658735);
        RenderUtils.drawRect(butLeftInner, this.top + this.stackY + 2, butRight - 2, this.top + this.stackY + 8, -13421773);
        RenderUtils.drawRect(butLeft, this.top + this.stackY + 90 - 10, butRight, this.top + this.stackY + 90, -15658735);
        RenderUtils.drawRect(butLeftInner, this.top + this.stackY + 90 - 8, butRight - 2, this.top + this.stackY + 90 - 2, -13421773);
        RenderUtils.drawLineUntextured(butLeft + 5, this.top + this.stackY + 2, butLeft + 2, this.top + this.stackY + 10 - 2, 0.0f, 0.5f, 1.0f, 4.0f);
        RenderUtils.drawLineUntextured(butLeft + 5, this.top + this.stackY + 2, butLeft + 8, this.top + this.stackY + 10 - 2, 0.0f, 0.5f, 1.0f, 4.0f);
        RenderUtils.drawLineUntextured(butLeft + 8, this.top + this.stackY + 8, butLeft + 2, this.top + this.stackY + 8, 0.0f, 0.5f, 1.0f, 4.0f);
        RenderUtils.drawLineUntextured(butLeft + 5, this.top + this.stackY + 90 - 2, butLeft + 2, this.top + this.stackY - 6 + 90 - 2, 0.0f, 0.5f, 1.0f, 4.0f);
        RenderUtils.drawLineUntextured(butLeft + 5, this.top + this.stackY + 90 - 2, butLeft + 8, this.top + this.stackY - 6 + 90 - 2, 0.0f, 0.5f, 1.0f, 4.0f);
        RenderUtils.drawLineUntextured(butLeft + 8, this.top + this.stackY - 6 + 90 - 2, butLeft + 2, this.top + this.stackY - 6 + 90 - 2, 0.0f, 0.5f, 1.0f, 4.0f);
        butLeft = this.left - 32;
        butLeftInner = this.left - 30;
        butRight = this.left - 32 + 10;
        RenderUtils.drawRect(butLeft, this.top, butRight, this.top + 10, -15658735);
        RenderUtils.drawRect(butLeftInner, this.top + 2, butRight - 2, this.top + 8, -13421773);
        RenderUtils.drawRect(butLeft, this.top + this.guiHeight - 10, butRight, this.top + this.guiHeight, -15658735);
        RenderUtils.drawRect(butLeftInner, this.top + this.guiHeight - 8, butRight - 2, this.top + this.guiHeight - 2, -13421773);
        RenderUtils.drawLineUntextured(butLeft + 5, this.top + 2, butLeft + 2, this.top + 8, 0.0f, 0.5f, 1.0f, 4.0f);
        RenderUtils.drawLineUntextured(butLeft + 5, this.top + 2, butLeft + 8, this.top + 8, 0.0f, 0.5f, 1.0f, 4.0f);
        RenderUtils.drawLineUntextured(butLeft + 8, this.top + 8, butLeft + 2, this.top + 8, 0.0f, 0.5f, 1.0f, 4.0f);
        RenderUtils.drawLineUntextured(butLeft + 5, this.top + this.guiHeight - 2, butLeft + 2, this.top + this.guiHeight - 8, 0.0f, 0.5f, 1.0f, 4.0f);
        RenderUtils.drawLineUntextured(butLeft + 5, this.top + this.guiHeight - 2, butLeft + 8, this.top + this.guiHeight - 8, 0.0f, 0.5f, 1.0f, 4.0f);
        RenderUtils.drawLineUntextured(butLeft + 8, this.top + this.guiHeight - 8, butLeft + 2, this.top + this.guiHeight - 8, 0.0f, 0.5f, 1.0f, 4.0f);
        for (GuiObjectEditingReward reward : this.unplacedRewards) {
            if (reward.equals(this.selectedReward) || !reward.isVisible() || !reward.collides(mouseX, mouseY) || !(reward.getY() >= (float)this.getTop()) || !(reward.getY() + (float)reward.getHeight() <= (float)(this.getTop() + this.getGuiHeight()))) continue;
            reward.drawText(mouseX, mouseY);
        }
        for (GuiObjectItemStack stack : this.stackList) {
            if (!stack.isVisible() || !stack.collides(mouseX, mouseY) || !(stack.getY() >= (float)(this.top + this.stackY)) || !(stack.getY() + (float)stack.getHeight() <= (float)(this.top + this.stackY + 90))) continue;
            stack.drawText(mouseX, mouseY);
        }
    }

    public void func_146278_c(int tint) {
        super.func_146278_c(tint);
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int x = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
        int y = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
        int wheel = Mouse.getDWheel();
        int offset = 0;
        if (x > this.left - 96 && x < this.left - 96 + 64 && wheel != 0) {
            if (wheel > 0) {
                if (this.yOff < 0) {
                    offset = 32;
                    ++this.yOff;
                }
            } else if (Math.abs(this.yOff) < (this.unplacedRewards.size() - 2) / 2) {
                offset = -32;
                --this.yOff;
            }
            for (GuiObjectEditingReward reward : this.unplacedRewards) {
                if (reward.isPlaced()) continue;
                reward.setY(reward.getY() + (float)offset);
            }
            this.saveChanges = true;
        }
        if (y >= this.top + this.stackY && y + 18 <= this.top + this.stackY + 108 && x > this.left + this.guiWidth + 5 && x < this.left + this.guiWidth + 5 + 90 && wheel != 0) {
            if (wheel > 0 && this.stackYOff < 0) {
                offset = 18;
                ++this.stackYOff;
            } else if (wheel < 0 && Math.abs(this.stackYOff) < (this.stackList.size() - 25) / 5) {
                offset = -18;
                --this.stackYOff;
            }
            for (GuiObjectItemStack stack : this.stackList) {
                stack.setY(stack.getY() + (float)offset);
            }
            this.saveChanges = true;
        }
    }

    public void func_146282_l() throws IOException {
        Keyboard.enableRepeatEvents((boolean)true);
        super.func_146282_l();
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        super.func_73869_a(typedChar, keyCode);
        if (typedChar == '\t') {
            if (this.fieldID.func_146206_l()) {
                this.fieldName.func_146195_b(true);
                this.fieldID.func_146195_b(false);
            } else if (this.fieldName.func_146206_l()) {
                this.fieldDesc.func_146195_b(true);
                this.fieldName.func_146195_b(false);
            } else if (this.fieldDesc.func_146206_l()) {
                this.fieldCost.func_146195_b(true);
                this.fieldDesc.func_146195_b(false);
            } else if (this.fieldCost.func_146206_l()) {
                this.fieldFilter.func_146195_b(true);
                this.fieldCost.func_146195_b(false);
            } else if (this.fieldFilter.func_146206_l()) {
                this.fieldID.func_146195_b(true);
                this.fieldFilter.func_146195_b(false);
            }
        } else {
            this.fieldName.func_146201_a(typedChar, keyCode);
            this.fieldDesc.func_146201_a(typedChar, keyCode);
            this.fieldCost.func_146201_a(typedChar, keyCode);
            this.fieldID.func_146201_a(typedChar, keyCode);
            if (this.fieldFilter.func_146201_a(typedChar, keyCode)) {
                this.generateStackList();
            }
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.prevMX = mouseX;
        this.prevMY = mouseY;
        if (mouseButton == 0) {
            boolean clicked = false;
            int offset = 0;
            if (mouseX > this.left + this.guiWidth + 5 + 90 && mouseX < this.left + this.guiWidth + 5 + 90 + 10) {
                if (mouseY > this.top + this.stackY + 90 - 10 && mouseY < this.top + this.stackY + 90 && Math.abs(this.stackYOff) < (this.stackList.size() - 25) / 5) {
                    --this.stackYOff;
                    offset = -18;
                    clicked = true;
                }
                if (mouseY > this.top + this.stackY && mouseY < this.top + this.stackY + 10 && this.stackYOff < 0) {
                    ++this.stackYOff;
                    offset = 18;
                    clicked = true;
                }
                if (clicked) {
                    for (GuiObjectItemStack stack2 : this.stackList) {
                        stack2.setY(stack2.getY() + (float)offset);
                    }
                }
            }
            if (mouseX > this.left - 32 && mouseX < this.left - 32 + 10) {
                if (mouseY > this.top && mouseY < this.top + 10 && Math.abs(this.yOff) < (this.unplacedRewards.size() - 2) / 2) {
                    --this.yOff;
                    offset = -32;
                    clicked = true;
                }
                if (mouseY < this.top + this.guiHeight && mouseY > this.top + this.guiHeight - 10 && this.yOff <= -1) {
                    ++this.yOff;
                    offset = 32;
                    clicked = true;
                }
                if (clicked) {
                    for (GuiObjectEditingReward reward : this.unplacedRewards) {
                        if (reward.isPlaced()) continue;
                        reward.setY(reward.getY() + (float)offset);
                    }
                }
            }
            if (!clicked) {
                this.backGround.mouseClicked(mouseX, mouseY, mouseButton);
                for (GuiObject object : this.guiObjects.values()) {
                    object.mouseClicked(mouseX, mouseY, mouseButton);
                }
            }
            this.stackList.stream().filter(stack -> stack.getY() >= (float)(this.top + this.stackY) && stack.getY() + (float)stack.getHeight() <= (float)(this.top + this.stackY + 90)).forEach(stack -> stack.mouseClicked(mouseX, mouseY, mouseButton));
            this.saveChanges = true;
        }
        boolean successful = false;
        for (GuiObjectEditingReward reward : this.unplacedRewards) {
            if (!reward.collides(mouseX, mouseY, mouseX, mouseY) || reward.isPlaced() && !this.backGround.collides(reward)) continue;
            if (mouseButton == 0) {
                if (reward.isLocked()) continue;
                if (this.editingReward != null && !this.backGround.collides(mouseX, mouseY, mouseX, mouseY)) {
                    this.selectedReward = reward;
                    this.selectedReward.setPlaced(false);
                    successful = true;
                }
                if (this.editingReward == null) {
                    this.selectedReward = reward;
                    this.selectedReward.setPlaced(false);
                    successful = true;
                    continue;
                }
                if (!this.backGround.collides(mouseX, mouseY, mouseX, mouseY) || reward.equals(this.editingReward)) continue;
                Set<Reward> children = this.editingReward.getReward().getChildren();
                if (children.contains(reward.getReward())) {
                    this.editingReward.getReward().removeChild(reward.getReward());
                } else {
                    this.editingReward.getReward().addChild(reward.getReward());
                }
                successful = true;
                continue;
            }
            if (mouseButton != 1 || this.selectedReward != null || !reward.isPlaced()) continue;
            if (reward.equals(this.editingReward)) {
                this.editingReward = null;
            } else {
                this.editingReward = reward;
                this.fieldName.func_146180_a(this.editingReward.getReward().getTitle());
                this.fieldCost.func_146180_a(this.editingReward.getReward().getCost() + "");
                this.fieldDesc.func_146180_a(this.editingReward.getReward().getDescription());
                this.fieldID.func_146180_a(this.editingReward.getReward().getIdentifier());
                this.selectedStack = this.getStack(this.editingReward.getReward().getIcon());
            }
            successful = true;
        }
        if (this.fieldName.func_146192_a(mouseX, mouseY, mouseButton)) {
            successful = true;
        }
        if (this.fieldDesc.func_146192_a(mouseX, mouseY, mouseButton)) {
            successful = true;
        }
        if (this.fieldCost.func_146192_a(mouseX, mouseY, mouseButton)) {
            successful = true;
        }
        if (this.fieldID.func_146192_a(mouseX, mouseY, mouseButton)) {
            successful = true;
        }
        if (this.fieldFilter.func_146192_a(mouseX, mouseY, mouseButton)) {
            successful = true;
        }
        if (!successful) {
            this.editingReward = null;
        } else {
            this.saveChanges = true;
        }
    }

    protected void func_146273_a(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        super.func_146273_a(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
        if (this.selectedReward == null && this.editingReward == null && this.backGround.collides(mouseX, mouseY)) {
            this.backGround.mouseClickMove(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
            for (GuiObjectEditingReward object : this.unplacedRewards) {
                if (!object.isPlaced()) continue;
                object.mouseClickMove(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
            }
        } else if (this.selectedReward != null) {
            this.selectedReward.setMoving(true);
        }
        this.prevMX = mouseX;
        this.prevMY = mouseY;
    }

    protected void func_146286_b(int mouseX, int mouseY, int state) {
        super.func_146286_b(mouseX, mouseY, state);
        this.prevMX = -1;
        this.prevMY = -1;
        this.backGround.mouseReleased(mouseX, mouseY, state);
        for (GuiObject object : this.guiObjects.values()) {
            object.mouseReleased(mouseX, mouseY, state);
        }
        if (this.selectedReward != null) {
            if (this.backGround.collides(this.selectedReward)) {
                this.selectedReward.setPlaced(true);
            } else {
                this.selectedReward.setPlaced(false);
                this.selectedReward.setX(this.left - 96 + this.selectedReward.getGridX() * 32);
                this.selectedReward.setY(this.top + (this.selectedReward.getGridY() + this.yOff) * 32);
                this.selectedReward.setVisible(true);
                for (Reward parent : this.selectedReward.getReward().getParents()) {
                    parent.removeChild(this.selectedReward.getReward());
                }
                for (Reward child : this.selectedReward.getReward().getChildren()) {
                    child.removeParent(this.selectedReward.getReward());
                }
                this.selectedReward.getReward().clearParents();
                this.selectedReward.getReward().clearChildren();
            }
            this.selectedReward.setMoving(false);
            this.selectedReward = null;
        }
        this.saveChanges = true;
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        super.func_146284_a(button);
        String id = this.fieldID.func_146179_b();
        if (button.field_146127_k != this.buttonSave.field_146127_k && button.field_146127_k != this.buttonReset.field_146127_k && id.isEmpty()) {
            return;
        }
        if (button.field_146127_k == this.buttonCreateNewReward.field_146127_k && !Prestige.REGISTRY.containsKey(id)) {
            if (this.fieldCost.func_146179_b().isEmpty()) {
                this.fieldCost.func_146180_a("0");
            }
            Prestige.REGISTRY.put(id, new Reward(id, this.fieldName.func_146179_b(), 0, 0, Integer.parseInt(this.fieldCost.func_146179_b()), this.selectedStack.getStack(), this.fieldDesc.func_146179_b()));
            this.fieldName.func_146180_a("");
            this.fieldDesc.func_146180_a("");
            this.fieldID.func_146180_a("");
            this.fieldCost.func_146180_a("0");
        }
        if (button.field_146127_k == this.buttonRemoveReward.field_146127_k && Prestige.REGISTRY.containsKey(id)) {
            Reward removed = Prestige.REGISTRY.get(id);
            for (Reward reward : Prestige.REGISTRY.values()) {
                reward.removeParent(removed);
                reward.removeChild(removed);
            }
            removed.clearParents();
            removed.clearChildren();
            Prestige.REGISTRY.remove(id);
        }
        if (button.field_146127_k == this.buttonUpdateReward.field_146127_k && (Prestige.REGISTRY.containsKey(id) || this.editingReward != null)) {
            if (this.fieldCost.func_146179_b().isEmpty()) {
                this.fieldCost.func_146180_a("0");
            }
            Reward updated = this.editingReward != null ? this.editingReward.getReward() : Prestige.REGISTRY.get(id);
            updated.setTitle(this.fieldName.func_146179_b());
            updated.setDescription(this.fieldDesc.func_146179_b());
            updated.setCost(Integer.parseInt(this.fieldCost.func_146179_b()));
            updated.setIcon(this.selectedStack.getStack());
        }
        if (button.field_146127_k == this.buttonSave.field_146127_k) {
            Prestige.INSTANCE.saveRewards();
        }
        if (button.field_146127_k == this.buttonReset.field_146127_k) {
            Prestige.INSTANCE.loadRewards();
        }
        this.yOff = 0;
        this.generateRewards();
        this.saveChanges = true;
    }

    public GuiObjectEditingReward getObject(String identifier) {
        for (GuiObjectEditingReward reward : this.unplacedRewards) {
            if (!reward.getReward().getIdentifier().equals(identifier)) continue;
            return reward;
        }
        return null;
    }

    public GuiObjectItemStack getStack(ItemStack stack) {
        for (GuiObjectItemStack itemStack : this.stackList) {
            if (!itemStack.getStack().func_77969_a(stack)) continue;
            return itemStack;
        }
        return this.stackList.get(0);
    }

    public GuiObjectEditingReward getEditingReward() {
        return this.editingReward;
    }

    public void saveTempFile() {
        try {
            if (!FILE_TEMP.exists()) {
                FILE_TEMP.getParentFile().mkdirs();
                FILE_TEMP.createNewFile();
            }
            BufferedWriter writer = new BufferedWriter(new FileWriter(FILE_TEMP));
            String json = Prestige.GSON.toJson((Object)Prestige.REGISTRY.values().toArray());
            writer.write(json);
            writer.close();
        }
        catch (Exception e) {
            Prestige.LOG.error("Unable to save Prestige backup JSON file!", (Throwable)e);
        }
    }

    public GuiTextField getFieldFilter() {
        return this.fieldFilter;
    }
}

