/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.client.gui.filter;

import java.io.IOException;
import me.desht.modularrouters.ModularRouters;
import me.desht.modularrouters.block.tile.TileEntityItemRouter;
import me.desht.modularrouters.client.gui.BackButton;
import me.desht.modularrouters.client.gui.filter.Buttons;
import me.desht.modularrouters.client.gui.filter.GuiFilterContainer;
import me.desht.modularrouters.container.ContainerSmartFilter;
import me.desht.modularrouters.item.module.ItemModule;
import me.desht.modularrouters.item.module.Module;
import me.desht.modularrouters.logic.ModuleTarget;
import me.desht.modularrouters.logic.compiled.CompiledModule;
import me.desht.modularrouters.network.FilterSettingsMessage;
import me.desht.modularrouters.util.MiscUtil;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.opengl.GL11;

public class GuiBulkItemFilter
extends GuiFilterContainer {
    private static final ResourceLocation textureLocation = new ResourceLocation("modularrouters", "textures/gui/bulkitemfilter.png");
    private static final int GUI_WIDTH = 176;
    private static final int GUI_HEIGHT = 233;
    private static final int CLEAR_BUTTON_ID = 1;
    private static final int MERGE_BUTTON_ID = 2;
    private static final int LOAD_BUTTON_ID = 3;
    private static final int BACK_BUTTON_ID = 100;
    private ModuleTarget target;

    public GuiBulkItemFilter(ContainerSmartFilter container, BlockPos routerPos, Integer moduleSlotIndex, Integer filterSlotIndex, EnumHand hand) {
        super(container, routerPos, moduleSlotIndex, filterSlotIndex, hand);
        this.field_146999_f = 176;
        this.field_147000_g = 233;
    }

    public void func_73866_w_() {
        TileEntityItemRouter router;
        super.func_73866_w_();
        this.field_146292_n.clear();
        this.field_146292_n.add(new Buttons.ClearButton(1, this.field_147003_i + 8, this.field_147009_r + 130));
        if (this.filterSlotIndex >= 0) {
            this.field_146292_n.add(new BackButton(100, this.field_147003_i - 12, this.field_147009_r));
        }
        if (this.moduleSlotIndex >= 0 && (router = TileEntityItemRouter.getRouterAt((IBlockAccess)this.field_146297_k.field_71441_e, this.routerPos)) != null) {
            ItemStack moduleStack = router.getModules().getStackInSlot(this.moduleSlotIndex.intValue());
            Module m = ItemModule.getModule(moduleStack);
            CompiledModule cm = m.compile(router, moduleStack);
            this.target = cm.getActualTarget(router);
            if (this.target != null && this.target.invName != null && !this.target.invName.isEmpty()) {
                this.field_146292_n.add(new Buttons.MergeButton(2, this.field_147003_i + 28, this.field_147009_r + 130, MiscUtil.locToString(this.target.dimId, this.target.pos), this.target.invName));
                this.field_146292_n.add(new Buttons.LoadButton(3, this.field_147003_i + 48, this.field_147009_r + 130, MiscUtil.locToString(this.target.dimId, this.target.pos), this.target.invName));
            }
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(this.title, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(this.title) / 2, 8, 0x404040);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(textureLocation);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, 176, 233);
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        switch (button.field_146127_k) {
            case 1: {
                if (this.routerPos != null) {
                    ModularRouters.network.sendToServer((IMessage)new FilterSettingsMessage(FilterSettingsMessage.Operation.CLEAR_ALL, this.routerPos, this.moduleSlotIndex, this.filterSlotIndex, null));
                    break;
                }
                ModularRouters.network.sendToServer((IMessage)new FilterSettingsMessage(FilterSettingsMessage.Operation.CLEAR_ALL, this.hand, (int)this.filterSlotIndex, null));
                break;
            }
            case 2: {
                if (this.target == null) break;
                ModularRouters.network.sendToServer((IMessage)new FilterSettingsMessage(FilterSettingsMessage.Operation.MERGE, this.routerPos, this.moduleSlotIndex, this.filterSlotIndex, this.target.toNBT()));
                break;
            }
            case 3: {
                if (this.target == null) break;
                ModularRouters.network.sendToServer((IMessage)new FilterSettingsMessage(FilterSettingsMessage.Operation.LOAD, this.routerPos, this.moduleSlotIndex, this.filterSlotIndex, this.target.toNBT()));
                break;
            }
            case 100: {
                this.closeGUI();
                break;
            }
            default: {
                super.func_146284_a(button);
            }
        }
    }

    @Override
    public void func_73876_c() {
        super.func_73876_c();
    }

    public boolean func_73868_f() {
        return false;
    }
}

