/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.client.gui.filter;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import me.desht.modularrouters.client.gui.BackButton;
import me.desht.modularrouters.client.gui.filter.Buttons;
import me.desht.modularrouters.client.gui.filter.GuiFilterScreen;
import me.desht.modularrouters.client.gui.widgets.textfield.TextFieldManager;
import me.desht.modularrouters.client.gui.widgets.textfield.TextFieldWidget;
import me.desht.modularrouters.core.RegistrarMR;
import me.desht.modularrouters.item.smartfilter.RegexFilter;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import org.lwjgl.opengl.GL11;

public class GuiRegexFilter
extends GuiFilterScreen {
    private static final ResourceLocation textureLocation = new ResourceLocation("modularrouters", "textures/gui/regexfilter.png");
    private static final int GUI_WIDTH = 176;
    private static final int GUI_HEIGHT = 186;
    private static final int ADD_REGEX_ID = 1;
    private static final int BACK_BUTTON_ID = 2;
    private static final int BASE_REMOVE_ID = 100;
    private int xPos;
    private int yPos;
    private RegexTextField regexTextField;
    private String errorMsg = "";
    private int errorTimer = 60;
    private final List<String> regexList = Lists.newArrayList();

    public GuiRegexFilter(ItemStack filterStack, BlockPos routerPos, Integer moduleSlotIndex, Integer filterSlotIndex, EnumHand hand) {
        super(filterStack, routerPos, moduleSlotIndex, filterSlotIndex, hand);
        this.regexList.addAll(RegexFilter.getRegexList(filterStack));
    }

    public void func_73866_w_() {
        this.xPos = (this.field_146294_l - 176) / 2;
        this.yPos = (this.field_146295_m - 186) / 2;
        TextFieldManager manager = this.getTextFieldManager().clear();
        this.regexTextField = new RegexTextField(this, 1, this.field_146289_q, this.xPos + 10, this.yPos + 27, 144, 18);
        this.regexTextField.useGuiTextBackground();
        manager.focus(0);
        this.field_146292_n.clear();
        if (this.filterSlotIndex >= 0) {
            this.field_146292_n.add(new BackButton(2, this.xPos - 12, this.yPos));
        }
        this.field_146292_n.add(new Buttons.AddButton(1, this.xPos + 155, this.yPos + 23));
        for (int i = 0; i < this.regexList.size(); ++i) {
            this.field_146292_n.add(new Buttons.DeleteButton(100 + i, this.xPos + 8, this.yPos + 52 + i * 19));
        }
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(textureLocation);
        this.func_73729_b(this.xPos, this.yPos, 0, 0, 176, 186);
        this.field_146289_q.func_78276_b(this.title, this.xPos + 88 - this.field_146289_q.func_78256_a(this.title) / 2, this.yPos + 6, 0x404040);
        for (int i = 0; i < this.regexList.size(); ++i) {
            String regex = this.regexList.get(i);
            this.field_146289_q.func_78276_b("/" + regex + "/", this.xPos + 28, this.yPos + 55 + i * 19, 0x404080);
        }
        if (!this.errorMsg.isEmpty()) {
            this.field_146289_q.func_78276_b(this.errorMsg, this.xPos + 8, this.yPos + 170, 0x804040);
        }
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    @Override
    public void func_73876_c() {
        if (this.errorTimer > 0 && --this.errorTimer == 0) {
            this.errorMsg = "";
        }
        super.func_73876_c();
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button.field_146127_k == 1 && !this.regexTextField.func_146179_b().isEmpty()) {
            this.addRegex();
        } else if (button.field_146127_k >= 100 && button.field_146127_k < 100 + this.regexList.size()) {
            this.sendRemovePosMessage(button.field_146127_k - 100);
        } else if (button.field_146127_k == 2) {
            this.closeGUI();
        } else {
            super.func_146284_a(button);
        }
    }

    private void addRegex() {
        try {
            String regex = this.regexTextField.func_146179_b();
            Pattern.compile(regex);
            this.sendAddStringMessage("String", regex);
            this.regexTextField.func_146180_a("");
            this.getTextFieldManager().focus(0);
            this.errorMsg = "";
        }
        catch (PatternSyntaxException e) {
            this.field_146297_k.field_71439_g.func_184185_a(RegistrarMR.SOUND_ERROR, 1.0f, 1.0f);
            this.errorMsg = I18n.func_135052_a((String)"guiText.label.regexError", (Object[])new Object[0]);
            this.errorTimer = 60;
        }
    }

    @Override
    public void resync(ItemStack stack) {
        this.regexList.clear();
        this.regexList.addAll(RegexFilter.getRegexList(stack));
        this.func_73866_w_();
    }

    private static class RegexTextField
    extends TextFieldWidget {
        private final GuiRegexFilter parent;

        RegexTextField(GuiRegexFilter parent, int componentId, FontRenderer fontrendererObj, int x, int y, int par5Width, int par6Height) {
            super(parent.getTextFieldManager(), componentId, fontrendererObj, x, y, par5Width, par6Height);
            this.parent = parent;
            this.func_146203_f(40);
        }

        public boolean func_146201_a(char typedChar, int keyCode) {
            if (keyCode == 28) {
                this.parent.addRegex();
                return true;
            }
            return super.func_146201_a(typedChar, keyCode);
        }

        public boolean func_146192_a(int mouseX, int mouseY, int mouseButton) {
            if (mouseX >= this.field_146209_f && mouseX < this.field_146209_f + this.field_146218_h && mouseY >= this.field_146210_g && mouseY < this.field_146210_g + this.field_146219_i && mouseButton == 1) {
                this.func_146180_a("");
            }
            return super.func_146192_a(mouseX, mouseY, mouseButton);
        }
    }
}

