/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.client.gui.module;

import java.awt.Color;
import java.awt.Point;
import java.io.IOException;
import me.desht.modularrouters.ModularRouters;
import me.desht.modularrouters.block.tile.TileEntityItemRouter;
import me.desht.modularrouters.client.gui.BackButton;
import me.desht.modularrouters.client.gui.IMouseOverHelpProvider;
import me.desht.modularrouters.client.gui.MouseOverHelp;
import me.desht.modularrouters.client.gui.RedstoneBehaviourButton;
import me.desht.modularrouters.client.gui.widgets.GuiContainerBase;
import me.desht.modularrouters.client.gui.widgets.button.RadioButton;
import me.desht.modularrouters.client.gui.widgets.button.TexturedButton;
import me.desht.modularrouters.client.gui.widgets.button.TexturedToggleButton;
import me.desht.modularrouters.client.gui.widgets.button.ToggleButton;
import me.desht.modularrouters.client.gui.widgets.textfield.IntegerTextField;
import me.desht.modularrouters.client.gui.widgets.textfield.TextFieldManager;
import me.desht.modularrouters.config.ConfigHandler;
import me.desht.modularrouters.container.ContainerModule;
import me.desht.modularrouters.item.augment.ItemAugment;
import me.desht.modularrouters.item.module.ItemModule;
import me.desht.modularrouters.item.module.Module;
import me.desht.modularrouters.item.smartfilter.ItemSmartFilter;
import me.desht.modularrouters.item.smartfilter.SmartFilter;
import me.desht.modularrouters.logic.RouterRedstoneBehaviour;
import me.desht.modularrouters.network.ModuleSettingsMessage;
import me.desht.modularrouters.network.OpenGuiMessage;
import me.desht.modularrouters.util.MiscUtil;
import me.desht.modularrouters.util.ModuleHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiPageButtonList;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.apache.commons.lang3.Range;
import org.lwjgl.opengl.GL11;

public class GuiModule
extends GuiContainerBase
implements GuiPageButtonList.GuiResponder,
IContainerListener,
IMouseOverHelpProvider {
    private static final ResourceLocation textureLocation = new ResourceLocation("modularrouters", "textures/gui/module.png");
    private static final int REGULATOR_TEXTFIELD_ID = 0;
    static final int DIRECTION_BASE_ID = Module.ModuleFlags.values().length;
    private static final int BACK_BUTTON_ID = DIRECTION_BASE_ID + Module.RelativeDirection.values().length;
    private static final int REDSTONE_BUTTON_ID = BACK_BUTTON_ID + 1;
    private static final int REGULATOR_TOOLTIP_ID = BACK_BUTTON_ID + 2;
    private static final int MOUSEOVER_BUTTON_ID = BACK_BUTTON_ID + 3;
    static final Point SMALL_TEXTFIELD_XY = new Point(0, 198);
    static final Point LARGE_TEXTFIELD_XY = new Point(0, 212);
    static final Point BUTTON_XY = new Point(0, 226);
    static final int EXTRA_BUTTON_BASE = 1000;
    static final int EXTRA_TEXTFIELD_BASE = 1000;
    private static final int GUI_HEIGHT = 198;
    private static final int GUI_WIDTH = 192;
    static final int BUTTON_WIDTH = 16;
    static final int BUTTON_HEIGHT = 16;
    final ItemStack moduleItemStack;
    private final Module module;
    private final BlockPos routerPos;
    private final int moduleSlotIndex;
    private final EnumHand hand;
    private Module.RelativeDirection facing;
    private int sendDelay;
    protected int regulatorAmount;
    private RedstoneBehaviourButton redstoneButton;
    protected IntegerTextField regulatorTextField;
    private RegulatorTooltipButton regulatorTooltipButton;
    private DirectionButton[] directionButtons = new DirectionButton[Module.RelativeDirection.values().length];
    private ModuleToggleButton[] toggleButtons = new ModuleToggleButton[Module.ModuleFlags.values().length];
    private final MouseOverHelp mouseOverHelp = new MouseOverHelp(this);
    protected ItemAugment.AugmentCounter augmentCounter;
    private MouseOverHelp.Button mouseOverHelpButton;
    private static final int THRESHOLD = 129;

    public GuiModule(ContainerModule containerItem, EnumHand hand) {
        this(containerItem, null, -1, hand);
    }

    public GuiModule(ContainerModule containerItem, BlockPos routerPos, Integer slotIndex, EnumHand hand) {
        super(containerItem);
        this.moduleItemStack = containerItem.filterHandler.getHolderStack();
        this.module = ItemModule.getModule(this.moduleItemStack);
        this.routerPos = routerPos;
        this.moduleSlotIndex = slotIndex;
        this.hand = hand;
        this.facing = ModuleHelper.getDirectionFromNBT(this.moduleItemStack);
        this.regulatorAmount = ModuleHelper.getRegulatorAmount(this.moduleItemStack);
        this.field_146999_f = 192;
        this.field_147000_g = 198;
        this.augmentCounter = new ItemAugment.AugmentCounter(this.moduleItemStack);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void func_73866_w_() {
        this.field_146292_n.clear();
        super.func_73866_w_();
        this.addToggleButton(Module.ModuleFlags.BLACKLIST, 7, 75);
        this.addToggleButton(Module.ModuleFlags.IGNORE_META, 7, 93);
        this.addToggleButton(Module.ModuleFlags.IGNORE_NBT, 25, 75);
        this.addToggleButton(Module.ModuleFlags.IGNORE_OREDICT, 25, 93);
        this.addToggleButton(Module.ModuleFlags.TERMINATE, 45, 93);
        if (this.module.isDirectional()) {
            this.addDirectionButton(Module.RelativeDirection.NONE, 70, 18);
            this.addDirectionButton(Module.RelativeDirection.UP, 87, 18);
            this.addDirectionButton(Module.RelativeDirection.LEFT, 70, 35);
            this.addDirectionButton(Module.RelativeDirection.FRONT, 87, 35);
            this.addDirectionButton(Module.RelativeDirection.RIGHT, 104, 35);
            this.addDirectionButton(Module.RelativeDirection.DOWN, 87, 52);
            this.addDirectionButton(Module.RelativeDirection.BACK, 104, 52);
        }
        this.mouseOverHelpButton = new MouseOverHelp.Button(MOUSEOVER_BUTTON_ID, this.field_147003_i + 175, this.field_147009_r + 1, this.mouseOverHelp);
        this.field_146292_n.add(this.mouseOverHelpButton);
        this.redstoneButton = new RedstoneBehaviourButton(REDSTONE_BUTTON_ID, this.field_147003_i + 170, this.field_147009_r + 93, 16, 16, ModuleHelper.getRedstoneBehaviour(this.moduleItemStack));
        this.field_146292_n.add(this.redstoneButton);
        TextFieldManager manager = this.createTextFieldManager();
        Range range = this.module.isFluidModule() ? Range.between((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(100)) : Range.between((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(64));
        int xOff = this.module.isFluidModule() ? 0 : 10;
        this.regulatorTextField = new IntegerTextField(manager, 0, this.field_146289_q, this.field_147003_i + 156 + xOff, this.field_147009_r + 75, 20, 12, (Integer)range.getMinimum(), (Integer)range.getMaximum());
        this.regulatorTextField.setValue(this.regulatorAmount);
        this.regulatorTextField.func_175207_a(this);
        this.regulatorTooltipButton = new RegulatorTooltipButton(REGULATOR_TOOLTIP_ID, this.field_147003_i + 138 + xOff, this.field_147009_r + 73, this.module.isFluidModule());
        this.field_146292_n.add(this.regulatorTooltipButton);
        if (this.routerPos != null) {
            this.field_146292_n.add(new BackButton(BACK_BUTTON_ID, this.field_147003_i + 2, this.field_147009_r + 1));
        }
        this.mouseOverHelp.addHelpRegion(this.field_147003_i + 7, this.field_147009_r + 16, this.field_147003_i + 60, this.field_147009_r + 69, "guiText.popup.filter");
        this.mouseOverHelp.addHelpRegion(this.field_147003_i + 5, this.field_147009_r + 73, this.field_147003_i + 62, this.field_147009_r + 110, "guiText.popup.filterControl");
        this.mouseOverHelp.addHelpRegion(this.field_147003_i + 68, this.field_147009_r + 16, this.field_147003_i + 121, this.field_147009_r + 69, this.module.isDirectional() ? "guiText.popup.direction" : "guiText.popup.noDirection");
        this.mouseOverHelp.addHelpRegion(this.field_147003_i + 77, this.field_147009_r + 74, this.field_147003_i + 112, this.field_147009_r + 109, "guiText.popup.augments");
    }

    @SubscribeEvent
    public void onInitGui(GuiScreenEvent.InitGuiEvent.Post event) {
        this.field_147002_h.func_82847_b((IContainerListener)this);
        this.field_147002_h.func_75132_a((IContainerListener)this);
        this.setupButtonVisibility();
    }

    protected void setupButtonVisibility() {
        this.redstoneButton.field_146125_m = this.augmentCounter.getAugmentCount(ItemAugment.AugmentType.REDSTONE) > 0;
        this.regulatorTooltipButton.field_146125_m = this.augmentCounter.getAugmentCount(ItemAugment.AugmentType.REGULATOR) > 0;
        this.regulatorTextField.func_146189_e(this.augmentCounter.getAugmentCount(ItemAugment.AugmentType.REGULATOR) > 0);
    }

    private void addToggleButton(Module.ModuleFlags flag, int x, int y) {
        this.toggleButtons[flag.ordinal()] = new ModuleToggleButton(flag, this.field_147003_i + x, this.field_147009_r + y, ModuleHelper.checkFlag(this.moduleItemStack, flag));
        this.field_146292_n.add(this.toggleButtons[flag.ordinal()]);
    }

    private void addDirectionButton(Module.RelativeDirection dir, int x, int y) {
        this.directionButtons[dir.ordinal()] = new DirectionButton(dir, this.module, this.field_147003_i + x, this.field_147009_r + y, dir == this.facing);
        this.field_146292_n.add(this.directionButtons[dir.ordinal()]);
    }

    protected void func_146284_a(GuiButton button) {
        if (button instanceof DirectionButton) {
            for (Module.RelativeDirection dir : Module.RelativeDirection.values()) {
                DirectionButton db = this.getDirectionButton(dir);
                db.setToggled(db.field_146127_k == button.field_146127_k);
                if (!db.isToggled()) continue;
                this.facing = db.getDirection();
            }
            this.sendModuleSettingsToServer();
        } else if (button instanceof ToggleButton) {
            ((ToggleButton)button).toggle();
            if (((ToggleButton)button).sendToServer()) {
                this.sendModuleSettingsToServer();
            }
        } else if (button.field_146127_k == BACK_BUTTON_ID) {
            if (this.routerPos != null) {
                ModularRouters.network.sendToServer((IMessage)OpenGuiMessage.openRouter(this.routerPos));
            }
        } else if (button.field_146127_k == REDSTONE_BUTTON_ID) {
            this.redstoneButton.cycle(!GuiModule.func_146272_n());
            this.sendModuleSettingsToServer();
        }
    }

    @Override
    public void func_73876_c() {
        super.func_73876_c();
        this.mouseOverHelp.setActive(this.mouseOverHelpButton.isToggled());
        if (this.sendDelay > 0 && --this.sendDelay <= 0) {
            this.sendModuleSettingsToServer();
        }
    }

    void sendModuleSettingsDelayed(int delay) {
        this.sendDelay = delay;
    }

    void sendModuleSettingsToServer() {
        ModularRouters.network.sendToServer((IMessage)new ModuleSettingsMessage(this.routerPos, this.moduleSlotIndex, this.hand, this.buildMessageData()));
    }

    protected NBTTagCompound buildMessageData() {
        byte flags = (byte)(this.facing.ordinal() << 4);
        for (Module.ModuleFlags setting : Module.ModuleFlags.values()) {
            if (!this.getToggleButton(setting).isToggled()) continue;
            flags = (byte)(flags | setting.getMask());
        }
        RouterRedstoneBehaviour behaviour = this.redstoneButton == null ? RouterRedstoneBehaviour.ALWAYS : (RouterRedstoneBehaviour)((Object)this.redstoneButton.getState());
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74774_a("Flags", flags);
        compound.func_74774_a("RedstoneMode", (byte)behaviour.ordinal());
        compound.func_74768_a("RegulatorAmount", this.regulatorAmount);
        return compound;
    }

    private ModuleToggleButton getToggleButton(Module.ModuleFlags flags) {
        return this.toggleButtons[flags.ordinal()];
    }

    private DirectionButton getDirectionButton(Module.RelativeDirection direction) {
        return this.directionButtons[direction.ordinal()];
    }

    protected void func_146979_b(int par1, int par2) {
        String title = this.moduleItemStack.func_82833_r() + (this.routerPos != null ? I18n.func_135052_a((String)"guiText.label.installed", (Object[])new Object[0]) : "");
        this.field_146289_q.func_78276_b(title, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(title) / 2, 5, this.getFgColor(this.module.getItemTint()));
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        Color c = this.getGuiBackgroundTint();
        GL11.glColor4f((float)((float)c.getRed() / 255.0f), (float)((float)c.getGreen() / 255.0f), (float)((float)c.getBlue() / 255.0f), (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(textureLocation);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        if (!this.module.isDirectional()) {
            this.func_73729_b(this.field_147003_i + 69, this.field_147009_r + 17, 204, 0, 52, 52);
        }
    }

    private Color getGuiBackgroundTint() {
        if (ConfigHandler.module.backgroundTint) {
            Color c = this.module.getItemTint();
            float[] hsb = Color.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), null);
            return Color.getHSBColor(hsb[0], hsb[1] * 0.7f, hsb[2]);
        }
        return Color.WHITE;
    }

    @Override
    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if ((keyCode == 1 || keyCode == 18 && !this.func_193976_p()) && this.routerPos != null) {
            ModularRouters.network.sendToServer((IMessage)OpenGuiMessage.openRouter(this.routerPos));
            return;
        }
        if (typedChar != ConfigHandler.getConfigKey() || !this.handleFilterConfig()) {
            super.func_73869_a(typedChar, keyCode);
        }
    }

    @Override
    protected void func_73864_a(int x, int y, int btn) throws IOException {
        if (btn != 2 || !this.handleFilterConfig()) {
            super.func_73864_a(x, y, btn);
        }
    }

    private boolean handleFilterConfig() {
        Slot slot = this.getSlotUnderMouse();
        if (slot == null || ItemSmartFilter.getFilter(slot.func_75211_c()) == null || slot.field_75222_d < 0 || slot.field_75222_d >= 9) {
            return false;
        }
        int filterSlotIndex = slot.field_75222_d;
        SmartFilter filter = ItemSmartFilter.getFilter(slot.func_75211_c());
        TileEntityItemRouter router = this.getItemRouterTE();
        if (router != null) {
            router.playerConfiguringModule((EntityPlayer)this.field_146297_k.field_71439_g, this.moduleSlotIndex, slot.getSlotIndex());
            if (filter.hasGuiContainer()) {
                ModularRouters.network.sendToServer((IMessage)OpenGuiMessage.openFilterInInstalledModule(this.routerPos, this.moduleSlotIndex, filterSlotIndex));
            } else {
                this.field_146297_k.field_71439_g.openGui((Object)ModularRouters.instance, ModularRouters.GUI_FILTER_INSTALLED, (World)this.field_146297_k.field_71441_e, this.routerPos.func_177958_n(), this.routerPos.func_177956_o(), this.routerPos.func_177952_p());
            }
        } else if (this.hand != null) {
            ModuleHelper.setFilterConfigSlot(this.field_146297_k.field_71439_g.func_184586_b(this.hand), filterSlotIndex);
            if (filter.hasGuiContainer()) {
                ModularRouters.network.sendToServer((IMessage)OpenGuiMessage.openFilterInModule(this.hand, filterSlotIndex));
            } else {
                this.field_146297_k.field_71439_g.openGui((Object)ModularRouters.instance, this.hand == EnumHand.MAIN_HAND ? ModularRouters.GUI_FILTER_HELD_MAIN : ModularRouters.GUI_FILTER_HELD_OFF, (World)this.field_146297_k.field_71441_e, 0, 0, 0);
            }
        }
        return true;
    }

    public void func_146281_b() {
        super.func_146281_b();
        if (this.sendDelay > 0) {
            this.sendModuleSettingsToServer();
        }
    }

    public void func_175321_a(int id, boolean value) {
    }

    public void func_175320_a(int id, float value) {
    }

    public void func_175319_a(int id, String value) {
        if (id == 0) {
            this.regulatorAmount = value.isEmpty() ? 0 : Integer.parseInt(value);
            this.sendModuleSettingsDelayed(5);
        }
    }

    protected TileEntityItemRouter getItemRouterTE() {
        if (this.routerPos != null) {
            TileEntity te = Minecraft.func_71410_x().field_71441_e.func_175625_s(this.routerPos);
            return te instanceof TileEntityItemRouter ? (TileEntityItemRouter)te : null;
        }
        return null;
    }

    public void func_71110_a(Container containerToSend, NonNullList<ItemStack> itemsList) {
    }

    public void func_71111_a(Container containerToSend, int slotInd, ItemStack stack) {
        if (slotInd >= 9 && slotInd < 13) {
            this.augmentCounter = new ItemAugment.AugmentCounter(this.moduleItemStack);
            this.setupButtonVisibility();
        }
    }

    public void func_71112_a(Container containerIn, int varToUpdate, int newValue) {
    }

    public void func_175173_a(Container containerIn, IInventory inventory) {
    }

    private int getFgColor(Color c) {
        int luminance = (int)Math.sqrt((double)(c.getRed() * c.getRed()) * 0.241 + (double)(c.getGreen() * c.getGreen()) * 0.691 + (double)(c.getBlue() * c.getBlue()) * 0.068);
        if (luminance > 129) {
            return 0x404040;
        }
        return 0xFFFFFF;
    }

    @Override
    public MouseOverHelp getMouseOverHelp() {
        return this.mouseOverHelp;
    }

    private static class DirectionButton
    extends RadioButton {
        private static final int DIRECTION_GROUP = 1;
        private final Module.RelativeDirection direction;

        DirectionButton(Module.RelativeDirection dir, Module module, int x, int y, boolean toggled) {
            super(dir.ordinal() + DIRECTION_BASE_ID, 1, x, y, 16, 16, toggled);
            this.direction = dir;
            String dirStr = module.getDirectionString(dir);
            this.tooltip1.add(TextFormatting.GRAY + dirStr);
            this.tooltip2.add(TextFormatting.YELLOW + dirStr);
        }

        @Override
        protected int getTextureX() {
            return this.direction.ordinal() * 16 * 2 + (this.isToggled() ? 16 : 0);
        }

        @Override
        protected int getTextureY() {
            return 48;
        }

        public Module.RelativeDirection getDirection() {
            return this.direction;
        }
    }

    private static class ModuleToggleButton
    extends TexturedToggleButton {
        ModuleToggleButton(Module.ModuleFlags setting, int x, int y, boolean toggled) {
            super(setting.ordinal(), x, y, 16, 16, toggled);
            MiscUtil.appendMultiline(this.tooltip1, "guiText.tooltip." + (Object)((Object)Module.ModuleFlags.values()[this.field_146127_k]) + ".1", new Object[0]);
            MiscUtil.appendMultiline(this.tooltip2, "guiText.tooltip." + (Object)((Object)Module.ModuleFlags.values()[this.field_146127_k]) + ".2", new Object[0]);
        }

        @Override
        protected int getTextureX() {
            return this.field_146127_k * 16 * 2 + (this.isToggled() ? 16 : 0);
        }

        @Override
        protected int getTextureY() {
            return 32;
        }
    }

    private static class RegulatorTooltipButton
    extends TexturedButton {
        public RegulatorTooltipButton(int buttonId, int x, int y, boolean isFluid) {
            super(buttonId, x, y, 16, 16);
            MiscUtil.appendMultiline(this.tooltip1, isFluid ? "guiText.tooltip.fluidRegulatorTooltip" : "guiText.tooltip.regulatorTooltip", new Object[0]);
            MiscUtil.appendMultiline(this.tooltip1, "guiText.tooltip.numberFieldTooltip", new Object[0]);
        }

        @Override
        protected int getTextureX() {
            return 112;
        }

        @Override
        protected int getTextureY() {
            return 0;
        }

        @Override
        protected boolean drawStandardBackground() {
            return false;
        }

        public void func_146113_a(SoundHandler soundHandlerIn) {
        }
    }
}

