/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.client.gui.module;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import me.desht.modularrouters.client.RenderHelper;
import me.desht.modularrouters.client.gui.module.GuiModule;
import me.desht.modularrouters.client.gui.widgets.button.ItemStackCyclerButton;
import me.desht.modularrouters.client.gui.widgets.button.TexturedCyclerButton;
import me.desht.modularrouters.container.ContainerModule;
import me.desht.modularrouters.core.RegistrarMR;
import me.desht.modularrouters.logic.compiled.CompiledPlayerModule;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;

public class GuiModulePlayer
extends GuiModule {
    private static final ItemStack mainInvStack = new ItemStack((Block)Blocks.field_150486_ae);
    private static final ItemStack armourStack = new ItemStack((Item)Items.field_151163_ad);
    private static final ItemStack shieldStack = new ItemStack(Items.field_185159_cQ);
    private static final ItemStack enderStack = new ItemStack(Blocks.field_150477_bB);
    private static final ItemStack routerStack = new ItemStack((Block)RegistrarMR.ITEM_ROUTER);
    private static final int OP_BUTTON_ID = 1000;
    private static final int SECT_BUTTON_ID = 1001;
    private CompiledPlayerModule.Operation operation;
    private CompiledPlayerModule.Section section;

    public GuiModulePlayer(ContainerModule containerItem, EnumHand hand) {
        this(containerItem, null, -1, hand);
    }

    public GuiModulePlayer(ContainerModule containerItem, BlockPos routerPos, Integer slotIndex, EnumHand hand) {
        super(containerItem, routerPos, slotIndex, hand);
        CompiledPlayerModule cpm = new CompiledPlayerModule(null, this.moduleItemStack);
        this.operation = cpm.getOperation();
        this.section = cpm.getSection();
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        ItemStack[] stacks = new ItemStack[]{mainInvStack, armourStack, shieldStack, enderStack};
        this.field_146292_n.add(new SectionButton(1001, this.field_147003_i + 169, this.field_147009_r + 32, 16, 16, true, stacks, this.section));
        this.field_146292_n.add(new OperationButton(1000, this.field_147003_i + 148, this.field_147009_r + 32, this.operation));
        this.getMouseOverHelp().addHelpRegion(this.field_147003_i + 127, this.field_147009_r + 29, this.field_147003_i + 187, this.field_147009_r + 50, "guiText.popup.player.control");
    }

    @Override
    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        super.func_146976_a(partialTicks, mouseX, mouseY);
        this.func_73729_b(this.field_147003_i + 167, this.field_147009_r + 31, GuiModulePlayer.BUTTON_XY.x, GuiModulePlayer.BUTTON_XY.y, 18, 18);
        RenderHelper.renderItemStack(this.field_146297_k, routerStack, this.field_147003_i + 128, this.field_147009_r + 32, "");
    }

    @Override
    protected void func_146284_a(GuiButton button) {
        switch (button.field_146127_k) {
            case 1000: {
                OperationButton opb = (OperationButton)button;
                this.operation = (CompiledPlayerModule.Operation)((Object)opb.cycle(!GuiScreen.func_146272_n()));
                this.sendModuleSettingsToServer();
                break;
            }
            case 1001: {
                SectionButton sectb = (SectionButton)button;
                this.section = (CompiledPlayerModule.Section)((Object)sectb.cycle(!GuiScreen.func_146272_n()));
                this.sendModuleSettingsToServer();
                break;
            }
            default: {
                super.func_146284_a(button);
            }
        }
    }

    @Override
    protected NBTTagCompound buildMessageData() {
        NBTTagCompound compound = super.buildMessageData();
        compound.func_74768_a("Operation", this.operation.ordinal());
        compound.func_74768_a("Section", this.section.ordinal());
        return compound;
    }

    private static class OperationButton
    extends TexturedCyclerButton<CompiledPlayerModule.Operation> {
        private final List<List<String>> tooltips = Lists.newArrayList();

        OperationButton(int buttonId, int x, int y, CompiledPlayerModule.Operation initialVal) {
            super(buttonId, x, y, 16, 16, initialVal);
            for (CompiledPlayerModule.Operation op : CompiledPlayerModule.Operation.values()) {
                this.tooltips.add(Collections.singletonList(I18n.func_135052_a((String)("guiText.label.playerOp." + (Object)((Object)op)), (Object[])new Object[0])));
            }
        }

        @Override
        protected int getTextureX() {
            return 160 + ((CompiledPlayerModule.Operation)((Object)this.getState())).ordinal() * 16;
        }

        @Override
        protected int getTextureY() {
            return 16;
        }

        @Override
        public List<String> getTooltip() {
            return this.tooltips.get(((CompiledPlayerModule.Operation)((Object)this.getState())).ordinal());
        }
    }

    private static class SectionButton
    extends ItemStackCyclerButton<CompiledPlayerModule.Section> {
        private final List<List<String>> tips = Lists.newArrayList();

        SectionButton(int buttonId, int x, int y, int width, int height, boolean flat, ItemStack[] stacks, CompiledPlayerModule.Section initialVal) {
            super(buttonId, x, y, width, height, flat, stacks, initialVal);
            for (CompiledPlayerModule.Section sect : CompiledPlayerModule.Section.values()) {
                this.tips.add(Collections.singletonList(I18n.func_135052_a((String)("guiText.label.playerSect." + (Object)((Object)sect)), (Object[])new Object[0])));
            }
        }

        @Override
        public List<String> getTooltip() {
            return this.tips.get(((CompiledPlayerModule.Section)((Object)this.getState())).ordinal());
        }
    }
}

