/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.client.gui.widgets.textfield;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import me.desht.modularrouters.client.gui.widgets.textfield.TextFieldWidget;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.GlStateManager;
import org.lwjgl.input.Mouse;

public class TextFieldManager {
    private final List<TextFieldWidget> textFields = Lists.newArrayList();
    private int focusedField = -1;
    private final GuiScreen parent;

    public TextFieldManager(GuiScreen parent) {
        this.parent = parent;
    }

    public void drawTextFields() {
        GlStateManager.func_179140_f();
        GlStateManager.func_179084_k();
        this.textFields.forEach(GuiTextField::func_146194_f);
    }

    public void updateTextFields() {
        if (this.focusedField >= 0) {
            this.textFields.get(this.focusedField).func_146178_a();
        }
    }

    public boolean handleMouseInput() throws IOException {
        int wheel = Mouse.getEventDWheel();
        if (wheel == 0) {
            return false;
        }
        if (this.focusedField >= 0) {
            this.textFields.get(this.focusedField).onMouseWheel(wheel < 0 ? -1 : 1);
            return true;
        }
        int mouseX = Mouse.getEventX() * this.parent.field_146294_l / this.parent.field_146297_k.field_71443_c;
        int mouseY = this.parent.field_146295_m - Mouse.getEventY() * this.parent.field_146295_m / this.parent.field_146297_k.field_71440_d - 1;
        for (int i = 0; i < this.textFields.size(); ++i) {
            TextFieldWidget field = this.textFields.get(i);
            if (mouseX < field.field_146209_f || mouseX >= field.field_146209_f + field.field_146218_h || mouseY < field.field_146210_g || mouseY >= field.field_146210_g + field.field_146219_i) continue;
            this.focus(i);
            field.onMouseWheel(wheel < 0 ? -1 : 1);
            return true;
        }
        return false;
    }

    public void mouseClicked(int x, int y, int btn) throws IOException {
        for (TextFieldWidget field : this.textFields) {
            field.func_146192_a(x, y, btn);
        }
    }

    public boolean keyTyped(char typedChar, int keyCode) throws IOException {
        if (keyCode == 15) {
            if (GuiScreen.func_146272_n()) {
                this.focusPrev();
            } else {
                this.focusNext();
            }
        } else if (this.isFocused()) {
            this.textFields.get(this.focusedField).func_146201_a(typedChar, keyCode);
            if (keyCode == 18) {
                return true;
            }
        }
        return false;
    }

    int addTextField(TextFieldWidget textField) {
        this.textFields.add(textField);
        return this.textFields.size() - 1;
    }

    public void focus(int field) {
        if (field != this.focusedField) {
            if (this.focusedField != -1) {
                this.textFields.get(this.focusedField).func_146195_b(false);
            }
            this.focusedField = field;
            if (this.focusedField != -1) {
                this.textFields.get(this.focusedField).func_146195_b(true);
            }
        }
    }

    private void focusNext() {
        int field = this.focusedField + 1;
        if (field >= this.textFields.size()) {
            field = 0;
        }
        this.focus(field);
    }

    private void focusPrev() {
        int field = this.focusedField - 1;
        if (field < 0) {
            field = this.textFields.size() - 1;
        }
        this.focus(field);
    }

    public boolean isFocused() {
        return this.focusedField >= 0;
    }

    void onTextFieldFocusChange(int ordinal, boolean newFocus) {
        if (ordinal == this.textFields.size() - 1) {
            this.focusedField = -1;
            for (TextFieldWidget t : this.textFields) {
                if (!t.func_146206_l()) continue;
                this.focusedField = t.getOrdinal();
                break;
            }
        }
    }

    public TextFieldManager clear() {
        this.textFields.clear();
        this.focusedField = -1;
        return this;
    }
}

