/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.config;

import me.desht.modularrouters.ModularRouters;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="modularrouters")
@Config.LangKey(value="gui.config.mainTitle")
public class ConfigHandler {
    @Config.Name(value="module")
    @Config.LangKey(value="gui.config.ctgy.module")
    public static Module module = new Module();
    @Config.Name(value="router")
    @Config.LangKey(value="gui.config.ctgy.router")
    public static Router router = new Router();
    @Config.Name(value="misc")
    @Config.LangKey(value="gui.config.ctgy.misc")
    public static Misc misc = new Misc();

    public static char getConfigKey() {
        return ConfigHandler.router.configKey.isEmpty() ? (char)'c' : ConfigHandler.router.configKey.charAt(0);
    }

    @Mod.EventBusSubscriber
    public static class ConfigSyncHandler {
        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("modularrouters")) {
                ConfigManager.sync((String)"modularrouters", (Config.Type)Config.Type.INSTANCE);
                ModularRouters.logger.info("Configuration has been saved.");
            }
        }
    }

    public static class Misc {
        @Config.LangKey(value="gui.config.startWithGuide")
        @Config.Comment(value={"Should new players start with a copy of the Modular Routers guidebook?"})
        public boolean startWithGuide = false;
        @Config.LangKey(value="gui.config.alwaysShowSettings")
        @Config.Comment(value={"Show module/upgrade/filter settings in tooltip without needing to hold down Shift?"})
        public boolean alwaysShowSettings = true;
    }

    public static class Router {
        @Config.LangKey(value="gui.config.configKey")
        @Config.Comment(value={"Key to press while mousing over a module in the Item Router GUI to configure the module"})
        public String configKey = "c";
        @Config.LangKey(value="gui.config.baseTickRate")
        @Config.RangeInt(min=1)
        @Config.Comment(value={"Base tick interval (in server ticks) for a router; router will run this often"})
        public int baseTickRate = 20;
        @Config.LangKey(value="gui.config.ticksPerUpgrade")
        @Config.RangeInt(min=1, max=20)
        @Config.Comment(value={"Number of ticks by which 1 Speed Upgrade will reduce the router's tick interval"})
        public int ticksPerUpgrade = 2;
        @Config.LangKey(value="gui.config.hardMinTicks")
        @Config.RangeInt(min=1)
        @Config.Comment(value={"Hard minimum tick interval for a router regardless of Speed Upgrades"})
        public int hardMinTickRate = 2;
        @Config.LangKey(value="gui.config.ecoTimeout")
        @Config.RangeInt(min=20)
        @Config.Comment(value={"Router with eco mode enabled will go into low-power mode if idle for this many server ticks"})
        public int ecoTimeout = 100;
        @Config.LangKey(value="gui.config.lowPowerTickRate")
        @Config.RangeInt(min=20)
        @Config.Comment(value={"Tick interval for an eco-mode router which has gone into low-power mode"})
        public int lowPowerTickRate = 100;
        @Config.LangKey(value="gui.config.fluidBaseTransferRate")
        @Config.RangeInt(min=1)
        @Config.Comment(value={"Base fluid transfer rate (mB/t in each direction) for a router"})
        public int fluidBaseTransferRate = 50;
        @Config.LangKey(value="gui.config.fluidMaxTransferRate")
        @Config.RangeInt(min=1)
        @Config.Comment(value={"Max fluid transfer rate (mB/t in each direction) for a router"})
        public int fluidMaxTransferRate = 400;
        @Config.LangKey(value="gui.config.mbPerFluidUpgrade")
        @Config.RangeInt(min=1)
        @Config.Comment(value={"Fluid transfer rate increase per Fluid Transfer Upgrade"})
        public int mBperFluidUpgrade = 10;
    }

    public static class Module {
        @Config.LangKey(value="gui.config.sender1BaseRange")
        @Config.RangeInt(min=1)
        @Config.Comment(value={"Base range for Sender Mk1 (no range upgrades)"})
        public int sender1BaseRange = 8;
        @Config.LangKey(value="gui.config.sender1MaxRange")
        @Config.RangeInt(min=1)
        @Config.Comment(value={"Max range for Sender Mk1"})
        public int sender1MaxRange = 16;
        @Config.LangKey(value="gui.config.sender2BaseRange")
        @Config.RangeInt(min=1)
        @Config.Comment(value={"Base range for Sender Mk2 (no range upgrades)"})
        public int sender2BaseRange = 24;
        @Config.LangKey(value="gui.config.sender2MaxRange")
        @Config.RangeInt(min=1)
        @Config.Comment(value={"Max range for Sender Mk2"})
        public int sender2MaxRange = 48;
        @Config.LangKey(value="gui.config.vacuumBaseRange")
        @Config.RangeInt(min=1)
        @Config.Comment(value={"Base range for Vacuum (no range upgrades)"})
        public int vacuumBaseRange = 6;
        @Config.LangKey(value="gui.config.vacuumMaxRange")
        @Config.RangeInt(min=1)
        @Config.Comment(value={"Max range for Vacuum"})
        public int vacuumMaxRange = 12;
        @Config.LangKey(value="gui.config.extruderBaseRange")
        @Config.RangeInt(min=1)
        @Config.Comment(value={"Base range for Extruder Mk1 (no range upgrades)"})
        public int extruderBaseRange = 12;
        @Config.LangKey(value="gui.config.extruderMaxRange")
        @Config.RangeInt(min=1)
        @Config.Comment(value={"Max range for Extruder Mk1"})
        public int extruderMaxRange = 24;
        @Config.LangKey(value="gui.config.extruder2BaseRange")
        @Config.RangeInt(min=1)
        @Config.Comment(value={"Base range for Extruder Mk2 (no range upgrades)"})
        public int extruder2BaseRange = 24;
        @Config.LangKey(value="gui.config.extruder2MaxRange")
        @Config.RangeInt(min=1)
        @Config.Comment(value={"Max range for Extruder Mk2"})
        public int extruder2MaxRange = 48;
        @Config.LangKey(value="gui.config.puller2BaseRange")
        @Config.RangeInt(min=1)
        @Config.Comment(value={"Base range for Puller Mk2 (no range upgrades)"})
        public int puller2BaseRange = 12;
        @Config.LangKey(value="gui.config.puller2MaxRange")
        @Config.RangeInt(min=1)
        @Config.Comment(value={"Max range for Puller Mk2"})
        public int puller2MaxRange = 24;
        @Config.LangKey(value="gui.config.senderParticles")
        @Config.Comment(value={"Should Sender modules show particle effects when sending?"})
        public boolean senderParticles = true;
        @Config.LangKey(value="gui.config.pullerParticles")
        @Config.Comment(value={"Should Puller modules show particle effects when pulling?"})
        public boolean pullerParticles = true;
        @Config.LangKey(value="gui.config.placerParticles")
        @Config.Comment(value={"Should Placer modules show particle effects when placing a block?"})
        public boolean placerParticles = false;
        @Config.LangKey(value="gui.config.breakerParticles")
        @Config.Comment(value={"Should Breaker modules show block particle effects when breaking a block?"})
        public boolean breakerParticles = true;
        @Config.LangKey(value="gui.config.vacuumParticles")
        @Config.Comment(value={"Should Vacuum modules show particle effects when absorbing items?"})
        public boolean vacuumParticles = true;
        @Config.LangKey(value="gui.config.flingerEffects")
        @Config.Comment(value={"Should Flinger modules show smoke effects & play a sound when flinging items?"})
        public boolean flingerEffects = true;
        @Config.LangKey(value="gui.config.extruderSound")
        @Config.Comment(value={"Should Extruder (Mk1 & 2) modules play a sound when placing blocks?"})
        public boolean extruderSound = true;
        @Config.LangKey(value="gui.config.backgroundTint")
        @Config.Comment(value={"Should the module GUI background be tinted like the module item colour?"})
        public boolean backgroundTint = true;
        @Config.LangKey(value="gui.config.extruderPushEnties")
        @Config.Comment(value={"Should the Extruder Mk1/2 push entities along when extruding blocks?"})
        public boolean extruderPushEntities = true;
        @Config.LangKey(value="gui.config.breakerHarvestLimit")
        @Config.Comment(value={"Should Breaker & Extruder Mk1 Modules respect the harvest level of the pickaxe used to craft them? (e.g. craft with an Iron Pickaxe => can't break Obsidian)"})
        public boolean breakerHarvestLimit = true;
    }
}

