/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.container.handler;

import java.util.Arrays;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.IItemHandlerModifiable;

public class GhostItemHandler
implements IItemHandlerModifiable,
INBTSerializable<NBTTagList> {
    protected final ItemStack[] items;

    public GhostItemHandler(int size) {
        this.items = new ItemStack[size];
        Arrays.fill(this.items, ItemStack.field_190927_a);
    }

    public NBTTagList serializeNBT() {
        NBTTagList items = new NBTTagList();
        for (int i = 0; i < this.getSlots(); ++i) {
            if (this.getStackInSlot(i).func_190926_b()) continue;
            NBTTagCompound item = new NBTTagCompound();
            item.func_74768_a("Slot", i);
            this.getStackInSlot(i).func_77955_b(item);
            items.func_74742_a((NBTBase)item);
        }
        return items;
    }

    public void deserializeNBT(NBTTagList list) {
        for (int i = 0; i < list.func_74745_c(); ++i) {
            ItemStack stack;
            NBTTagCompound compound = list.func_150305_b(i);
            int slot = compound.func_74762_e("Slot");
            if (slot < 0 || slot >= this.items.length || (stack = new ItemStack(compound)).func_190926_b()) continue;
            this.items[slot] = stack;
        }
    }

    public int getSlots() {
        return this.items.length;
    }

    public ItemStack getStackInSlot(int slot) {
        return this.items[slot];
    }

    @Nonnull
    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (!simulate) {
            ItemStack stack1 = stack.func_77946_l();
            stack1.func_190920_e(1);
            this.items[slot] = stack1;
        }
        return stack;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (!simulate) {
            this.items[slot] = ItemStack.field_190927_a;
        }
        return ItemStack.field_190927_a;
    }

    public int getSlotLimit(int slot) {
        return 1;
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        this.items[slot] = stack;
    }
}

