/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.integration.guideapi;

import amerifrance.guideapi.api.GuideAPI;
import amerifrance.guideapi.api.GuideBook;
import amerifrance.guideapi.api.IGuideBook;
import amerifrance.guideapi.api.IPage;
import amerifrance.guideapi.api.impl.Book;
import amerifrance.guideapi.api.impl.abstraction.CategoryAbstract;
import amerifrance.guideapi.api.impl.abstraction.EntryAbstract;
import amerifrance.guideapi.api.util.PageHelper;
import amerifrance.guideapi.category.CategoryItemStack;
import amerifrance.guideapi.entry.EntryItemStack;
import amerifrance.guideapi.page.PageIRecipe;
import amerifrance.guideapi.page.PageText;
import com.google.common.collect.Lists;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import me.desht.modularrouters.ModularRouters;
import me.desht.modularrouters.block.tile.TileEntityItemRouter;
import me.desht.modularrouters.config.ConfigHandler;
import me.desht.modularrouters.core.RegistrarMR;
import me.desht.modularrouters.item.augment.ItemAugment;
import me.desht.modularrouters.item.module.ItemModule;
import me.desht.modularrouters.item.smartfilter.ItemSmartFilter;
import me.desht.modularrouters.item.upgrade.ItemUpgrade;
import me.desht.modularrouters.util.MiscUtil;
import me.desht.modularrouters.util.ModuleHelper;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.ShapelessOreRecipe;

@GuideBook
public class Guidebook
implements IGuideBook {
    private static final int MAX_PAGE_LENGTH = 270;
    private static final int CAT_INTRO = 0;
    private static final int CAT_ROUTER = 1;
    private static final int CAT_MODULES = 2;
    private static final int CAT_UPGRADES = 3;
    private static final int CAT_AUGMENTS = 4;
    private static final int CAT_FILTERS = 5;
    private static Book guideBook;

    @Nullable
    public Book buildBook() {
        ArrayList<CategoryItemStack> categories = new ArrayList<CategoryItemStack>();
        LinkedHashMap<Object, Object> entries = new LinkedHashMap<ResourceLocation, EntryAbstract>();
        List<Object> pages = new ArrayList(PageHelper.pagesForLongText((String)MiscUtil.translate("guidebook.para.introText", new Object[0]), (int)270));
        entries.put(MiscUtil.RL("intro"), new EntryItemStack(pages, MiscUtil.translate("guidebook.words.overview", new Object[0]), new ItemStack((Block)RegistrarMR.ITEM_ROUTER)));
        categories.add(new CategoryItemStack(entries, MiscUtil.translate("guidebook.categories.introduction", new Object[0]), new ItemStack(Items.field_151099_bA)));
        entries = new LinkedHashMap();
        pages = new ArrayList(PageHelper.pagesForLongText((String)MiscUtil.translate("guidebook.para.routerText", new Object[0]), (int)270));
        entries.put(MiscUtil.RL("router"), new EntryItemStack(pages, MiscUtil.translate("tile.item_router.name", new Object[0]), new ItemStack((Block)RegistrarMR.ITEM_ROUTER)));
        pages = new ArrayList(PageHelper.pagesForLongText((String)MiscUtil.translate("guidebook.para.routerEcoMode", ItemModule.ModuleType.values().length, String.valueOf(ConfigHandler.getConfigKey())), (int)270));
        entries.put(MiscUtil.RL("routerEcoMode"), new EntryItemStack(pages, MiscUtil.translate("guidebook.words.ecoMode", new Object[0]), new ItemStack(Blocks.field_150345_g)));
        categories.add(new CategoryItemStack(entries, MiscUtil.translate("guidebook.categories.routers", new Object[0]), new ItemStack((Block)RegistrarMR.ITEM_ROUTER)));
        entries = new LinkedHashMap();
        pages = new ArrayList(PageHelper.pagesForLongText((String)MiscUtil.translate("guidebook.para.moduleOverview", ItemModule.ModuleType.values().length, String.valueOf(ConfigHandler.getConfigKey())), (int)270));
        entries.put(MiscUtil.RL("moduleOverview"), new EntryItemStack(pages, MiscUtil.translate("guidebook.words.overview", new Object[0]), new ItemStack(Items.field_151122_aG)));
        pages = Collections.singletonList(new PageText(MiscUtil.translate("guidebook.para.blankModule", new Object[0])));
        ItemStack bm = new ItemStack((Item)RegistrarMR.BLANK_MODULE);
        entries.put(MiscUtil.RL("blankModule"), new EntryItemStack(pages, MiscUtil.translate(bm.func_77977_a() + ".name", new Object[0]), bm));
        Guidebook.buildModulePages(entries);
        categories.add(new CategoryItemStack(entries, MiscUtil.translate("guiText.label.modules", new Object[0]), new ItemStack((Item)RegistrarMR.BLANK_MODULE)));
        entries = new LinkedHashMap();
        pages = new ArrayList(PageHelper.pagesForLongText((String)MiscUtil.translate("guidebook.para.upgradeOverview", ItemUpgrade.UpgradeType.values().length, new TileEntityItemRouter().getUpgradeSlotCount()), (int)270));
        entries.put(MiscUtil.RL("upgradeOverview"), (EntryAbstract)new EntryItemStack(pages, MiscUtil.translate("guidebook.words.overview", new Object[0]), new ItemStack(Items.field_151122_aG)));
        pages = Collections.singletonList(new PageText(MiscUtil.translate("guidebook.para.blankUpgrade", new Object[0])));
        ItemStack bu = new ItemStack((Item)RegistrarMR.BLANK_UPGRADE);
        entries.put(MiscUtil.RL("blankUpgrade"), new EntryItemStack(pages, MiscUtil.translate(bu.func_77977_a() + ".name", new Object[0]), bu));
        Guidebook.buildUpgradePages(entries);
        categories.add(new CategoryItemStack(entries, MiscUtil.translate("guiText.label.upgrades", new Object[0]), new ItemStack((Item)RegistrarMR.BLANK_UPGRADE)));
        entries = new LinkedHashMap();
        pages = new ArrayList(PageHelper.pagesForLongText((String)MiscUtil.translate("guidebook.para.augmentOverview", new Object[0]), (int)270));
        entries.put(MiscUtil.RL("augmentOverview"), (EntryAbstract)new EntryItemStack(pages, MiscUtil.translate("guidebook.words.overview", new Object[0]), new ItemStack(Items.field_151122_aG)));
        pages = Collections.singletonList(new PageText(MiscUtil.translate("guidebook.para.augmentCore", new Object[0])));
        ItemStack ba = new ItemStack((Item)RegistrarMR.AUGMENT_CORE);
        entries.put(MiscUtil.RL("augmentCore"), new EntryItemStack(pages, MiscUtil.translate(ba.func_77977_a() + ".name", new Object[0]), ba));
        Guidebook.buildAugmentPages(entries);
        categories.add(new CategoryItemStack(entries, MiscUtil.translate("guidebook.words.augments", new Object[0]), new ItemStack((Item)RegistrarMR.AUGMENT_CORE)));
        entries = new LinkedHashMap();
        pages = new ArrayList(PageHelper.pagesForLongText((String)MiscUtil.translate("guidebook.para.filterOverview", ItemSmartFilter.FilterType.values().length), (int)270));
        entries.put(MiscUtil.RL("filterOverview"), (EntryAbstract)new EntryItemStack(pages, MiscUtil.translate("guidebook.words.overview", new Object[0]), new ItemStack(Items.field_151122_aG)));
        Guidebook.buildFilterPages(entries);
        categories.add(new CategoryItemStack(entries, MiscUtil.translate("guiText.label.filters", new Object[0]), ItemSmartFilter.makeItemStack(ItemSmartFilter.FilterType.BULKITEM)));
        guideBook = new Book();
        guideBook.setAuthor("desht");
        guideBook.setTitle("Modular Routers Guide");
        guideBook.setDisplayName("Modular Routers Guide");
        guideBook.setColor(Color.CYAN);
        guideBook.setCategoryList(categories);
        guideBook.setRegistryName(MiscUtil.RL("guidebook"));
        guideBook.setSpawnWithBook(ConfigHandler.misc.startWithGuide);
        return guideBook;
    }

    private static void buildAugmentPages(Map<ResourceLocation, EntryAbstract> entries) {
        List types = Lists.newArrayList((Object[])ItemAugment.AugmentType.values()).stream().map(ItemAugment::makeItemStack).sorted(Comparator.comparing(s -> MiscUtil.translate(s.func_77977_a(), new Object[0]))).map(ItemAugment.AugmentType::getType).collect(Collectors.toList());
        for (ItemAugment.AugmentType type : types) {
            ItemStack module = ItemAugment.makeItemStack(type);
            String unlocalizedName = module.func_77973_b().func_77667_c(module);
            ArrayList pages1 = Lists.newArrayList();
            pages1.add(new PageText(MiscUtil.translate("itemText.usage." + unlocalizedName, new Object[0])));
            String localizedName = MiscUtil.translate(unlocalizedName + ".name", new Object[0]);
            entries.put(MiscUtil.RL(unlocalizedName), (EntryAbstract)new EntryItemStack((List)pages1, localizedName, module));
        }
    }

    private static void buildFilterPages(Map<ResourceLocation, EntryAbstract> entries) {
        List types = Lists.newArrayList((Object[])ItemSmartFilter.FilterType.values()).stream().map(ItemSmartFilter::makeItemStack).sorted(Comparator.comparing(s -> MiscUtil.translate(s.func_77977_a(), new Object[0]))).map(ItemSmartFilter.FilterType::getType).collect(Collectors.toList());
        for (ItemSmartFilter.FilterType type : types) {
            ItemStack module = ItemSmartFilter.makeItemStack(type);
            String unlocalizedName = module.func_77973_b().func_77667_c(module);
            ArrayList pages1 = Lists.newArrayList();
            pages1.add(new PageText(MiscUtil.translate("itemText.usage." + unlocalizedName, new Object[0])));
            String localizedName = MiscUtil.translate(unlocalizedName + ".name", new Object[0]);
            entries.put(MiscUtil.RL(unlocalizedName), (EntryAbstract)new EntryItemStack((List)pages1, localizedName, module));
        }
    }

    private static void buildModulePages(Map<ResourceLocation, EntryAbstract> entries) {
        List types = Lists.newArrayList((Object[])ItemModule.ModuleType.values()).stream().map(ModuleHelper::makeItemStack).sorted(Comparator.comparing(s -> MiscUtil.translate(s.func_77977_a(), new Object[0]))).map(ItemModule.ModuleType::getType).collect(Collectors.toList());
        for (ItemModule.ModuleType type : types) {
            ItemStack module = ModuleHelper.makeItemStack(type);
            String unlocalizedName = module.func_77973_b().func_77667_c(module);
            ArrayList pages1 = Lists.newArrayList();
            pages1.add(new PageText(MiscUtil.translate("itemText.usage." + unlocalizedName, new Object[0])));
            String localizedName = MiscUtil.translate(unlocalizedName + ".name", new Object[0]);
            entries.put(MiscUtil.RL(unlocalizedName), (EntryAbstract)new EntryItemStack((List)pages1, localizedName, module));
        }
    }

    private static void buildUpgradePages(Map<ResourceLocation, EntryAbstract> entries) {
        List types = Lists.newArrayList((Object[])ItemUpgrade.UpgradeType.values()).stream().map(ItemUpgrade::makeItemStack).sorted(Comparator.comparing(s -> MiscUtil.translate(s.func_77977_a(), new Object[0]))).map(ItemUpgrade.UpgradeType::getType).collect(Collectors.toList());
        for (ItemUpgrade.UpgradeType type : types) {
            ItemStack upgrade = ItemUpgrade.makeItemStack(type);
            String unlocalizedName = upgrade.func_77973_b().func_77667_c(upgrade);
            ArrayList pages1 = Lists.newArrayList();
            pages1.add(new PageText(MiscUtil.translate("itemText.usage." + unlocalizedName, ItemUpgrade.getUpgrade(type).getExtraUsageParams())));
            String localizedName = MiscUtil.translate(unlocalizedName + ".name", new Object[0]);
            entries.put(MiscUtil.RL(unlocalizedName), (EntryAbstract)new EntryItemStack((List)pages1, localizedName, upgrade));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void handleModel(ItemStack bookStack) {
        GuideAPI.setModel((Book)guideBook);
    }

    public void handlePost(ItemStack bookStack) {
        ShapelessOreRecipe bookRecipe = new ShapelessOreRecipe(MiscUtil.RL("guidebook"), bookStack, new Object[]{RegistrarMR.BLANK_MODULE, Items.field_151122_aG});
        ForgeRegistries.RECIPES.register(bookRecipe.setRegistryName(new ResourceLocation("guideapi", "guidebook")));
        this.addRecipePage(1, "router", "item_router");
        this.addRecipePage(2, "moduleOverview", "blank_module");
        this.addRecipePage(3, "upgradeOverview", "blank_upgrade");
        this.addRecipePage(4, "augmentOverview", "augment_core");
        this.addItemRecipes(2, ItemModule.ModuleType.class, "module");
        this.addItemRecipes(3, ItemUpgrade.UpgradeType.class, "upgrade");
        this.addItemRecipes(4, ItemAugment.AugmentType.class, "augment");
        this.addItemRecipes(5, ItemSmartFilter.FilterType.class, "filter");
    }

    private void addItemRecipes(int categoryNumber, Class<? extends Enum<?>> c, String tag) {
        for (Enum<?> e : c.getEnumConstants()) {
            String registeredName = e.toString().toLowerCase() + "_" + tag;
            this.addRecipePage(categoryNumber, "item." + registeredName, tag + "/" + registeredName);
        }
    }

    private void addRecipePage(int categoryNumber, String entryName, String recipeName) {
        IRecipe recipe = CraftingManager.func_193373_a((ResourceLocation)MiscUtil.RL(recipeName));
        if (recipe != null) {
            ((CategoryAbstract)guideBook.getCategoryList().get(categoryNumber)).getEntry(MiscUtil.RL(entryName)).addPage((IPage)new PageIRecipe(recipe));
        } else {
            ModularRouters.logger.warn("no recipe found for " + MiscUtil.RL(recipeName));
        }
    }
}

