/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.integration.jei;

import java.util.List;
import javax.annotation.Nonnull;
import me.desht.modularrouters.ModularRouters;
import me.desht.modularrouters.recipe.enhancement.ModuleEnhancementRecipe;
import me.desht.modularrouters.util.MiscUtil;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.gui.ICraftingGridHelper;
import mezz.jei.api.gui.IGuiIngredientGroup;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ITooltipCallback;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IStackHelper;
import mezz.jei.api.recipe.wrapper.ICustomCraftingRecipeWrapper;
import mezz.jei.api.recipe.wrapper.IShapedCraftingRecipeWrapper;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;

public class ModuleEnhancementRecipeWrapper
implements ICustomCraftingRecipeWrapper,
IShapedCraftingRecipeWrapper,
ITooltipCallback<ItemStack> {
    private static final int craftOutputSlot = 0;
    private static final int craftInputSlot1 = 1;
    private final IJeiHelpers helpers;
    private final ModuleEnhancementRecipe recipe;
    private final String name;
    private final List<String> description;

    ModuleEnhancementRecipeWrapper(IJeiHelpers helpers, ModuleEnhancementRecipe recipe) {
        this.helpers = helpers;
        this.recipe = recipe;
        this.name = I18n.func_135052_a((String)("jei.recipe." + recipe.getRecipeId() + ".name"), (Object[])new Object[0]);
        this.description = MiscUtil.wrapString(I18n.func_135052_a((String)("jei.recipe." + recipe.getRecipeId() + ".description"), (Object[])new Object[0]));
    }

    public void getIngredients(@Nonnull IIngredients ingredients) {
        IStackHelper stackHelper = this.helpers.getStackHelper();
        ItemStack recipeOutput = this.recipe.func_77571_b();
        try {
            List inputs = stackHelper.expandRecipeItemStackInputs((List)this.recipe.func_192400_c());
            ingredients.setInputLists(ItemStack.class, inputs);
            ingredients.setOutput(ItemStack.class, (Object)recipeOutput);
        }
        catch (RuntimeException e) {
            ModularRouters.logger.warn("broken recipe: " + ((Object)((Object)this.recipe)).getClass() + " - " + e.getMessage());
            e.printStackTrace();
        }
    }

    public void onTooltip(int slotIndex, boolean input, @Nonnull ItemStack ingredient, @Nonnull List<String> tooltip) {
        if (slotIndex == 0 && !input) {
            tooltip.add(TextFormatting.GREEN + TextFormatting.BOLD.toString() + this.name);
            for (String d : this.description) {
                tooltip.add(TextFormatting.GREEN + d);
            }
        }
    }

    public int getWidth() {
        return 3;
    }

    public int getHeight() {
        return 3;
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.addTooltipCallback((ITooltipCallback)this);
        List inputs = ingredients.getInputs(ItemStack.class);
        List outputs = ingredients.getOutputs(ItemStack.class);
        guiItemStacks.set(0, (ItemStack)((List)outputs.get(0)).get(0));
        ICraftingGridHelper craftingGridHelper = this.helpers.getGuiHelper().createCraftingGridHelper(1, 0);
        craftingGridHelper.setInputs((IGuiIngredientGroup)guiItemStacks, inputs, this.getWidth(), this.getHeight());
    }
}

