/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.integration.top;

import io.netty.buffer.ByteBuf;
import mcjty.theoneprobe.api.IElement;
import mcjty.theoneprobe.api.IItemStyle;
import mcjty.theoneprobe.apiimpl.styles.ItemStyle;
import me.desht.modularrouters.client.RenderHelper;
import me.desht.modularrouters.integration.top.TOPCompatibility;
import me.desht.modularrouters.item.module.ItemModule;
import me.desht.modularrouters.item.module.Module;
import me.desht.modularrouters.util.ModuleHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.item.ItemStack;

public class ElementModule
implements IElement {
    private static final String ARROWS = " \u25bc\u25b2\u25c0\u25b6\u25a3\u25a4";
    private final ItemModule.ModuleType type;
    private final Module.RelativeDirection dir;

    public ElementModule(ItemStack stack) {
        this.type = ItemModule.ModuleType.values()[stack.func_77952_i()];
        this.dir = ModuleHelper.getDirectionFromNBT(stack);
    }

    public ElementModule(ByteBuf buf) {
        this.type = ItemModule.ModuleType.values()[buf.readByte()];
        this.dir = Module.RelativeDirection.values()[buf.readByte()];
    }

    public void render(int x, int y) {
        RenderItem itemRender = Minecraft.func_71410_x().func_175599_af();
        ItemStack stack = ModuleHelper.makeItemStack(this.type);
        IItemStyle style = new ItemStyle().width(this.getWidth()).height(this.getHeight());
        String dirStr = String.valueOf(ARROWS.charAt(this.dir.ordinal()));
        RenderHelper.renderItemStack(Minecraft.func_71410_x(), stack, x + (style.getWidth() - 18) / 2, y + (style.getHeight() - 18) / 2, dirStr);
    }

    public int getWidth() {
        return 20;
    }

    public int getHeight() {
        return 20;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeByte(this.type.ordinal());
        buf.writeByte(this.dir.ordinal());
    }

    public int getID() {
        return TOPCompatibility.ELEMENT_MODULE_ITEM;
    }
}

