/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.item.augment;

import javax.annotation.Nonnull;
import me.desht.modularrouters.container.handler.AugmentHandler;
import me.desht.modularrouters.core.RegistrarMR;
import me.desht.modularrouters.item.ItemSubTypes;
import me.desht.modularrouters.item.augment.Augment;
import me.desht.modularrouters.item.augment.FastPickupAugment;
import me.desht.modularrouters.item.augment.MimicAugment;
import me.desht.modularrouters.item.augment.PickupDelayAugment;
import me.desht.modularrouters.item.augment.PushingAugment;
import me.desht.modularrouters.item.augment.RangeAugments;
import me.desht.modularrouters.item.augment.RedstoneAugment;
import me.desht.modularrouters.item.augment.RegulatorAugment;
import me.desht.modularrouters.item.augment.StackAugment;
import me.desht.modularrouters.item.augment.XPVacuumAugment;
import me.desht.modularrouters.item.module.ItemModule;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class ItemAugment
extends ItemSubTypes<AugmentType> {
    public ItemAugment() {
        super("augment", AugmentType.class);
        this.register(AugmentType.FAST_PICKUP, new FastPickupAugment());
        this.register(AugmentType.PICKUP_DELAY, new PickupDelayAugment());
        this.register(AugmentType.RANGE_UP, new RangeAugments.RangeUpAugment());
        this.register(AugmentType.RANGE_DOWN, new RangeAugments.RangeDownAugment());
        this.register(AugmentType.REDSTONE, new RedstoneAugment());
        this.register(AugmentType.REGULATOR, new RegulatorAugment());
        this.register(AugmentType.STACK, new StackAugment());
        this.register(AugmentType.XP_VACUUM, new XPVacuumAugment());
        this.register(AugmentType.MIMIC, new MimicAugment());
        this.register(AugmentType.PUSHING, new PushingAugment());
    }

    public static Augment getAugment(ItemStack stack) {
        if (!(stack.func_77973_b() instanceof ItemAugment) || stack.func_77960_j() >= AugmentType.values().length) {
            return null;
        }
        return ItemAugment.getAugment(AugmentType.values()[stack.func_77960_j()]);
    }

    public static ItemStack makeItemStack(AugmentType type) {
        return ItemAugment.makeItemStack(type, 1);
    }

    public static ItemStack makeItemStack(AugmentType type, int amount) {
        return new ItemStack((Item)RegistrarMR.AUGMENT, amount, type.ordinal());
    }

    @Nonnull
    public static Augment getAugment(AugmentType type) {
        return (Augment)RegistrarMR.AUGMENT.getHandler(type);
    }

    public static class AugmentCounter {
        private int[] counts = new int[AugmentType.values().length];

        public AugmentCounter(ItemStack moduleStack) {
            if (!(moduleStack.func_77973_b() instanceof ItemModule)) {
                throw new IllegalArgumentException("item is not a ItemModule: " + moduleStack);
            }
            AugmentHandler h = new AugmentHandler(moduleStack);
            for (int i = 0; i < h.getSlots(); ++i) {
                ItemStack augmentStack = h.getStackInSlot(i);
                AugmentType type = AugmentType.getType(augmentStack);
                if (type == null) continue;
                int n = type.ordinal();
                this.counts[n] = this.counts[n] + augmentStack.func_190916_E();
            }
        }

        public int getAugmentCount(AugmentType type) {
            return this.counts[type.ordinal()];
        }
    }

    public static enum AugmentType {
        FAST_PICKUP,
        PICKUP_DELAY,
        RANGE_UP,
        RANGE_DOWN,
        REDSTONE,
        REGULATOR,
        STACK,
        XP_VACUUM,
        MIMIC,
        PUSHING;


        public static AugmentType getType(ItemStack stack) {
            return stack.func_77973_b() instanceof ItemAugment ? AugmentType.values()[stack.func_77952_i()] : null;
        }
    }
}

