/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.item.module;

import me.desht.modularrouters.ModularRouters;
import me.desht.modularrouters.core.RegistrarMR;
import me.desht.modularrouters.item.ItemSubTypes;
import me.desht.modularrouters.item.module.ActivatorModule;
import me.desht.modularrouters.item.module.BreakerModule;
import me.desht.modularrouters.item.module.DetectorModule;
import me.desht.modularrouters.item.module.DistributorModule;
import me.desht.modularrouters.item.module.DropperModule;
import me.desht.modularrouters.item.module.ExtruderModule;
import me.desht.modularrouters.item.module.ExtruderModule2;
import me.desht.modularrouters.item.module.FlingerModule;
import me.desht.modularrouters.item.module.FluidModule;
import me.desht.modularrouters.item.module.Module;
import me.desht.modularrouters.item.module.PlacerModule;
import me.desht.modularrouters.item.module.PlayerModule;
import me.desht.modularrouters.item.module.PullerModule;
import me.desht.modularrouters.item.module.PullerModule2;
import me.desht.modularrouters.item.module.SenderModule1;
import me.desht.modularrouters.item.module.SenderModule2;
import me.desht.modularrouters.item.module.SenderModule3;
import me.desht.modularrouters.item.module.TargetedModule;
import me.desht.modularrouters.item.module.VacuumModule;
import me.desht.modularrouters.item.module.VoidModule;
import me.desht.modularrouters.util.InventoryUtils;
import me.desht.modularrouters.util.ModuleHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber
public class ItemModule
extends ItemSubTypes<ModuleType> {
    public ItemModule() {
        super("module", ModuleType.class);
        this.register(ModuleType.BREAKER, new BreakerModule());
        this.register(ModuleType.DROPPER, new DropperModule());
        this.register(ModuleType.PLACER, new PlacerModule());
        this.register(ModuleType.PULLER, new PullerModule());
        this.register(ModuleType.SENDER1, new SenderModule1());
        this.register(ModuleType.SENDER2, new SenderModule2());
        this.register(ModuleType.SENDER3, new SenderModule3());
        this.register(ModuleType.VACUUM, new VacuumModule());
        this.register(ModuleType.VOID, new VoidModule());
        this.register(ModuleType.DETECTOR, new DetectorModule());
        this.register(ModuleType.FLINGER, new FlingerModule());
        this.register(ModuleType.PLAYER, new PlayerModule());
        this.register(ModuleType.EXTRUDER, new ExtruderModule());
        this.register(ModuleType.FLUID, new FluidModule());
        this.register(ModuleType.PULLER2, new PullerModule2());
        this.register(ModuleType.EXTRUDER2, new ExtruderModule2());
        this.register(ModuleType.ACTIVATOR, new ActivatorModule());
        this.register(ModuleType.DISTRIBUTOR, new DistributorModule());
    }

    @SubscribeEvent
    public static void onPlayerInteract(PlayerInteractEvent.RightClickBlock event) {
        if (event.getSide() == Side.CLIENT) {
            Module mod = ItemModule.getModule(event.getItemStack());
            if (!(mod instanceof TargetedModule)) {
                return;
            }
            if (InventoryUtils.getInventory(event.getWorld(), event.getPos(), event.getFace()) != null) {
                return;
            }
            event.setCanceled(true);
        }
    }

    public static Module getModule(ItemStack stack) {
        if (!(stack.func_77973_b() instanceof ItemModule) || stack.func_77960_j() >= ModuleType.values().length) {
            return null;
        }
        return ItemModule.getModule(ModuleType.values()[stack.func_77960_j()]);
    }

    public static Module getModule(ModuleType type) {
        return (Module)RegistrarMR.MODULE.getHandler(type);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        ModuleHelper.validateNBT(stack);
        if (!player.func_70093_af()) {
            if (!world.field_72995_K) {
                int guiId = hand == EnumHand.MAIN_HAND ? ModularRouters.GUI_MODULE_HELD_MAIN : ModularRouters.GUI_MODULE_HELD_OFF;
                player.openGui((Object)ModularRouters.instance, guiId, player.func_130014_f_(), (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
            }
        } else {
            return ItemModule.getModule(stack).onSneakRightClick(stack, world, player, hand);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public boolean onEntitySwing(EntityLivingBase entityLiving, ItemStack stack) {
        return ItemModule.getModule(stack).onEntitySwing(entityLiving, stack);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing face, float x, float y, float z) {
        ItemStack stack = player.func_184586_b(hand);
        return ItemModule.getModule(stack).onItemUse(stack, player, world, pos, hand, face, x, y, z);
    }

    public boolean func_77636_d(ItemStack stack) {
        return ItemModule.getModule(stack).hasEffect(stack);
    }

    public static enum ModuleType {
        DROPPER,
        FLINGER,
        VACUUM,
        PLACER,
        BREAKER,
        SENDER1,
        SENDER2,
        SENDER3,
        PULLER,
        PULLER2,
        EXTRUDER,
        EXTRUDER2,
        DETECTOR,
        PLAYER,
        FLUID,
        VOID,
        ACTIVATOR,
        DISTRIBUTOR;


        public static ModuleType getType(ItemStack stack) {
            return stack.func_77973_b() instanceof ItemModule ? ModuleType.values()[stack.func_77952_i()] : null;
        }
    }
}

