/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.item.module;

import java.awt.Color;
import java.util.List;
import me.desht.modularrouters.block.tile.TileEntityItemRouter;
import me.desht.modularrouters.client.gui.module.GuiModule;
import me.desht.modularrouters.client.gui.module.GuiModuleVacuum;
import me.desht.modularrouters.config.ConfigHandler;
import me.desht.modularrouters.integration.XPCollection;
import me.desht.modularrouters.item.augment.ItemAugment;
import me.desht.modularrouters.item.module.IRangedModule;
import me.desht.modularrouters.item.module.Module;
import me.desht.modularrouters.logic.compiled.CompiledModule;
import me.desht.modularrouters.logic.compiled.CompiledVacuumModule;
import me.desht.modularrouters.util.MiscUtil;
import me.desht.modularrouters.util.ModNameCache;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fluids.UniversalBucket;

public class VacuumModule
extends Module
implements IRangedModule {
    @Override
    public CompiledModule compile(TileEntityItemRouter router, ItemStack stack) {
        return new CompiledVacuumModule(router, stack);
    }

    @Override
    public void addExtraInformation(ItemStack itemstack, World player, List<String> list, ITooltipFlag advanced) {
        super.addExtraInformation(itemstack, player, list, advanced);
        CompiledVacuumModule cvm = new CompiledVacuumModule(null, itemstack);
        if (cvm.getAugmentCount(ItemAugment.AugmentType.XP_VACUUM) > 0) {
            XPCollection.XPCollectionType type = cvm.getXPCollectionType();
            String modName = ModNameCache.getModName(type.getModId());
            String title = type.getIcon().func_77973_b() instanceof UniversalBucket ? MiscUtil.getFluidName(type.getIcon()) : type.getIcon().func_82833_r();
            list.add(TextFormatting.GREEN + I18n.func_135052_a((String)"guiText.label.xpVacuum", (Object[])new Object[0]) + ": " + TextFormatting.AQUA + title + TextFormatting.BLUE + TextFormatting.ITALIC + " (" + modName + ")");
            if (cvm.isAutoEjecting() && !type.isSolid()) {
                list.add(TextFormatting.GREEN + I18n.func_135052_a((String)"guiText.tooltip.xpVacuum.ejectFluid", (Object[])new Object[0]));
            }
        }
    }

    @Override
    public int getBaseRange() {
        return ConfigHandler.module.vacuumBaseRange;
    }

    @Override
    public int getHardMaxRange() {
        return ConfigHandler.module.vacuumMaxRange;
    }

    @Override
    public boolean isOmniDirectional() {
        return true;
    }

    @Override
    public Class<? extends GuiModule> getGuiHandler() {
        return GuiModuleVacuum.class;
    }

    @Override
    public Color getItemTint() {
        return new Color(120, 48, 191);
    }
}

