/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.item.smartfilter;

import java.util.List;
import me.desht.modularrouters.ModularRouters;
import me.desht.modularrouters.block.tile.TileEntityItemRouter;
import me.desht.modularrouters.client.gui.filter.GuiBulkItemFilter;
import me.desht.modularrouters.container.ContainerBulkItemFilter;
import me.desht.modularrouters.container.handler.BaseModuleHandler;
import me.desht.modularrouters.core.RegistrarMR;
import me.desht.modularrouters.item.smartfilter.SmartFilter;
import me.desht.modularrouters.logic.filter.Filter;
import me.desht.modularrouters.logic.filter.matchers.BulkItemMatcher;
import me.desht.modularrouters.logic.filter.matchers.IItemMatcher;
import me.desht.modularrouters.network.FilterSettingsMessage;
import me.desht.modularrouters.util.InventoryUtils;
import me.desht.modularrouters.util.SetofItemStack;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.IItemHandler;

public class BulkItemFilter
extends SmartFilter {
    public static final int FILTER_SIZE = 54;
    private static final String NBT_ITEMS_DEPRECATED = "Items";
    private static final Filter.Flags DEF_FLAGS = new Filter.Flags(0);

    @Override
    public IItemMatcher compile(ItemStack filterStack, ItemStack moduleStack) {
        Filter.Flags flags = moduleStack.func_190926_b() ? DEF_FLAGS : new Filter.Flags(moduleStack);
        SetofItemStack stacks = BulkItemFilter.getFilterItems(filterStack, flags);
        return new BulkItemMatcher(stacks, flags);
    }

    private static SetofItemStack getFilterItems(ItemStack filterStack, Filter.Flags flags) {
        if (filterStack.func_77942_o()) {
            BulkItemFilter.checkAndMigrateOldNBT(filterStack);
            BaseModuleHandler.BulkFilterHandler handler = new BaseModuleHandler.BulkFilterHandler(filterStack);
            return SetofItemStack.fromItemHandler((IItemHandler)handler, flags);
        }
        return new SetofItemStack(DEF_FLAGS);
    }

    @Override
    public void addExtraInformation(ItemStack itemstack, World player, List<String> list, ITooltipFlag advanced) {
        super.addExtraInformation(itemstack, player, list, advanced);
        list.add(I18n.func_135052_a((String)"itemText.misc.bulkItemFilter.count", (Object[])new Object[]{this.getSize(itemstack)}));
    }

    @Override
    public Class<? extends GuiScreen> getGuiHandler() {
        return GuiBulkItemFilter.class;
    }

    @Override
    public boolean hasGuiContainer() {
        return true;
    }

    @Override
    public Container createContainer(EntityPlayer player, ItemStack filterStack, EnumHand hand, TileEntityItemRouter router) {
        return new ContainerBulkItemFilter(player, filterStack, hand, router);
    }

    @Override
    public EnumActionResult onItemUse(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing face, float x, float y, float z) {
        if (world.field_72995_K) {
            return EnumActionResult.SUCCESS;
        }
        if (player.func_70093_af()) {
            IItemHandler handler = InventoryUtils.getInventory(world, pos, face);
            if (handler != null) {
                int nAdded = this.mergeInventory(stack, handler);
                player.func_146105_b((ITextComponent)new TextComponentTranslation("chatText.misc.inventoryMerged", new Object[]{nAdded, stack.func_82833_r()}), false);
                world.func_184133_a(null, pos, RegistrarMR.SOUND_SUCCESS, SoundCategory.MASTER, 1.0f, 1.0f);
                return EnumActionResult.SUCCESS;
            }
            return super.onItemUse(stack, player, world, pos, hand, face, x, y, z);
        }
        return EnumActionResult.PASS;
    }

    @Override
    public IMessage dispatchMessage(EntityPlayer player, FilterSettingsMessage message, ItemStack filterStack, ItemStack moduleStack) {
        ContainerBulkItemFilter con = player.field_71070_bA instanceof ContainerBulkItemFilter ? (ContainerBulkItemFilter)player.field_71070_bA : null;
        Filter.Flags flags = moduleStack.func_190926_b() ? DEF_FLAGS : new Filter.Flags(moduleStack);
        switch (message.getOp()) {
            case CLEAR_ALL: {
                if (con == null) break;
                con.clearSlots();
                break;
            }
            case MERGE: {
                if (con == null) break;
                con.mergeInventory(message.getTargetInventory(), flags, false);
                break;
            }
            case LOAD: {
                if (con == null) break;
                con.mergeInventory(message.getTargetInventory(), flags, true);
                break;
            }
            default: {
                ModularRouters.logger.warn("received unexpected message type " + (Object)((Object)message.getOp()) + " for " + filterStack);
            }
        }
        return null;
    }

    @Override
    public int getSize(ItemStack filterStack) {
        if (filterStack.func_77942_o()) {
            NBTTagCompound compound = filterStack.func_77978_p();
            if (compound.func_74764_b(NBT_ITEMS_DEPRECATED)) {
                return compound.func_150295_c(NBT_ITEMS_DEPRECATED, 10).func_74745_c();
            }
            return BaseModuleHandler.getFilterSize(filterStack, "ModuleFilter");
        }
        return 0;
    }

    private int mergeInventory(ItemStack filterStack, IItemHandler srcInventory) {
        SetofItemStack stacks = BulkItemFilter.getFilterItems(filterStack, DEF_FLAGS);
        int origSize = stacks.size();
        for (int i = 0; i < srcInventory.getSlots() && stacks.size() < 54; ++i) {
            ItemStack stack = srcInventory.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            ItemStack stack1 = stack.func_77946_l();
            stack1.func_190920_e(1);
            stacks.add(stack1);
        }
        BaseModuleHandler.BulkFilterHandler handler = new BaseModuleHandler.BulkFilterHandler(filterStack);
        int slot = 0;
        for (ItemStack stack : stacks.sortedList()) {
            handler.setStackInSlot(slot++, stack);
        }
        handler.save();
        return stacks.size() - origSize;
    }

    public static void checkAndMigrateOldNBT(ItemStack filterStack) {
        NBTTagCompound compound = filterStack.func_77978_p();
        if (compound != null && compound.func_74764_b(NBT_ITEMS_DEPRECATED)) {
            BaseModuleHandler.BulkFilterHandler handler = new BaseModuleHandler.BulkFilterHandler(filterStack);
            NBTTagList items = compound.func_150295_c(NBT_ITEMS_DEPRECATED, 10);
            for (int i = 0; i < items.func_74745_c(); ++i) {
                NBTTagCompound c = (NBTTagCompound)items.func_179238_g(i);
                ItemStack stack = new ItemStack(c);
                stack.func_190920_e(1);
                handler.setStackInSlot(i, stack);
            }
            handler.save();
            compound.func_82580_o(NBT_ITEMS_DEPRECATED);
        }
    }
}

