/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.item.upgrade;

import me.desht.modularrouters.core.RegistrarMR;
import me.desht.modularrouters.item.ItemSubTypes;
import me.desht.modularrouters.item.upgrade.BlastUpgrade;
import me.desht.modularrouters.item.upgrade.CamouflageUpgrade;
import me.desht.modularrouters.item.upgrade.FluidUpgrade;
import me.desht.modularrouters.item.upgrade.MufflerUpgrade;
import me.desht.modularrouters.item.upgrade.SecurityUpgrade;
import me.desht.modularrouters.item.upgrade.SpeedUpgrade;
import me.desht.modularrouters.item.upgrade.StackUpgrade;
import me.desht.modularrouters.item.upgrade.SyncUpgrade;
import me.desht.modularrouters.item.upgrade.Upgrade;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ItemUpgrade
extends ItemSubTypes<UpgradeType> {
    public ItemUpgrade() {
        super("upgrade", UpgradeType.class);
        this.register(UpgradeType.STACK, new StackUpgrade());
        this.register(UpgradeType.SPEED, new SpeedUpgrade());
        this.register(UpgradeType.SECURITY, new SecurityUpgrade());
        this.register(UpgradeType.CAMOUFLAGE, new CamouflageUpgrade());
        this.register(UpgradeType.SYNC, new SyncUpgrade());
        this.register(UpgradeType.FLUID, new FluidUpgrade());
        this.register(UpgradeType.MUFFLER, new MufflerUpgrade());
        this.register(UpgradeType.BLAST, new BlastUpgrade());
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        return ItemUpgrade.getUpgrade(stack).onItemRightClick(stack, worldIn, playerIn, handIn);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        return ItemUpgrade.getUpgrade(stack).onItemUse(stack, player, worldIn, pos, hand, facing, hitX, hitY, hitZ);
    }

    public static ItemStack makeItemStack(UpgradeType type) {
        return ItemUpgrade.makeItemStack(type, 1);
    }

    public static ItemStack makeItemStack(UpgradeType type, int amount) {
        return new ItemStack((Item)RegistrarMR.UPGRADE, amount, type.ordinal());
    }

    public static Upgrade getUpgrade(ItemStack stack) {
        if (!(stack.func_77973_b() instanceof ItemUpgrade)) {
            return null;
        }
        if (stack.func_77960_j() >= UpgradeType.values().length) {
            return null;
        }
        return ItemUpgrade.getUpgrade(UpgradeType.values()[stack.func_77960_j()]);
    }

    public static Upgrade getUpgrade(UpgradeType type) {
        return (Upgrade)RegistrarMR.UPGRADE.getHandler(type);
    }

    public static boolean isType(ItemStack stack, UpgradeType type) {
        return stack.func_77973_b() instanceof ItemUpgrade && stack.func_77952_i() == type.ordinal();
    }

    public static enum UpgradeType {
        STACK,
        SPEED,
        SECURITY,
        CAMOUFLAGE,
        SYNC,
        FLUID,
        MUFFLER,
        BLAST;


        public static UpgradeType getType(ItemStack stack) {
            return stack.func_77973_b() instanceof ItemUpgrade ? UpgradeType.values()[stack.func_77952_i()] : null;
        }
    }
}

