/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.item.upgrade;

import java.awt.Color;
import java.util.List;
import java.util.Random;
import me.desht.modularrouters.ModularRouters;
import me.desht.modularrouters.block.tile.TileEntityItemRouter;
import me.desht.modularrouters.config.ConfigHandler;
import me.desht.modularrouters.core.RegistrarMR;
import me.desht.modularrouters.item.upgrade.Upgrade;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;

public class SyncUpgrade
extends Upgrade {
    private static final String NBT_TUNING = "Tuning";

    @Override
    public void addExtraInformation(ItemStack itemstack, World player, List<String> list, ITooltipFlag advanced) {
        list.add(I18n.func_135052_a((String)"itemText.sync.tuning", (Object[])new Object[]{SyncUpgrade.getTunedValue(itemstack)}));
    }

    @Override
    public void onCompiled(ItemStack stack, TileEntityItemRouter router) {
        router.setTunedSyncValue(SyncUpgrade.getTunedValue(stack));
    }

    public static int getTunedValue(ItemStack stack) {
        NBTTagCompound compound = stack.func_77978_p();
        if (compound == null) {
            return 0;
        }
        return compound.func_74762_e(NBT_TUNING);
    }

    public static void setTunedValue(ItemStack stack, int newValue) {
        NBTTagCompound compound = stack.func_77978_p();
        if (compound == null) {
            compound = new NBTTagCompound();
            stack.func_77982_d(compound);
        }
        compound.func_74768_a(NBT_TUNING, newValue);
    }

    @Override
    public Color getItemTint() {
        return new Color(255, 255, 195);
    }

    @Override
    public ActionResult<ItemStack> onItemRightClick(ItemStack itemStackIn, World worldIn, EntityPlayer playerIn, EnumHand hand) {
        if (hand != EnumHand.MAIN_HAND) {
            return new ActionResult(EnumActionResult.PASS, (Object)itemStackIn);
        }
        if (worldIn.field_72995_K && !playerIn.func_70093_af()) {
            BlockPos pos = playerIn.func_180425_c();
            playerIn.openGui((Object)ModularRouters.instance, ModularRouters.GUI_SYNC_UPGRADE, worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        } else if (playerIn.func_70093_af()) {
            if (!worldIn.field_72995_K) {
                SyncUpgrade.setTunedValue(itemStackIn, new Random().nextInt(ConfigHandler.router.baseTickRate));
                playerIn.func_146105_b((ITextComponent)new TextComponentTranslation("itemText.sync.tuning", new Object[]{SyncUpgrade.getTunedValue(itemStackIn)}), false);
            } else {
                playerIn.func_184185_a(RegistrarMR.SOUND_SUCCESS, 1.0f, 1.5f);
            }
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)itemStackIn);
    }
}

