/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.logic.filter;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.Predicate;
import me.desht.modularrouters.item.module.ItemModule;
import me.desht.modularrouters.item.module.Module;
import me.desht.modularrouters.item.smartfilter.ItemSmartFilter;
import me.desht.modularrouters.item.smartfilter.SmartFilter;
import me.desht.modularrouters.logic.filter.matchers.FluidMatcher;
import me.desht.modularrouters.logic.filter.matchers.IItemMatcher;
import me.desht.modularrouters.util.ModuleHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fluids.Fluid;
import org.apache.commons.lang3.Validate;

public class Filter
implements Predicate<ItemStack> {
    public static final int FILTER_SIZE = 9;
    private final Flags flags;
    private final List<IItemMatcher> matchers = Lists.newArrayList();

    public Filter() {
        this.flags = Flags.DEFAULT_FLAGS;
    }

    public Filter(ItemStack moduleStack) {
        if (moduleStack.func_77973_b() instanceof ItemModule && moduleStack.func_77942_o()) {
            this.flags = new Flags(moduleStack);
            NBTTagList tagList = moduleStack.func_77978_p().func_150295_c("ModuleFilter", 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                NBTTagCompound tagCompound = tagList.func_150305_b(i);
                ItemStack filterStack = new ItemStack(tagCompound);
                IItemMatcher matcher = this.createMatcher(filterStack, moduleStack);
                if (matcher == null) continue;
                this.matchers.add(matcher);
            }
        } else {
            this.flags = Flags.DEFAULT_FLAGS;
        }
    }

    private IItemMatcher createMatcher(ItemStack filterStack, ItemStack moduleStack) {
        SmartFilter f = ItemSmartFilter.getFilter(filterStack);
        if (f != null) {
            return f.compile(filterStack, moduleStack);
        }
        Module module = ItemModule.getModule(moduleStack);
        return module == null ? null : module.getFilterItemMatcher(filterStack);
    }

    @Override
    public boolean test(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        for (IItemMatcher matcher : this.matchers) {
            if (!matcher.matchItem(stack, this.flags)) continue;
            return !this.flags.isBlacklist();
        }
        return this.flags.isBlacklist();
    }

    public boolean testFluid(Fluid fluid) {
        for (IItemMatcher matcher : this.matchers) {
            if (!(matcher instanceof FluidMatcher) || !((FluidMatcher)matcher).matchFluid(fluid)) continue;
            return !this.flags.isBlacklist();
        }
        return this.flags.isBlacklist();
    }

    public Flags getFlags() {
        return this.flags;
    }

    public static class Flags {
        static final Flags DEFAULT_FLAGS = new Flags();
        private final boolean blacklist;
        private final boolean ignoreMeta;
        private final boolean ignoreNBT;
        private final boolean ignoreOredict;

        public Flags(ItemStack moduleStack) {
            Validate.isTrue((boolean)(moduleStack.func_77973_b() instanceof ItemModule));
            this.blacklist = ModuleHelper.isBlacklist(moduleStack);
            this.ignoreMeta = ModuleHelper.ignoreMeta(moduleStack);
            this.ignoreNBT = ModuleHelper.ignoreNBT(moduleStack);
            this.ignoreOredict = ModuleHelper.ignoreOreDict(moduleStack);
        }

        public Flags() {
            this.blacklist = Module.ModuleFlags.BLACKLIST.getDefaultValue();
            this.ignoreMeta = Module.ModuleFlags.IGNORE_META.getDefaultValue();
            this.ignoreNBT = Module.ModuleFlags.IGNORE_NBT.getDefaultValue();
            this.ignoreOredict = Module.ModuleFlags.IGNORE_OREDICT.getDefaultValue();
        }

        public Flags(byte mask) {
            this.blacklist = (mask & Module.ModuleFlags.BLACKLIST.getMask()) != 0;
            this.ignoreMeta = (mask & Module.ModuleFlags.IGNORE_META.getMask()) != 0;
            this.ignoreNBT = (mask & Module.ModuleFlags.IGNORE_NBT.getMask()) != 0;
            this.ignoreOredict = (mask & Module.ModuleFlags.IGNORE_OREDICT.getMask()) != 0;
        }

        public boolean isBlacklist() {
            return this.blacklist;
        }

        public boolean isIgnoreMeta() {
            return this.ignoreMeta;
        }

        public boolean isIgnoreNBT() {
            return this.ignoreNBT;
        }

        public boolean isIgnoreOredict() {
            return this.ignoreOredict;
        }

        public static Flags with(Module.ModuleFlags ... flags) {
            byte mask = 0;
            for (Module.ModuleFlags flag : flags) {
                mask = (byte)(mask | flag.getMask());
            }
            return new Flags(mask);
        }
    }
}

