/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.logic.filter.matchers;

import com.google.common.collect.Sets;
import gnu.trove.iterator.hash.TObjectHashIterator;
import java.util.Set;
import me.desht.modularrouters.logic.filter.Filter;
import me.desht.modularrouters.logic.filter.matchers.IItemMatcher;
import me.desht.modularrouters.util.SetofItemStack;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class BulkItemMatcher
implements IItemMatcher {
    private final SetofItemStack stacks;
    private final Set<Integer> oreDictIds;

    public BulkItemMatcher(SetofItemStack stacks, Filter.Flags flags) {
        this.stacks = stacks;
        this.oreDictIds = Sets.newHashSet();
        if (!flags.isIgnoreOredict()) {
            TObjectHashIterator tObjectHashIterator = stacks.iterator();
            while (tObjectHashIterator.hasNext()) {
                ItemStack stack = (ItemStack)tObjectHashIterator.next();
                for (int id : OreDictionary.getOreIDs((ItemStack)stack)) {
                    this.oreDictIds.add(id);
                }
            }
        }
    }

    @Override
    public boolean matchItem(ItemStack stack, Filter.Flags flags) {
        if (this.stacks.contains(stack)) {
            return true;
        }
        return !flags.isIgnoreOredict() && this.matchOreDict(stack);
    }

    private boolean matchOreDict(ItemStack stack) {
        for (int id : OreDictionary.getOreIDs((ItemStack)stack)) {
            if (!this.oreDictIds.contains(id)) continue;
            return true;
        }
        return false;
    }
}

