/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.network;

import io.netty.buffer.ByteBuf;
import me.desht.modularrouters.ModularRouters;
import me.desht.modularrouters.block.tile.TileEntityItemRouter;
import me.desht.modularrouters.container.handler.BaseModuleHandler;
import me.desht.modularrouters.item.module.ItemModule;
import me.desht.modularrouters.item.smartfilter.ItemSmartFilter;
import me.desht.modularrouters.item.smartfilter.SmartFilter;
import me.desht.modularrouters.logic.ModuleTarget;
import me.desht.modularrouters.network.BaseSettingsMessage;
import me.desht.modularrouters.util.InventoryUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.items.IItemHandler;

public class FilterSettingsMessage
extends BaseSettingsMessage {
    private int filterIndex;
    private Operation op;

    public FilterSettingsMessage() {
    }

    public FilterSettingsMessage(Operation op, EnumHand hand, int filterIndex, NBTTagCompound ext) {
        this(op, null, -1, filterIndex, hand, ext);
    }

    public FilterSettingsMessage(Operation op, BlockPos routerPos, int moduleIndex, int filterIndex, NBTTagCompound ext) {
        this(op, routerPos, moduleIndex, filterIndex, null, ext);
    }

    private FilterSettingsMessage(Operation op, BlockPos routerPos, int moduleIndex, int filterIndex, EnumHand hand, NBTTagCompound ext) {
        super(routerPos, hand, moduleIndex, ext);
        this.op = op;
        this.filterIndex = filterIndex;
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.op = Operation.values()[buf.readByte()];
        this.filterIndex = buf.readByte();
    }

    @Override
    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeByte(this.op.ordinal());
        buf.writeByte(this.filterIndex);
    }

    public Operation getOp() {
        return this.op;
    }

    public IItemHandler getTargetInventory() {
        ModuleTarget target = ModuleTarget.fromNBT(this.getNbtData());
        WorldServer w = DimensionManager.getWorld((int)target.dimId);
        if (w != null) {
            return InventoryUtils.getInventory((World)w, target.pos, target.face);
        }
        return null;
    }

    public static class Handler
    implements IMessageHandler<FilterSettingsMessage, IMessage> {
        public IMessage onMessage(FilterSettingsMessage message, MessageContext ctx) {
            WorldServer mainThread = (WorldServer)ctx.getServerHandler().field_147369_b.func_130014_f_();
            mainThread.func_152344_a(() -> {
                EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
                ItemStack filterStack = ItemStack.field_190927_a;
                ItemStack moduleStack = ItemStack.field_190927_a;
                BaseModuleHandler.ModuleFilterHandler filterHandler = null;
                if (message.routerPos != null) {
                    TileEntityItemRouter router = TileEntityItemRouter.getRouterAt((IBlockAccess)player.func_130014_f_(), message.routerPos);
                    if (router != null) {
                        moduleStack = router.getModules().getStackInSlot(message.moduleSlotIndex);
                        filterHandler = new BaseModuleHandler.ModuleFilterHandler(moduleStack);
                        filterStack = filterHandler.getStackInSlot(message.filterIndex);
                        router.recompileNeeded(1);
                    }
                } else if (message.hand != null) {
                    ItemStack heldStack = player.func_184586_b(message.hand);
                    if (ItemModule.getModule(heldStack) != null) {
                        moduleStack = heldStack;
                        filterHandler = new BaseModuleHandler.ModuleFilterHandler(moduleStack);
                        filterStack = filterHandler.getStackInSlot(message.filterIndex);
                    } else if (ItemSmartFilter.getFilter(heldStack) != null) {
                        filterStack = heldStack;
                    }
                }
                SmartFilter sf = ItemSmartFilter.getFilter(filterStack);
                if (sf != null) {
                    IMessage response = sf.dispatchMessage((EntityPlayer)player, message, filterStack, moduleStack);
                    if (filterHandler != null) {
                        filterHandler.setStackInSlot(message.filterIndex, filterStack);
                        filterHandler.save();
                        if (message.hand != null) {
                            player.func_184611_a(message.hand, filterHandler.getHolderStack());
                        }
                    }
                    if (response != null) {
                        NetworkRegistry.TargetPoint tp = new NetworkRegistry.TargetPoint(player.field_71093_bK, player.field_70165_t, player.field_70163_u, player.field_70161_v, 8.0);
                        ModularRouters.network.sendToAllAround(response, tp);
                    }
                }
            });
            return null;
        }
    }

    public static enum Operation {
        CLEAR_ALL,
        REMOVE_ITEM,
        MERGE,
        LOAD,
        ADD_STRING,
        REMOVE_AT,
        ANY_ALL_FLAG;

    }
}

