/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.network;

import io.netty.buffer.ByteBuf;
import me.desht.modularrouters.ModularRouters;
import me.desht.modularrouters.block.tile.TileEntityItemRouter;
import me.desht.modularrouters.item.module.ItemModule;
import me.desht.modularrouters.network.BaseSettingsMessage;
import me.desht.modularrouters.util.ModuleHelper;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class ModuleSettingsMessage
extends BaseSettingsMessage {
    public ModuleSettingsMessage() {
    }

    public ModuleSettingsMessage(BlockPos routerPos, int moduleSlotIndex, EnumHand hand, NBTTagCompound data) {
        super(routerPos, hand, moduleSlotIndex, data);
    }

    @Override
    public void fromBytes(ByteBuf byteBuf) {
        super.fromBytes(byteBuf);
    }

    @Override
    public void toBytes(ByteBuf byteBuf) {
        super.toBytes(byteBuf);
    }

    public static class Handler
    implements IMessageHandler<ModuleSettingsMessage, IMessage> {
        public IMessage onMessage(ModuleSettingsMessage msg, MessageContext ctx) {
            WorldServer mainThread = (WorldServer)ctx.getServerHandler().field_147369_b.func_130014_f_();
            mainThread.func_152344_a(() -> {
                EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
                ItemStack moduleStack = ItemStack.field_190927_a;
                if (msg.routerPos != null) {
                    TileEntityItemRouter router = TileEntityItemRouter.getRouterAt((IBlockAccess)player.func_130014_f_(), msg.routerPos);
                    if (router != null) {
                        moduleStack = router.getModules().getStackInSlot(msg.moduleSlotIndex);
                        router.recompileNeeded(1);
                    }
                } else if (msg.hand != null) {
                    moduleStack = player.func_184586_b(msg.hand);
                }
                if (ItemModule.getModule(moduleStack) != null) {
                    NBTTagCompound compound = ModuleHelper.validateNBT(moduleStack);
                    for (String key : msg.nbtData.func_150296_c()) {
                        compound.func_74782_a(key, msg.nbtData.func_74781_a(key));
                    }
                } else {
                    ModularRouters.logger.warn("ignoring ModuleSettingsMessage for " + player.func_145748_c_() + " - expected module not found");
                }
            });
            return null;
        }
    }
}

