/*
 * Decompiled with CFR 0.152.
 */
package teamroots.emberroot.entity.cat;

import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL14;
import teamroots.emberroot.config.ConfigManager;
import teamroots.emberroot.entity.cat.EntityWitherCat;
import teamroots.emberroot.entity.cat.ModelWitherCat;
import teamroots.emberroot.util.RenderUtil;

public class RenderWitherCat
extends RenderLiving<EntityWitherCat> {
    public static final Factory FACTORY = new Factory();
    private ResourceLocation texture = new ResourceLocation("emberroot", "textures/entity/wither_cat.png");
    private ResourceLocation angryTexture = new ResourceLocation("emberroot", "textures/entity/wither_cat_angry.png");

    public RenderWitherCat(RenderManager rm) {
        super(rm, (ModelBase)new ModelWitherCat(), 0.4f);
        this.func_177094_a(new AngryLayer());
    }

    protected ResourceLocation getEntityTexture(EntityWitherCat p_110775_1_) {
        return this.texture;
    }

    public void doRender(EntityWitherCat entity, double x, double y, double z, float p_76986_8_, float p_76986_9_) {
        super.func_76986_a((EntityLiving)entity, x, y, z, p_76986_8_, p_76986_9_);
        GL11.glDisable((int)32823);
        if (ConfigManager.renderDebugHitboxes) {
            RenderUtil.renderEntityBoundingBox((EntityLiving)entity, x, y, z);
        }
    }

    protected void preRenderCallback(EntityWitherCat entity, float partialTick) {
        EntityWitherCat cat = entity;
        float scale = cat.getScale();
        if (scale > 1.0f) {
            if (cat.getGrowthMode() == EntityWitherCat.GrowthMode.SHRINK) {
                partialTick *= -1.0f;
            }
            scale = Math.min(cat.getAngryScale(), scale + cat.getScaleInc() * partialTick);
            float widthFactor = 1.0f - (cat.getAngryScale() - scale);
            GL11.glScalef((float)(scale + 0.25f * widthFactor), (float)scale, (float)(scale - 0.1f * widthFactor));
        }
    }

    public static class Factory
    implements IRenderFactory<EntityWitherCat> {
        public Render<? super EntityWitherCat> createRenderFor(RenderManager manager) {
            return new RenderWitherCat(manager);
        }
    }

    private class AngryLayer
    implements LayerRenderer<EntityWitherCat> {
        private AngryLayer() {
        }

        public void doRenderLayer(EntityWitherCat cat, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float iScale) {
            float blendFactor = 1.0f;
            float scale = cat.getScale();
            blendFactor = 1.0f - (cat.getAngryScale() - scale);
            if (blendFactor > 0.0f) {
                RenderWitherCat.this.func_110776_a(RenderWitherCat.this.angryTexture);
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)32771, (int)32772);
                GL14.glBlendColor((float)1.0f, (float)1.0f, (float)1.0f, (float)blendFactor);
                GL11.glEnable((int)32823);
                GL11.glPolygonOffset((float)-1.0f, (float)-1.0f);
                int c0 = 61680;
                int j = c0 % 65536;
                int k = c0 / 65536;
                OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)((float)j / 1.0f), (float)((float)k / 1.0f));
                GL11.glEnable((int)2896);
                RenderWitherCat.this.func_177087_b().func_78088_a((Entity)cat, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, iScale);
                RenderWitherCat.this.func_177105_a((EntityLiving)cat);
            }
        }

        public boolean func_177142_b() {
            return false;
        }
    }
}

