/*
 * Decompiled with CFR 0.152.
 */
package teamroots.emberroot.entity.owl;

import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.pathfinding.NodeProcessor;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathFinder;
import net.minecraft.pathfinding.PathHeap;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import teamroots.emberroot.util.PPUtil;
import teamroots.emberroot.util.SpawnUtil;

public class FlyingPathFinder
extends PathFinder {
    private PathHeap path = new PathHeap();
    private PathPoint[] pathOptions = new PathPoint[32];
    private NodeProcessor nodeProcessor;

    public FlyingPathFinder(NodeProcessor nodeProcessorIn) {
        super(nodeProcessorIn);
        this.nodeProcessor = nodeProcessorIn;
    }

    public Path func_186333_a(IBlockAccess blockaccess, EntityLiving entityFrom, Entity entityTo, float dist) {
        return this.createEntityPathTo(blockaccess, (Entity)entityFrom, entityTo.field_70165_t, entityTo.func_174813_aQ().field_72338_b, entityTo.field_70161_v, dist);
    }

    public Path func_186336_a(IBlockAccess blockaccess, EntityLiving entityIn, BlockPos targetPos, float dist) {
        return this.createEntityPathTo(blockaccess, (Entity)entityIn, (float)targetPos.func_177958_n() + 0.5f, (float)targetPos.func_177956_o() + 0.5f, (float)targetPos.func_177952_p() + 0.5f, dist);
    }

    private Path createEntityPathTo(IBlockAccess blockaccess, Entity ent, double x, double y, double z, float distance) {
        this.path.func_75848_a();
        if (!(ent instanceof EntityLiving)) {
            return null;
        }
        EntityLiving entityIn = (EntityLiving)ent;
        this.nodeProcessor.func_186315_a(blockaccess, entityIn);
        PathPoint startPoint = this.nodeProcessor.func_186318_b();
        PathPoint endPoint = this.nodeProcessor.func_186325_a(x, y, z);
        Vec3d targ = new Vec3d(x, y, z);
        Vec3d ePos = entityIn.func_174791_d();
        double yDelta = targ.field_72448_b - ePos.field_72448_b;
        double horizDist = new Vec3d(x, 0.0, z).func_72438_d(new Vec3d(ePos.field_72450_a, 0.0, ePos.field_72449_c));
        int climbY = 0;
        if (horizDist > 4.0 && entityIn.field_70122_E) {
            climbY = 1 * MathHelper.func_76125_a((int)((int)(horizDist / 8.0)), (int)1, (int)3);
            climbY = yDelta >= 1.0 ? (int)((double)climbY + yDelta) : ++climbY;
        }
        if (climbY == 0) {
            return this.createDefault(blockaccess, entityIn, distance, x, y, z);
        }
        ArrayList<PathPoint> resPoints = new ArrayList<PathPoint>();
        double climbDistance = Math.min(horizDist / 2.0, (double)climbY);
        Vec3d horizDirVec = new Vec3d(targ.field_72450_a, 0.0, targ.field_72449_c);
        horizDirVec = horizDirVec.func_178788_d(new Vec3d(ePos.field_72450_a, 0.0, ePos.field_72449_c));
        horizDirVec = horizDirVec.func_72432_b();
        Vec3d offset = new Vec3d(horizDirVec.field_72450_a * climbDistance, (double)climbY, horizDirVec.field_72449_c * climbDistance);
        PathPoint climbPoint = new PathPoint(this.rnd((double)startPoint.field_75839_a + offset.field_72450_a), this.rnd((double)startPoint.field_75837_b + offset.field_72448_b), this.rnd((double)startPoint.field_75838_c + offset.field_72449_c));
        if (!SpawnUtil.isSpaceAvailableForSpawn(entityIn.field_70170_p, entityIn, false)) {
            return this.createDefault(blockaccess, entityIn, distance, x, y, z);
        }
        PathPoint[] points = this.addToPath((Entity)entityIn, startPoint, climbPoint, distance);
        this.nodeProcessor.func_176163_a();
        if (points == null) {
            return this.createDefault(blockaccess, entityIn, distance, x, y, z);
        }
        resPoints.addAll(Arrays.asList(points));
        this.path.func_75848_a();
        this.nodeProcessor.func_186315_a(blockaccess, entityIn);
        climbPoint = new PathPoint(climbPoint.field_75839_a, climbPoint.field_75837_b, climbPoint.field_75838_c);
        points = this.addToPath((Entity)entityIn, climbPoint, endPoint, distance);
        this.nodeProcessor.func_176163_a();
        if (points == null) {
            return this.createDefault(blockaccess, entityIn, distance, x, y, z);
        }
        resPoints.addAll(Arrays.asList(points));
        if (resPoints.isEmpty()) {
            return null;
        }
        return new Path(resPoints.toArray(new PathPoint[resPoints.size()]));
    }

    private PathPoint[] addToPath(Entity entityIn, PathPoint pathpointStart, PathPoint pathpointEnd, float maxDistance) {
        PPUtil.setTotalPathDistance(pathpointStart, 0.0f);
        float dist = pathpointStart.func_75832_b(pathpointEnd);
        PPUtil.setDistanceToNext(pathpointStart, dist);
        PPUtil.setDistanceToTarget(pathpointStart, dist);
        PPUtil.setIndex(pathpointStart, -1);
        this.path.func_75848_a();
        this.path.func_75849_a(pathpointStart);
        PathPoint curPoint = pathpointStart;
        while (!this.path.func_75845_e()) {
            PathPoint dequeued = this.path.func_75844_c();
            if (dequeued.equals((Object)pathpointEnd)) {
                return FlyingPathFinder.createEntityPath(pathpointStart, pathpointEnd);
            }
            if (dequeued.func_75832_b(pathpointEnd) < curPoint.func_75832_b(pathpointEnd)) {
                curPoint = dequeued;
            }
            dequeued.field_75842_i = true;
            int numPathOptions = this.nodeProcessor.func_186320_a(this.pathOptions, dequeued, pathpointEnd, maxDistance);
            for (int j = 0; j < numPathOptions; ++j) {
                PathPoint cadidatePoint = this.pathOptions[j];
                float newTotalDistance = PPUtil.getTotalPathDistance(dequeued) + dequeued.func_75832_b(cadidatePoint);
                if (!(newTotalDistance < maxDistance * 2.0f) || cadidatePoint.func_75831_a() && !(newTotalDistance < PPUtil.getTotalPathDistance(cadidatePoint))) continue;
                PPUtil.setPrevious(cadidatePoint, dequeued);
                PPUtil.setTotalPathDistance(cadidatePoint, newTotalDistance);
                PPUtil.setDistanceToNext(cadidatePoint, cadidatePoint.func_75832_b(pathpointEnd));
                if (cadidatePoint.func_75831_a()) {
                    this.path.func_75850_a(cadidatePoint, PPUtil.getTotalPathDistance(cadidatePoint) + PPUtil.getDistanceToNext(cadidatePoint));
                    continue;
                }
                PPUtil.setDistanceToTarget(cadidatePoint, PPUtil.getTotalPathDistance(cadidatePoint) + PPUtil.getDistanceToNext(cadidatePoint));
                this.path.func_75849_a(cadidatePoint);
            }
        }
        if (curPoint == pathpointStart) {
            return null;
        }
        return FlyingPathFinder.createEntityPath(pathpointStart, curPoint);
    }

    private int rnd(double d) {
        return (int)Math.round(d);
    }

    private Path createDefault(IBlockAccess blockaccess, EntityLiving entityIn, float distance, double x, double y, double z) {
        this.path.func_75848_a();
        this.nodeProcessor.func_186315_a(blockaccess, entityIn);
        PathPoint pathpoint = this.nodeProcessor.func_186318_b();
        PathPoint pathpoint1 = this.nodeProcessor.func_186325_a(x, y, z);
        PathPoint[] p = this.addToPath((Entity)entityIn, pathpoint, pathpoint1, distance);
        Path res = p == null ? null : new Path(p);
        this.nodeProcessor.func_176163_a();
        return res;
    }

    private static PathPoint[] createEntityPath(PathPoint start, PathPoint end) {
        int i = 1;
        PathPoint pathpoint = end;
        while (PPUtil.getPrevious(pathpoint) != null) {
            ++i;
            pathpoint = PPUtil.getPrevious(pathpoint);
        }
        PathPoint[] apathpoint = new PathPoint[i];
        PathPoint pathpoint1 = end;
        apathpoint[--i] = end;
        while (PPUtil.getPrevious(pathpoint1) != null) {
            pathpoint1 = PPUtil.getPrevious(pathpoint1);
            apathpoint[--i] = pathpoint1;
        }
        return apathpoint;
    }
}

