/*
 * Decompiled with CFR 0.152.
 */
package teamroots.emberroot.entity.wolfdire;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILeapAtTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import teamroots.emberroot.config.ConfigSpawnEntity;
import teamroots.emberroot.entity.ai.EntityAIAttackOnCollideAggressive;
import teamroots.emberroot.entity.ai.EntityAINearestAttackableTargetBounded;
import teamroots.emberroot.util.EntityUtil;

public class EntityDireWolf
extends EntityMob {
    private static final double ATTACK_SPEED = 0.8;
    public static final String NAME = "dire_wolf";
    public static SoundEvent SND_HURT;
    public static SoundEvent SND_HOWL;
    public static SoundEvent SND_GROWL;
    public static SoundEvent SND_DEATH;
    public static final DataParameter<Integer> variant;
    private static final DataParameter<Boolean> ANGRY_INDEX;
    private static final int direWolfAggresiveRange = 8;
    private static final int direWolfPackHowlAmount = 3;
    private EntityLivingBase previsousAttackTarget;
    private float direWolfHowlChance = 0.1f;
    public static boolean direWolfPackAttackEnabled;
    private int maxSpawnedInChunk = 6;
    private static int packHowl;
    private static long lastHowl;
    public static ConfigSpawnEntity config;

    public EntityDireWolf(World world) {
        super(world);
        this.func_70105_a(0.8f, 1.2f);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAILeapAtTarget((EntityLiving)this, 0.1f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIAttackOnCollideAggressive((EntityCreature)this, 0.8, true).setAttackFrequency(60));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.5));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        EntityAINearestAttackableTargetBounded<EntityPlayer> nearTarg = new EntityAINearestAttackableTargetBounded<EntityPlayer>((EntityCreature)this, EntityPlayer.class, true);
        nearTarg.setMaxDistanceToTarget(8.0);
        this.field_70715_bh.func_75776_a(6, nearTarg);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ANGRY_INDEX, (Object)Boolean.FALSE);
        this.updateAngry();
        this.func_184212_Q().func_187214_a(variant, (Object)this.field_70146_Z.nextInt(VariantColors.values().length));
    }

    public Integer getVariant() {
        return (Integer)this.func_184212_Q().func_187225_a(variant);
    }

    public VariantColors getVariantEnum() {
        return VariantColors.values()[this.getVariant()];
    }

    public boolean isAngry() {
        return (Boolean)this.field_70180_af.func_187225_a(ANGRY_INDEX);
    }

    protected boolean func_70814_o() {
        return true;
    }

    public int func_70641_bl() {
        return this.maxSpawnedInChunk;
    }

    private void updateAngry() {
        this.field_70180_af.func_187227_b(ANGRY_INDEX, (Object)(this.func_70638_az() != null ? Boolean.TRUE : Boolean.FALSE));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        ConfigSpawnEntity.syncInstance((EntityLivingBase)this, EntityDireWolf.config.settings);
    }

    protected void func_180429_a(BlockPos bp, Block block) {
        this.func_184185_a(SoundEvents.field_187869_gK, 0.15f, 1.0f);
    }

    protected SoundEvent func_184639_G() {
        boolean howl;
        if (this.isAngry()) {
            return SND_GROWL;
        }
        if (EntityUtil.isPlayerWithinRange((Entity)this, 12.0)) {
            return SND_GROWL;
        }
        boolean bl = howl = (packHowl > 0 || this.field_70146_Z.nextFloat() <= this.direWolfHowlChance) && this.field_70170_p.func_82737_E() > lastHowl + 10L;
        if (howl) {
            if (packHowl <= 0 && (double)this.field_70146_Z.nextFloat() <= 0.6) {
                packHowl = 3;
            }
            lastHowl = this.field_70170_p.func_82737_E();
            packHowl = Math.max(packHowl - 1, 0);
            return SND_HOWL;
        }
        return SND_GROWL;
    }

    public void func_184185_a(SoundEvent sound, float volume, float pitch) {
        if (SND_HOWL.equals(sound)) {
            pitch *= 0.8f;
        }
        this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, sound, SoundCategory.NEUTRAL, volume, pitch, true);
    }

    protected SoundEvent func_184601_bQ(DamageSource s) {
        return SND_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return SND_DEATH;
    }

    public float func_70047_e() {
        return this.field_70131_O * 0.8f;
    }

    protected float func_70599_aP() {
        return 0.4f;
    }

    protected ResourceLocation func_184647_J() {
        return new ResourceLocation("emberroot", "entity/wolf_dire");
    }

    public float getTailRotation() {
        if (this.isAngry()) {
            return 1.5707964f;
        }
        return 0.7853982f;
    }

    public void func_70107_b(double x, double y, double z) {
        this.field_70165_t = x;
        this.field_70163_u = y;
        this.field_70161_v = z;
        double hw = this.field_70130_N / 2.0f;
        double hd = hw * 2.25;
        float f1 = this.field_70131_O;
        this.func_174826_a(new AxisAlignedBB(x - hw, y, z - hd, x + hw, y + (double)f1, z + hd));
    }

    public void func_70636_d() {
        super.func_70636_d();
        EntityLivingBase curTarget = this.func_70638_az();
        if (curTarget != this.previsousAttackTarget) {
            if (curTarget != null) {
                this.doGroupArgo(curTarget);
            }
            this.previsousAttackTarget = this.func_70638_az();
            this.updateAngry();
        }
    }

    private void doGroupArgo(EntityLivingBase curTarget) {
        if (!direWolfPackAttackEnabled) {
            return;
        }
        int range = 16;
        AxisAlignedBB bb = new AxisAlignedBB(this.field_70165_t - (double)range, this.field_70163_u - (double)range, this.field_70161_v - (double)range, this.field_70165_t + (double)range, this.field_70163_u + (double)range, this.field_70161_v + (double)range);
        List pack = this.field_70170_p.func_72872_a(EntityDireWolf.class, bb);
        if (pack != null && !pack.isEmpty()) {
            for (EntityDireWolf wolf : pack) {
                if (wolf.func_70638_az() != null) continue;
                EntityUtil.cancelCurrentTasks((EntityLiving)wolf);
                wolf.func_70624_b(curTarget);
            }
        }
    }

    static {
        variant = EntityDataManager.func_187226_a(EntityDireWolf.class, (DataSerializer)DataSerializers.field_187192_b);
        ANGRY_INDEX = EntityDataManager.func_187226_a(EntityDireWolf.class, (DataSerializer)DataSerializers.field_187198_h);
        direWolfPackAttackEnabled = true;
        packHowl = 0;
        lastHowl = 0L;
        config = new ConfigSpawnEntity(EntityDireWolf.class, EnumCreatureType.MONSTER);
    }

    public static enum VariantColors {
        WHITE,
        GREY,
        BLACK;


        public String nameLower() {
            return this.name().toLowerCase();
        }
    }
}

