/*
 * Decompiled with CFR 0.152.
 */
package tv.darkosto.sevpatches.core.patches;

import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;
import tv.darkosto.sevpatches.core.SevPatchesLoadingPlugin;

public abstract class Patch {
    ClassNode classNode;
    byte[] inputClassBytes;

    public Patch(byte[] inputClass) {
        this.inputClassBytes = inputClass;
        ClassReader classReader = new ClassReader(inputClass);
        this.classNode = new ClassNode();
        classReader.accept((ClassVisitor)this.classNode, 0);
    }

    public byte[] apply() {
        if (this.patch()) {
            SevPatchesLoadingPlugin.LOGGER.info("{} succeeded", (Object)this.getClass().getSimpleName());
            return this.writeClass();
        }
        SevPatchesLoadingPlugin.LOGGER.error("{} failed", (Object)this.getClass().getSimpleName());
        return this.inputClassBytes;
    }

    protected byte[] writeClass() {
        ClassWriter classWriter = new ClassWriter(3);
        this.classNode.accept((ClassVisitor)classWriter);
        return classWriter.toByteArray();
    }

    protected abstract boolean patch();
}

