/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.beneath.common.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import net.minecraftforge.fml.common.FMLLog;
import org.apache.logging.log4j.Level;

public class JsonHelper {
    public static JsonArray GetArray(JsonObject json, String id) {
        if (json == null) {
            return new JsonArray();
        }
        if (json.has(id) && json.get(id).isJsonArray()) {
            return json.get(id).getAsJsonArray();
        }
        JsonArray array = new JsonArray();
        json.add(id, (JsonElement)array);
        return array;
    }

    public static JsonObject GetObject(JsonObject json, String id) {
        if (json == null) {
            return new JsonObject();
        }
        if (json.has(id) && json.get(id).isJsonObject()) {
            return json.get(id).getAsJsonObject();
        }
        JsonObject obj = new JsonObject();
        json.add(id, (JsonElement)obj);
        return obj;
    }

    public static String GetString(JsonObject json, String id, String def) {
        if (json == null) {
            return def;
        }
        if (json.has(id) && json.get(id).isJsonPrimitive() && json.get(id).getAsJsonPrimitive().isString()) {
            return json.get(id).getAsString();
        }
        JsonPrimitive prim = new JsonPrimitive(def);
        json.add(id, (JsonElement)prim);
        return def;
    }

    public static Number GetNumber(JsonObject json, String id, Number def) {
        if (json == null) {
            return def;
        }
        if (json.has(id) && json.get(id).isJsonPrimitive() && json.get(id).getAsJsonPrimitive().isNumber()) {
            return json.get(id).getAsInt();
        }
        JsonPrimitive prim = new JsonPrimitive(def);
        json.add(id, (JsonElement)prim);
        return def;
    }

    public static boolean GetBoolean(JsonObject json, String id, boolean def) {
        if (json == null) {
            return def;
        }
        if (json.has(id) && json.get(id).isJsonPrimitive()) {
            try {
                return json.get(id).getAsBoolean();
            }
            catch (Exception e) {
                JsonPrimitive prim = new JsonPrimitive(Boolean.valueOf(def));
                json.add(id, (JsonElement)prim);
                return def;
            }
        }
        JsonPrimitive prim = new JsonPrimitive(Boolean.valueOf(def));
        json.add(id, (JsonElement)prim);
        return def;
    }

    public static JsonObject ReadObjectFromFile(File file) {
        if (!file.exists()) {
            return new JsonObject();
        }
        try {
            FileReader fr = new FileReader(file);
            JsonObject json = (JsonObject)new Gson().fromJson((Reader)fr, JsonObject.class);
            fr.close();
            return json;
        }
        catch (Exception e) {
            FMLLog.log((String)"The Beneath", (Level)Level.ERROR, (String)"An error occured while loading JSON from file:", (Object[])new Object[]{e});
            return new JsonObject();
        }
    }

    public static JsonArray ReadArrayFromFile(File file) {
        if (!file.exists()) {
            return new JsonArray();
        }
        try {
            FileReader fr = new FileReader(file);
            JsonArray json = (JsonArray)new Gson().fromJson((Reader)fr, JsonArray.class);
            fr.close();
            return json;
        }
        catch (Exception e) {
            FMLLog.log((String)"The Beneath", (Level)Level.ERROR, (String)"An error occured while loading JSON from file:", (Object[])new Object[]{e});
            return new JsonArray();
        }
    }

    public static void WriteToFile(File file, JsonElement json) {
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            FileWriter fw = new FileWriter(file);
            new GsonBuilder().setPrettyPrinting().create().toJson(json, (Appendable)fw);
            fw.close();
        }
        catch (Exception e) {
            FMLLog.log((String)"The Beneath", (Level)Level.ERROR, (String)"An error occured while saving JSON to file:", (Object[])new Object[]{e});
            return;
        }
    }
}

