/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.incense;

import WayofTime.bloodmagic.incense.IncenseAltarComponent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class IncenseAltarHandler {
    public static Map<Integer, List<IncenseAltarComponent>> incenseComponentMap = new TreeMap<Integer, List<IncenseAltarComponent>>();
    public static double[] incenseBonuses = new double[]{0.2, 0.6, 1.2, 2.0, 3.0, 4.5};
    public static double[] tranquilityRequired = new double[]{0.0, 6.0, 14.14, 28.0, 44.09, 83.14};
    public static int[] roadsRequired = new int[]{0, 1, 4, 6, 8, 10, 12};

    public static void registerIncenseComponent(int altarLevel, IncenseAltarComponent component) {
        if (incenseComponentMap.containsKey(altarLevel)) {
            incenseComponentMap.get(altarLevel).add(component);
        } else {
            ArrayList<IncenseAltarComponent> list = new ArrayList<IncenseAltarComponent>();
            list.add(component);
            incenseComponentMap.put(altarLevel, list);
        }
    }

    public static void registerIncenseComponent(int altarLevel, BlockPos offsetPos, Block block, IBlockState state) {
        IncenseAltarHandler.registerIncenseComponent(altarLevel, new IncenseAltarComponent(offsetPos, block, state));
    }

    public static double getMaxIncenseBonusFromComponents(World world, BlockPos pos) {
        double accumulatedBonus = 0.0;
        for (int i = 0; i < incenseBonuses.length; ++i) {
            double previousBonus = i <= 0 ? 0.0 : incenseBonuses[i - 1];
            double nextBonus = incenseBonuses[i];
            if (!incenseComponentMap.containsKey(i)) {
                accumulatedBonus += nextBonus - previousBonus;
                continue;
            }
            boolean hasAllComponentsThisTier = true;
            for (IncenseAltarComponent component : incenseComponentMap.get(i)) {
                BlockPos offsetPos;
                IBlockState state;
                Block block;
                if (component.doesBlockMatch(block = (state = world.func_180495_p(offsetPos = pos.func_177971_a((Vec3i)component.getOffset(EnumFacing.NORTH)))).func_177230_c(), state)) {
                    hasAllComponentsThisTier = false;
                    continue;
                }
                accumulatedBonus += (nextBonus - previousBonus) / (double)incenseComponentMap.get(i).size();
            }
            if (!hasAllComponentsThisTier) break;
        }
        return accumulatedBonus;
    }

    public static double getMaxIncenseBonusFromRoads(int roads) {
        double previousBonus = 0.0;
        for (int i = 0; i < incenseBonuses.length; ++i) {
            if (roads < roadsRequired[i]) {
                return previousBonus;
            }
            previousBonus = incenseBonuses[i];
        }
        return previousBonus;
    }

    public static double getIncenseBonusFromComponents(World world, BlockPos pos, double tranquility, int roads) {
        double maxBonus = Math.min(IncenseAltarHandler.getMaxIncenseBonusFromComponents(world, pos), IncenseAltarHandler.getMaxIncenseBonusFromRoads(roads));
        double possibleBonus = 0.0;
        for (int i = 0; i < incenseBonuses.length; ++i) {
            if (tranquility >= tranquilityRequired[i]) {
                possibleBonus = incenseBonuses[i];
                continue;
            }
            if (i < 1) continue;
            possibleBonus += (incenseBonuses[i] - possibleBonus) * (tranquility - tranquilityRequired[i - 1]) / (tranquilityRequired[i] - tranquilityRequired[i - 1]);
            break;
        }
        return Math.min(maxBonus, possibleBonus);
    }
}

