/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone;

import com.google.common.base.Predicate;
import com.google.common.reflect.Reflection;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.item.Item;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppedEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import org.apache.logging.log4j.Logger;
import ovh.corail.tombstone.ConfigTombstone;
import ovh.corail.tombstone.api.capability.ITBCapability;
import ovh.corail.tombstone.api.magic.ISoulConsumer;
import ovh.corail.tombstone.api.magic.TBSoulConsumerProvider;
import ovh.corail.tombstone.capability.TBCapabilityDefault;
import ovh.corail.tombstone.capability.TBCapabilityStorage;
import ovh.corail.tombstone.compatibility.CompatibilityBloodMagic;
import ovh.corail.tombstone.compatibility.CompatibilityCosmeticArmor;
import ovh.corail.tombstone.compatibility.CompatibilityGraveStone;
import ovh.corail.tombstone.compatibility.CompatibilityOpenBlocks;
import ovh.corail.tombstone.compatibility.CompatibilityThaumcraft;
import ovh.corail.tombstone.compatibility.SupportMods;
import ovh.corail.tombstone.event.EventHandler;
import ovh.corail.tombstone.helper.CallbackHandler;
import ovh.corail.tombstone.helper.DeathHandler;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.SoundHandler;
import ovh.corail.tombstone.helper.TombstoneDataFixer;
import ovh.corail.tombstone.network.PacketHandler;
import ovh.corail.tombstone.proxy.IProxy;
import ovh.corail.tombstone.registry.ModTriggers;
import ovh.corail.tombstone.tileentity.TileEntityTombstone;
import ovh.corail.tombstone.tileentity.TileEntityWritableGrave;

@Mod(modid="tombstone", name="Corail Tombstone", version="4.0.0", acceptedMinecraftVersions="[1.12.2,1.13)", dependencies="required-after:forge@[14.23.5.2838,);before:forgeessentials;before:erebus;before:quark;before:advanced-fishing;")
public class ModTombstone {
    @Mod.Instance(value="tombstone")
    public static ModTombstone instance;
    @SidedProxy(clientSide="ovh.corail.tombstone.proxy.ClientProxy", serverSide="ovh.corail.tombstone.proxy.ServerProxy")
    public static IProxy PROXY;
    public static Logger LOGGER;
    public static final EnumEnchantmentType typeTombstoneAll;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        LOGGER = event.getModLog();
        CapabilityManager.INSTANCE.register(ITBCapability.class, (Capability.IStorage)new TBCapabilityStorage(), TBCapabilityDefault::new);
        CapabilityManager.INSTANCE.register(ISoulConsumer.class, Helper.getNullStorage(), TBSoulConsumerProvider::getDefault);
        PacketHandler.init();
        MinecraftForge.EVENT_BUS.register((Object)new EventHandler());
        SoundHandler.registerSounds();
        GameRegistry.registerTileEntity(TileEntityWritableGrave.class, (String)"tombstone:writable_grave");
        GameRegistry.registerTileEntity(TileEntityTombstone.class, (String)"tombstone:tombstone");
        PROXY.preInit();
        Reflection.initialize((Class[])new Class[]{ModTriggers.class});
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        Helper.registerOreDicts();
        PROXY.init();
        TombstoneDataFixer.init();
        if (SupportMods.BLOOD_MAGIC.isLoaded()) {
            LOGGER.warn("Enabling the patch for Blood Magic (preventing the sacrificial dagger from killing a player twice, causing them to lose their inventory), you won't see this message again if you update your Blood Magic version.");
            MinecraftForge.EVENT_BUS.register((Object)CompatibilityBloodMagic.instance);
        }
        if (SupportMods.THAUMCRAFT.isLoaded() && ConfigTombstone.compatibilities.allowThaumcraftVisValues) {
            MinecraftForge.EVENT_BUS.register((Object)CompatibilityThaumcraft.instance);
        }
        if (SupportMods.TOP.isLoaded()) {
            FMLInterModComms.sendFunctionMessage((String)"theoneprobe", (String)"getTheOneProbe", (String)"ovh.corail.tombstone.compatibility.IntegrationTOP");
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        PROXY.postInit();
        MinecraftForge.EVENT_BUS.register((Object)Helper.buildKnowledgeFunction());
    }

    @Mod.EventHandler
    public void onServerStarted(FMLServerStartingEvent event) {
        if (ConfigTombstone.general.handlePlayerDeath) {
            if (CompatibilityGraveStone.instance.isNightKosh()) {
                CompatibilityGraveStone.instance.disable();
            }
            if (SupportMods.OPENBLOCKS.isLoaded()) {
                MinecraftForge.EVENT_BUS.register((Object)CompatibilityOpenBlocks.instance);
            }
            if (SupportMods.COSMETIC_ARMOR.isLoaded()) {
                MinecraftForge.EVENT_BUS.register((Object)CompatibilityCosmeticArmor.instance);
            }
        }
        Helper.initCommands(event);
        MinecraftForge.EVENT_BUS.register((Object)new CallbackHandler());
        Helper.loadContributors(event.getServer());
    }

    @Mod.EventHandler
    public void onServerStoppingEvent(FMLServerStoppedEvent event) {
        CallbackHandler.clear();
        DeathHandler.INSTANCE.clear();
    }

    static {
        typeTombstoneAll = Helper.addEnchantmentType("typeTombstoneAll", (Predicate<Item>)((Predicate)p -> p != null && (p.func_77639_j() == 1 || p.func_77619_b() > 0)), EnumEnchantmentType.ALL);
    }
}

