/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.command;

import com.mojang.authlib.GameProfile;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketEntityEffect;
import net.minecraft.network.play.server.SPacketPlayerAbilities;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.IThreadListener;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.storage.ThreadedFileIOBase;
import net.minecraftforge.common.DimensionManager;
import org.apache.commons.lang3.tuple.Pair;
import ovh.corail.tombstone.ConfigTombstone;
import ovh.corail.tombstone.command.TombstoneCommand;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.TeleportUtils;

public class CommandTBRecovery
extends TombstoneCommand {
    public String func_71517_b() {
        return "tbrecovery";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length >= 1 && args.length <= 4) {
            EnumCommandAction action = EnumCommandAction.getAction(args[0]);
            if (action == null || action == EnumCommandAction.SAVE_ALL_PLAYERS && args.length != 1 || action == EnumCommandAction.LOAD_PLAYER && args.length != 3 || action == EnumCommandAction.SAVE_PLAYER && args.length != 2) {
                throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
            }
            switch (action) {
                case LOAD_PLAYER: {
                    EntityPlayerMP player = CommandTBRecovery.func_184888_a((MinecraftServer)server, (ICommandSender)sender, (String)args[1]);
                    CommandTBRecovery.checkAlive((Entity)player);
                    CommandTBRecovery.checkNotSpectator((EntityPlayer)player);
                    this.loadPlayer(sender, player, args[2]);
                    break;
                }
                case LOAD_OFFLINE: {
                    UUID uuid = UUID.fromString(args[1]);
                    GameProfile profil = server.func_152358_ax().func_152652_a(uuid);
                    if (profil == null) {
                        throw new CommandException(LangKey.COMMAND_EXCEPTION_INVALID_PLAYER.getKey(), new Object[0]);
                    }
                    if (server.func_184103_al().func_177451_a(uuid) != null) {
                        throw new CommandException(LangKey.COMMAND_EXCEPTION_ONLINE_PLAYER.getKey(), new Object[0]);
                    }
                    this.recoverPlayerOffline(sender, profil, args[2]);
                    break;
                }
                case SAVE_PLAYER: {
                    EntityPlayerMP player = CommandTBRecovery.func_184888_a((MinecraftServer)server, (ICommandSender)sender, (String)args[1]);
                    CommandTBRecovery.checkAlive((Entity)player);
                    CommandTBRecovery.checkNotSpectator((EntityPlayer)player);
                    CommandTBRecovery.savePlayer(player, success -> CommandTBRecovery.func_152373_a((ICommandSender)sender, (ICommand)this, (String)(success != false ? LangKey.MESSAGE_RECOVERY_SAVE_PLAYER_SUCCESS : LangKey.MESSAGE_RECOVERY_SAVE_PLAYER_FAILED).getKey(), (Object[])new Object[]{player.func_70005_c_()}));
                    break;
                }
                case SAVE_ALL_PLAYERS: {
                    CommandTBRecovery.saveAllPlayers(server, success -> CommandTBRecovery.func_152373_a((ICommandSender)sender, (ICommand)this, (String)(success != false ? LangKey.MESSAGE_RECOVERY_SAVE_ALL_PLAYERS_SUCCESS : LangKey.MESSAGE_RECOVERY_SAVE_ALL_PLAYERS_FAILED).getKey(), (Object[])new Object[0]));
                }
            }
        } else {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
    }

    public static void saveAllPlayers(MinecraftServer server, Consumer<Boolean> callback) {
        File baseFolder = new File(DimensionManager.getCurrentSaveRootDirectory(), "tombstone/saved_players");
        if (!baseFolder.exists() && !baseFolder.mkdirs()) {
            LangKey.MESSAGE_RECOVERY_CANT_CREATE_FOLDER.sendLog(new Object[0]);
            callback.accept(false);
            return;
        }
        ArrayList<Pair> pairs = new ArrayList<Pair>();
        boolean hasPlayerSkipped = false;
        for (EntityPlayerMP player : server.func_184103_al().func_181057_v()) {
            if (player.field_70128_L || player.func_175149_v()) continue;
            File playerFolder = CommandTBRecovery.getPlayerFolder(player);
            if (playerFolder == null) {
                hasPlayerSkipped = true;
                continue;
            }
            pairs.add(Pair.of((Object)player.func_189511_e(new NBTTagCompound()), (Object)playerFolder));
        }
        if (pairs.size() == 0) {
            callback.accept(true);
            return;
        }
        boolean isSkipped = hasPlayerSkipped;
        ThreadedFileIOBase.func_178779_a().func_75735_a(() -> {
            boolean wasSuccessful = !isSkipped;
            for (Pair nbtTagCompoundFilePair : pairs) {
                boolean success = CommandTBRecovery.savePlayerData((NBTTagCompound)nbtTagCompoundFilePair.getLeft(), (File)nbtTagCompoundFilePair.getRight());
                if (success) continue;
                wasSuccessful = false;
            }
            boolean isSuccessful = wasSuccessful;
            server.func_152344_a(() -> callback.accept(isSuccessful));
            return false;
        });
    }

    public static void savePlayer(EntityPlayerMP player, Consumer<Boolean> callback) {
        File playerFolder = CommandTBRecovery.getPlayerFolder(player);
        if (playerFolder == null) {
            callback.accept(false);
        } else {
            MinecraftServer listener = player.field_71133_b;
            NBTTagCompound tag = player.func_189511_e(new NBTTagCompound());
            ThreadedFileIOBase.func_178779_a().func_75735_a(() -> CommandTBRecovery.lambda$savePlayer$5(tag, playerFolder, (IThreadListener)listener, callback));
        }
    }

    private static boolean savePlayerData(NBTTagCompound tag, File saveFolder) {
        String dateString = new SimpleDateFormat("yyyyMMdd-hhmmss", Locale.US).format(new Date());
        try {
            FileWriter writer = new FileWriter(new File(saveFolder, dateString + ".save"));
            try {
                writer.write(tag.toString());
                writer.close();
                File[] matchingFiles = saveFolder.listFiles((file, name) -> name.endsWith(".save"));
                if (matchingFiles != null && matchingFiles.length > ConfigTombstone.recovery.recoveryPlayerMaxSaves) {
                    Arrays.sort(matchingFiles, Comparator.comparingLong(File::lastModified));
                    int num = 0;
                    int adjust = matchingFiles.length - ConfigTombstone.recovery.recoveryPlayerMaxSaves;
                    for (int i = 0; i < matchingFiles.length && num < adjust; ++num, ++i) {
                        matchingFiles[i].delete();
                    }
                }
                return true;
            }
            catch (Exception e) {
                try {
                    writer.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                e.printStackTrace();
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Nullable
    private static File getPlayerFolder(EntityPlayerMP player) {
        File saveFolder = new File(DimensionManager.getCurrentSaveRootDirectory(), "tombstone/saved_players/" + player.func_110124_au());
        if (!saveFolder.exists() && !saveFolder.mkdirs()) {
            LangKey.MESSAGE_RECOVERY_CANT_CREATE_FOLDER.sendLog(new Object[0]);
            return null;
        }
        return saveFolder;
    }

    private void recoverPlayerOffline(ICommandSender sender, GameProfile profil, String fileString) throws CommandException {
        PlayerList playerList = sender.func_184102_h().func_184103_al();
        EntityPlayerMP player = playerList.func_148545_a(profil);
        try (BufferedReader reader = new BufferedReader(new FileReader(this.getBackupFile(sender, profil.getId(), fileString)));){
            NBTTagCompound nbt = JsonToNBT.func_180713_a((String)reader.readLine());
            reader.close();
            if (!nbt.func_150296_c().isEmpty()) {
                player.deserializeNBT(nbt);
                player.func_71121_q().func_72860_G().func_75756_e().func_75753_a((EntityPlayer)player);
                CommandTBRecovery.func_152373_a((ICommandSender)sender, (ICommand)this, (String)LangKey.MESSAGE_RECOVERY_LOAD_PLAYER_SUCCESS.getKey(), (Object[])new Object[]{player.func_70005_c_()});
            }
        }
        catch (Exception var19) {
            throw new CommandException(LangKey.MESSAGE_RECOVERY_LOAD_PLAYER_FAILED.getKey(), new Object[]{player.func_70005_c_()});
        }
    }

    private void loadPlayer(ICommandSender sender, EntityPlayerMP player, String fileString) throws CommandException {
        try (BufferedReader reader = new BufferedReader(new FileReader(this.getBackupFile(sender, player.func_110124_au(), fileString)));){
            NBTTagCompound nbt = JsonToNBT.func_180713_a((String)reader.readLine());
            reader.close();
            if (nbt.func_150296_c().isEmpty()) {
                throw new CommandException(LangKey.MESSAGE_RECOVERY_LOAD_PLAYER_FAILED.getKey(), new Object[]{player.func_70005_c_()});
            }
            int originalDim = player.field_71093_bK;
            player.deserializeNBT(nbt);
            TeleportUtils.teleportEntity((Entity)player, player.field_71093_bK, player.field_70165_t, player.field_70163_u, player.field_70161_v);
            if (originalDim == player.field_71093_bK) {
                player.field_71135_a.func_147359_a((Packet)new SPacketPlayerAbilities(player.field_71075_bZ));
                for (PotionEffect potioneffect : player.func_70651_bq()) {
                    player.field_71135_a.func_147359_a((Packet)new SPacketEntityEffect(player.func_145782_y(), potioneffect));
                }
            }
            LangKey.MESSAGE_RECOVERY_LOAD_PLAYER_TARGET_SUCCESS.sendSpecialMessage((ICommandSender)player, new Object[0]);
            CommandTBRecovery.func_152373_a((ICommandSender)sender, (ICommand)this, (String)LangKey.MESSAGE_RECOVERY_LOAD_PLAYER_SUCCESS.getKey(), (Object[])new Object[]{player.func_70005_c_()});
        }
        catch (Exception var20) {
            throw new CommandException(LangKey.MESSAGE_RECOVERY_LOAD_PLAYER_FAILED.getKey(), new Object[]{player.func_70005_c_()});
        }
    }

    private File getBackupFile(ICommandSender sender, UUID id, String fileString) throws CommandException {
        String fileName;
        File saveFolder = new File(DimensionManager.getCurrentSaveRootDirectory(), "tombstone/saved_players/" + id);
        if (!saveFolder.exists()) {
            throw new CommandException(LangKey.MESSAGE_RECOVERY_NO_FOLDER.getKey(), new Object[]{saveFolder.getAbsolutePath()});
        }
        if (!fileString.equals(".latest") && !fileString.equals(".oldest")) {
            fileName = fileString + ".save";
            File[] saveFiles = saveFolder.listFiles(p -> p.isFile() && p.getName().equals(fileName));
            if (saveFiles == null || saveFiles.length == 0) {
                throw new CommandException(LangKey.MESSAGE_RECOVERY_NO_FILE.getKey(), new Object[]{fileName});
            }
        } else {
            File[] saveFiles = saveFolder.listFiles(p -> p.isFile() && p.getName().endsWith(".save"));
            if (saveFiles == null || saveFiles.length == 0) {
                throw new CommandException(LangKey.MESSAGE_RECOVERY_NO_FILE.getKey(), new Object[]{fileString});
            }
            Optional<File> res = fileString.equals(".latest") ? Stream.of(saveFiles).max(File::compareTo) : Stream.of(saveFiles).min(File::compareTo);
            fileName = res.get().getName();
        }
        return new File(saveFolder, fileName);
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        if (args.length == 1) {
            return CommandTBRecovery.func_175762_a((String[])args, (Collection)Stream.of(EnumCommandAction.values()).map(EnumCommandAction::getName).collect(Collectors.toList()));
        }
        if (args.length == 2) {
            EnumCommandAction action = EnumCommandAction.getAction(args[0]);
            if (action != null && action != EnumCommandAction.SAVE_ALL_PLAYERS) {
                if (action != EnumCommandAction.LOAD_OFFLINE) {
                    return CommandTBRecovery.func_71530_a((String[])args, (String[])server.func_71213_z());
                }
                File checkedDir = new File(DimensionManager.getCurrentSaveRootDirectory(), "tombstone/saved_players/");
                File[] uuidDirs = checkedDir.listFiles((file, name) -> {
                    boolean valid;
                    boolean bl = valid = file.isDirectory() && name.contains("-");
                    if (valid) {
                        UUID uuid = UUID.fromString(name);
                        if (server.func_184103_al().func_177451_a(uuid) == null) {
                            return server.func_152358_ax().func_152652_a(uuid) != null;
                        }
                    }
                    return false;
                });
                return CommandTBRecovery.func_175762_a((String[])args, uuidDirs == null ? new ArrayList() : (Collection)Arrays.stream(uuidDirs).map(File::getName).collect(Collectors.toList()));
            }
            return Collections.emptyList();
        }
        if (args.length == 3) {
            UUID uuid;
            boolean isLoadPlayer;
            EnumCommandAction action = EnumCommandAction.getAction(args[0]);
            boolean bl = isLoadPlayer = action == EnumCommandAction.LOAD_PLAYER;
            if (!isLoadPlayer && action != EnumCommandAction.LOAD_OFFLINE) {
                return Collections.emptyList();
            }
            if (isLoadPlayer) {
                EntityPlayerMP player = server.func_184103_al().func_152612_a(args[1]);
                if (player == null) {
                    return Collections.emptyList();
                }
                uuid = player.func_110124_au();
            } else {
                uuid = UUID.fromString(args[1]);
            }
            File checkedFile = new File(DimensionManager.getCurrentSaveRootDirectory(), "tombstone/saved_players/" + uuid);
            if (!checkedFile.exists()) {
                return Collections.emptyList();
            }
            File[] matchingFiles = checkedFile.listFiles((file, name) -> name.endsWith(".save"));
            if (matchingFiles == null) {
                return Collections.emptyList();
            }
            List<String> list = Arrays.stream(matchingFiles).map(p -> p.getName().replace(".save", "")).collect(Collectors.toList());
            list.add(".latest");
            list.add(".oldest");
            return list;
        }
        return Collections.emptyList();
    }

    private static /* synthetic */ boolean lambda$savePlayer$5(NBTTagCompound tag, File playerFolder, IThreadListener listener, Consumer callback) {
        boolean result = CommandTBRecovery.savePlayerData(tag, playerFolder);
        listener.func_152344_a(() -> callback.accept(result));
        return false;
    }

    public static enum EnumCommandAction {
        SAVE_ALL_PLAYERS("save_all_players"),
        SAVE_PLAYER("save_player"),
        LOAD_PLAYER("load_player"),
        LOAD_OFFLINE("load_offline");

        private final String name;

        private EnumCommandAction(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        @Nullable
        public static EnumCommandAction getAction(String name) {
            return Arrays.stream(EnumCommandAction.values()).filter(p -> p.getName().equals(name)).findFirst().orElse(null);
        }
    }
}

