/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.command;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.storage.ThreadedFileIOBase;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import ovh.corail.tombstone.ModTombstone;
import ovh.corail.tombstone.command.TombstoneCommand;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.registry.ModItems;

public class CommandTBReviveFamiliar
extends TombstoneCommand {
    public String func_71517_b() {
        return "tbrevivefamiliar";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length != 1) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        EntityPlayerMP player = CommandTBReviveFamiliar.func_184888_a((MinecraftServer)server, (ICommandSender)sender, (String)args[0]);
        this.reviveFamiliar(sender, player);
    }

    private void reviveFamiliar(ICommandSender sender, EntityPlayerMP player) throws CommandException {
        LangKey message;
        CommandTBReviveFamiliar.checkAlive((Entity)player);
        CommandTBReviveFamiliar.checkNotSpectator((EntityPlayer)player);
        NBTTagCompound petTag = this.getLastSave((EntityPlayer)player);
        ItemStack receptacle = ItemStack.field_190927_a;
        if (petTag != null) {
            receptacle = new ItemStack((Item)ModItems.familiar_receptacle);
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74782_a("dead_pet", (NBTBase)petTag);
            receptacle.func_77982_d(tag);
        } else {
            IItemHandler invent = (IItemHandler)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            if (invent != null) {
                for (int slot = 0; slot < invent.getSlots(); ++slot) {
                    ItemStack stack = invent.getStackInSlot(slot);
                    if (!ModItems.familiar_receptacle.containSoul(stack)) continue;
                    receptacle = stack;
                    break;
                }
            }
        }
        if (receptacle.func_190926_b()) {
            throw new CommandException(LangKey.MESSAGE_NO_SAVE_TO_RESTORE.getKey(), new Object[0]);
        }
        boolean success = ModItems.familiar_receptacle.revive((EntityPlayer)player, player.func_180425_c(), receptacle);
        LangKey langKey = message = success ? LangKey.MESSAGE_BRING_BACK_TO_LIFE : LangKey.MESSAGE_CANT_REVIVE_FAMILIAR;
        if (success) {
            message.sendSpecialMessage((ICommandSender)player, LangKey.MESSAGE_YOUR_FAMILIAR.getTranslation(new Object[0]));
            if (sender.func_174793_f() != player) {
                CommandTBReviveFamiliar.func_152373_a((ICommandSender)sender, (ICommand)this, (String)message.getKey(), (Object[])new Object[]{LangKey.MESSAGE_FAMILIAR_OF.getTranslation(player.func_70005_c_())});
            }
        } else {
            throw new CommandException(message.getKey(), new Object[]{LangKey.MESSAGE_YOUR_FAMILIAR.getTranslation(new Object[0])});
        }
        receptacle.func_190918_g(1);
        player.field_71069_bz.func_75142_b();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private NBTTagCompound getLastSave(EntityPlayer player) {
        File saveFolder = new File(DimensionManager.getCurrentSaveRootDirectory(), "tombstone/saved_familiars/" + player.func_110124_au());
        if (!saveFolder.exists()) {
            return null;
        }
        File[] saveFiles = saveFolder.listFiles(p -> p.isFile() && p.getName().endsWith(".save"));
        if (saveFiles == null) return null;
        if (saveFiles.length == 0) {
            return null;
        }
        File file = Stream.of(saveFiles).max(File::compareTo).orElse(null);
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            NBTTagCompound nbt = JsonToNBT.func_180713_a((String)reader.readLine());
            reader.close();
            if (nbt.func_150296_c().isEmpty()) {
                NBTTagCompound nBTTagCompound2 = null;
                return nBTTagCompound2;
            }
            file.delete();
            NBTTagCompound nBTTagCompound = nbt;
            return nBTTagCompound;
        }
        catch (IOException | NBTException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void saveFamiliar(MinecraftServer server, UUID ownerId, NBTTagCompound tag, String saveName) {
        File saveFolder = new File(DimensionManager.getCurrentSaveRootDirectory(), "tombstone/saved_familiars/" + ownerId);
        if (!saveFolder.exists() && !saveFolder.mkdirs()) {
            ModTombstone.LOGGER.info("The backup folder for familiars cannot be created");
            return;
        }
        String dateString = new SimpleDateFormat("yyyyMMdd-hhmmss", Locale.US).format(new Date());
        File accessedFile = new File(saveFolder, dateString + "_" + saveName + ".save");
        ThreadedFileIOBase.func_178779_a().func_75735_a(() -> {
            block14: {
                try {
                    FileWriter writer = new FileWriter(accessedFile);
                    try {
                        writer.write(tag.toString());
                        writer.close();
                        File[] matchingFiles = saveFolder.listFiles((file, name) -> name.endsWith(".save"));
                        if (matchingFiles == null || matchingFiles.length <= 5) break block14;
                        int diff = matchingFiles.length - 5;
                        Arrays.sort(matchingFiles, Comparator.comparingLong(File::lastModified));
                        int num = 0;
                        for (File file2 : matchingFiles) {
                            if (num >= diff) {
                                break;
                            }
                            file2.delete();
                            ++num;
                        }
                    }
                    catch (Throwable t) {
                        throw t;
                    }
                    finally {
                        if (writer != null) {
                            try {
                                writer.close();
                            }
                            catch (Throwable matchingFiles) {}
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return false;
        });
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        return args.length == 1 ? CommandTBReviveFamiliar.func_71530_a((String[])args, (String[])server.func_71213_z()) : Collections.emptyList();
    }
}

