/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.command;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import ovh.corail.tombstone.command.TombstoneCommand;
import ovh.corail.tombstone.compatibility.SupportMods;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.SpawnHelper;

public class CommandTBTeleport
extends TombstoneCommand {
    public String func_71517_b() {
        return "tbteleport";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        Location location;
        EntityPlayerMP entitySource;
        if (args.length != 0 && args.length <= 5) {
            int dimTarget;
            CommandBase.CoordinateArg z;
            CommandBase.CoordinateArg y;
            CommandBase.CoordinateArg x;
            boolean hasEntitySourceParam;
            boolean hasEntityTargetParam = args.length == 1 || args.length == 2;
            entitySource = null;
            if (args.length != 1 && args.length != 3) {
                try {
                    entitySource = CommandTBTeleport.func_184885_b((MinecraftServer)server, (ICommandSender)sender, (String)args[0]);
                    hasEntitySourceParam = entitySource.field_70170_p != null;
                }
                catch (Exception var16) {
                    hasEntitySourceParam = false;
                }
            } else {
                hasEntitySourceParam = false;
            }
            if (!hasEntitySourceParam) {
                if (!(sender instanceof EntityPlayerMP)) {
                    throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
                }
                entitySource = (EntityPlayerMP)sender;
            }
            CommandTBTeleport.checkAlive(entitySource);
            CommandTBTeleport.checkNotSpectator(entitySource);
            Location sourcePos = new Location((Entity)entitySource);
            if (!hasEntityTargetParam) {
                Vec3d vec3d = entitySource.func_174791_d();
                int numArgCoordX = hasEntitySourceParam ? 1 : 0;
                x = CommandTBTeleport.func_175770_a((double)vec3d.field_72450_a, (String)args[numArgCoordX], (boolean)true);
                y = !SupportMods.CUBIC_CHUNKS.isLoaded() ? CommandTBTeleport.func_175767_a((double)vec3d.field_72448_b, (String)args[numArgCoordX + 1], (int)-4096, (int)4096, (boolean)false) : CommandTBTeleport.func_175770_a((double)vec3d.field_72448_b, (String)args[numArgCoordX + 1], (boolean)false);
                z = CommandTBTeleport.func_175770_a((double)vec3d.field_72449_c, (String)args[numArgCoordX + 2], (boolean)true);
                boolean hasDimensionParam = hasEntitySourceParam && args.length == 5 || !hasEntitySourceParam && args.length == 4;
                dimTarget = hasDimensionParam ? CommandTBTeleport.func_175755_a((String)args[numArgCoordX + 3]) : sourcePos.dim;
            } else {
                Entity entityTarget;
                int numArgEntityTarget = hasEntitySourceParam ? 1 : 0;
                try {
                    entityTarget = CommandTBTeleport.func_184885_b((MinecraftServer)server, (ICommandSender)sender, (String)args[numArgEntityTarget]);
                }
                catch (Exception var15) {
                    throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
                }
                if (entityTarget.field_70170_p == null) {
                    throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
                }
                Vec3d vec3d = entityTarget.func_174791_d();
                x = CommandTBTeleport.func_175770_a((double)vec3d.field_72450_a, (String)("" + vec3d.field_72450_a), (boolean)true);
                y = !SupportMods.CUBIC_CHUNKS.isLoaded() ? CommandTBTeleport.func_175767_a((double)vec3d.field_72448_b, (String)("" + vec3d.field_72448_b), (int)-4096, (int)4096, (boolean)false) : CommandTBTeleport.func_175770_a((double)vec3d.field_72448_b, (String)("" + vec3d.field_72448_b), (boolean)false);
                z = CommandTBTeleport.func_175770_a((double)vec3d.field_72449_c, (String)("" + vec3d.field_72449_c), (boolean)true);
                dimTarget = entityTarget.field_70170_p.field_73011_w.getDimension();
            }
            location = new Location(x.func_179628_a(), y.func_179628_a(), z.func_179628_a(), dimTarget);
            if (!Helper.isValidDimension(dimTarget)) {
                throw new CommandException(LangKey.COMMAND_EXCEPTION_NO_DIMENSION.getKey(), new Object[0]);
            }
            if (sourcePos.equals(location)) {
                throw new CommandException(LangKey.COMMAND_EXCEPTION_SAME_LOCATION.getKey(), new Object[0]);
            }
            WorldServer targetWorld = server.func_71218_a(location.dim);
            CommandTBTeleport.checkValidPos((World)targetWorld, location.getPos());
            location = new SpawnHelper(targetWorld, Helper.getCloserValidPos((World)targetWorld, location.getPos())).findSpawnPlace();
            if (location.isOrigin()) {
                throw new CommandException(LangKey.COMMAND_EXCEPTION_NO_SPAWN.getKey(), new Object[0]);
            }
        } else {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        EntityPlayerMP newEntity = Helper.teleportEntity(entitySource, location);
        CommandTBTeleport.func_152373_a((ICommandSender)sender, (ICommand)this, (String)LangKey.MESSAGE_LOG_TELEPORT_SUCCESS.getKey(), (Object[])new Object[]{entitySource.func_70005_c_(), location.x, location.y, location.z, location.dim});
        LangKey.MESSAGE_TELEPORT_SUCCESS.sendSpecialMessage((ICommandSender)newEntity, new Object[0]);
    }

    public boolean func_82358_a(String[] args, int index) {
        return index == 0 || index == 1 && args.length == 2;
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        return args.length == 1 ? CommandTBTeleport.func_71530_a((String[])args, (String[])server.func_71213_z()) : (args.length > 1 && args.length < 5 ? CommandTBTeleport.func_175771_a((String[])args, (int)1, (BlockPos)targetPos) : Collections.emptyList());
    }
}

