/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.command;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.Entity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.village.Village;
import net.minecraft.world.WorldServer;
import ovh.corail.tombstone.command.TombstoneCommand;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.Location;

public class CommandTBTeleportVillage
extends TombstoneCommand {
    public String func_71517_b() {
        return "tbteleportvillage";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        Location spawnLoc;
        if (args.length != 2) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        Entity target = CommandTBTeleportVillage.func_184885_b((MinecraftServer)server, (ICommandSender)sender, (String)args[0]);
        CommandTBTeleportVillage.checkAlive(target);
        CommandTBTeleportVillage.checkNotSpectator(target);
        WorldServer world = server.func_71218_a(target.field_70170_p.field_73011_w.getDimension());
        List villageList = world.func_175714_ae().func_75540_b();
        int villageNum = CommandTBTeleportVillage.func_175755_a((String)args[1]);
        int villageMax = villageList.size();
        if (villageMax == 0) {
            throw new CommandException(LangKey.COMMAND_EXCEPTION_NO_VILLAGE.getKey(), new Object[0]);
        }
        if (villageNum >= 0 && villageNum < villageMax) {
            Village village = (Village)villageList.get(villageNum);
            spawnLoc = Helper.findSpawnForVillage(world, village.func_180608_a());
            if (spawnLoc.isOrigin()) {
                throw new CommandException(LangKey.COMMAND_EXCEPTION_NO_SPAWN.getKey(), new Object[0]);
            }
        } else {
            throw new CommandException(LangKey.COMMAND_EXCEPTION_INVALID_VILLAGE.getKey(), new Object[]{"(0-" + (villageMax - 1) + ")"});
        }
        Entity newEntity = Helper.teleportEntity(target, spawnLoc);
        CommandTBTeleportVillage.func_152373_a((ICommandSender)sender, (ICommand)this, (String)LangKey.MESSAGE_LOG_TELEPORT_SUCCESS.getKey(), (Object[])new Object[]{target.func_70005_c_(), spawnLoc.x, spawnLoc.y, spawnLoc.z, spawnLoc.dim});
        LangKey.MESSAGE_TELEPORT_SUCCESS.sendSpecialMessage((ICommandSender)newEntity, new Object[0]);
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        if (args.length == 2) {
            try {
                Entity target = CommandTBTeleportVillage.func_184885_b((MinecraftServer)server, (ICommandSender)sender, (String)args[0]);
                int villageMax = server.func_71218_a(target.field_70170_p.field_73011_w.getDimension()).func_175714_ae().func_75540_b().size();
                return IntStream.rangeClosed(0, villageMax - 1).mapToObj(String::valueOf).collect(Collectors.toList());
            }
            catch (CommandException var7) {
                return Collections.emptyList();
            }
        }
        return args.length == 1 ? CommandTBTeleportVillage.func_71530_a((String[])args, (String[])server.func_71213_z()) : Collections.emptyList();
    }
}

