/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.enchantment;

import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import ovh.corail.tombstone.ConfigTombstone;
import ovh.corail.tombstone.enchantment.WeaponEnchantment;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.registry.ModEnchantments;

public class EnchantmentMagicSiphon
extends WeaponEnchantment {
    public EnchantmentMagicSiphon() {
        super("magic_siphon", Enchantment.Rarity.RARE, EnumEnchantmentType.WEAPON, new EntityEquipmentSlot[]{EntityEquipmentSlot.MAINHAND});
    }

    @Override
    protected boolean isEnabled() {
        return ConfigTombstone.enchantments.isEnableEnchantmentMagicSiphon();
    }

    protected boolean func_77326_a(Enchantment ench) {
        return super.func_77326_a(ench) && (ConfigTombstone.enchantments.allowPlagueBringerCombiningWithMagicSiphon() || ench != ModEnchantments.plague_bringer);
    }

    @Override
    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return ConfigTombstone.enchantments.allowMagicSiphonAtEnchantingTable() && super.canApplyAtEnchantingTable(stack);
    }

    @Override
    public int func_77325_b() {
        return ConfigTombstone.enchantments.getMaxLevelMagicSiphon();
    }

    @Override
    public void onProc(EntityLivingBase attacker, EntityLivingBase target, int level) {
        List effects = target.func_70651_bq().stream().filter(Helper::isAllowedEffect).collect(Collectors.toList());
        if (!effects.isEmpty()) {
            PotionEffect effectInstance = (PotionEffect)effects.get(Helper.random.nextInt(effects.size()));
            Potion effect = effectInstance.func_188419_a();
            int amplifier = effectInstance.func_76458_c();
            int duration = effectInstance.func_76459_b();
            int maxDuration = TimeHelper.tickFromMinute(ConfigTombstone.enchantments.maxDurationMagicSiphon);
            EntityHelper.clearEffect(target, effect);
            boolean canAbsorbAll = duration <= maxDuration;
            EntityHelper.addPotion(attacker, effect, canAbsorbAll ? duration : maxDuration, amplifier, new boolean[0]);
            if (!canAbsorbAll) {
                EntityHelper.addPotion(target, effect, maxDuration - duration, amplifier, new boolean[0]);
            }
            if (target.func_110143_aJ() > target.func_110138_aP()) {
                target.func_70606_j(target.func_110138_aP());
            }
        }
    }
}

