/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import ovh.corail.tombstone.helper.Location;

public class NBTStackHelper {
    private static boolean checkCompound(ItemStack stack, boolean addCompound) {
        if (stack.func_190926_b()) {
            return false;
        }
        if (addCompound && !stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        return stack.func_77942_o();
    }

    private static NBTTagCompound getOrCreateTag(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null) {
            tag = new NBTTagCompound();
            stack.func_77982_d(tag);
        }
        return tag;
    }

    private static boolean checkCompound(ItemStack stack) {
        return NBTStackHelper.checkCompound(stack, false);
    }

    private static NBTTagCompound getCompound(ItemStack stack) {
        return Objects.requireNonNull(stack.func_77978_p());
    }

    public static ItemStack setString(ItemStack stack, String keyName, String keyValue) {
        if (NBTStackHelper.checkCompound(stack, true)) {
            NBTStackHelper.getCompound(stack).func_74778_a(keyName, keyValue);
        }
        return stack;
    }

    public static String getString(ItemStack stack, String keyName) {
        NBTTagCompound compound;
        if (NBTStackHelper.checkCompound(stack) && (compound = NBTStackHelper.getCompound(stack)).func_74764_b(keyName)) {
            return compound.func_74779_i(keyName);
        }
        return "";
    }

    public static ItemStack setBoolean(ItemStack stack, String keyName, boolean keyValue) {
        if (NBTStackHelper.checkCompound(stack, true)) {
            NBTStackHelper.getCompound(stack).func_74757_a(keyName, keyValue);
        }
        return stack;
    }

    public static boolean getBoolean(ItemStack stack, String keyName) {
        NBTTagCompound compound;
        if (NBTStackHelper.checkCompound(stack) && (compound = NBTStackHelper.getCompound(stack)).func_74764_b(keyName)) {
            return compound.func_74767_n(keyName);
        }
        return false;
    }

    public static ItemStack setInteger(ItemStack stack, String keyName, int keyValue) {
        if (NBTStackHelper.checkCompound(stack, true)) {
            NBTStackHelper.getCompound(stack).func_74768_a(keyName, keyValue);
        }
        return stack;
    }

    public static int getInteger(ItemStack stack, String keyName) {
        NBTTagCompound compound;
        if (NBTStackHelper.checkCompound(stack) && (compound = NBTStackHelper.getCompound(stack)).func_74764_b(keyName)) {
            return compound.func_74762_e(keyName);
        }
        return Integer.MIN_VALUE;
    }

    public static ItemStack setLong(ItemStack stack, String keyName, long keyValue) {
        if (NBTStackHelper.checkCompound(stack, true)) {
            NBTStackHelper.getCompound(stack).func_74772_a(keyName, keyValue);
        }
        return stack;
    }

    @Deprecated
    public static long getLong(ItemStack stack, String keyName) {
        return NBTStackHelper.getLong(stack, keyName, Long.MIN_VALUE);
    }

    public static long getLong(ItemStack stack, String keyName, long fallback) {
        NBTTagCompound compound;
        if (NBTStackHelper.checkCompound(stack) && (compound = NBTStackHelper.getCompound(stack)).func_74764_b(keyName)) {
            return compound.func_74763_f(keyName);
        }
        return fallback;
    }

    public static ItemStack setBlockPos(ItemStack stack, String keyName, BlockPos keyValue) {
        NBTStackHelper.setBlockPos(NBTStackHelper.getOrCreateTag(stack), keyName, keyValue);
        return stack;
    }

    public static void setBlockPos(NBTTagCompound tag, String keyName, BlockPos keyValue) {
        tag.func_74768_a(keyName + "X", keyValue.func_177958_n());
        tag.func_74768_a(keyName + "Y", keyValue.func_177956_o());
        tag.func_74768_a(keyName + "Z", keyValue.func_177952_p());
    }

    public static BlockPos getBlockPos(ItemStack stack, String keyName) {
        return NBTStackHelper.getBlockPos(NBTStackHelper.getOrCreateTag(stack), keyName);
    }

    public static BlockPos getBlockPos(@Nullable NBTTagCompound tag, String keyName) {
        return tag != null && tag.func_150297_b(keyName + "X", 3) && tag.func_150297_b(keyName + "Y", 3) && tag.func_150297_b(keyName + "Z", 3) ? new BlockPos(tag.func_74762_e(keyName + "X"), tag.func_74762_e(keyName + "Y"), tag.func_74762_e(keyName + "Z")) : Location.ORIGIN_POS;
    }

    public static ItemStack setLocation(ItemStack stack, String keyName, Location location) {
        NBTStackHelper.setLocation(NBTStackHelper.getOrCreateTag(stack), keyName, location);
        return stack;
    }

    public static NBTTagCompound setLocation(NBTTagCompound tag, String keyName, Location location) {
        NBTStackHelper.setBlockPos(tag, keyName, location.getPos());
        tag.func_74768_a(keyName + "D", location.dim);
        return tag;
    }

    public static Location getLocation(ItemStack stack, String keyName) {
        return NBTStackHelper.getLocation(NBTStackHelper.getOrCreateTag(stack), keyName);
    }

    public static Location getLocation(@Nullable NBTTagCompound tag, String keyName) {
        BlockPos pos;
        if (tag != null && tag.func_74764_b(keyName + "D") && !(pos = NBTStackHelper.getBlockPos(tag, keyName)).equals((Object)Location.ORIGIN_POS)) {
            return new Location(pos, tag.func_74762_e(keyName + "D"));
        }
        return Location.ORIGIN;
    }

    public static boolean removeKeyName(ItemStack stack, String keyName) {
        if (NBTStackHelper.hasKeyName(stack, keyName)) {
            NBTStackHelper.getCompound(stack).func_82580_o(keyName);
            return true;
        }
        return false;
    }

    public static boolean hasKeyName(ItemStack stack, String keyName) {
        return NBTStackHelper.checkCompound(stack) && NBTStackHelper.getCompound(stack).func_74764_b(keyName);
    }
}

