/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import java.util.HashMap;
import javax.annotation.Nullable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import ovh.corail.tombstone.helper.ResourceHelper;

public class SoundHandler {
    private static final HashMap<String, SoundEvent> sounds = new HashMap();

    public static void registerSounds() {
        SoundHandler.registerSound("magic_use01");
        SoundHandler.registerSound("ghost_laugh");
        SoundHandler.registerSound("ghost_howl");
    }

    private static void registerSound(String soundName) {
        SoundEvent currentSound = (SoundEvent)new SoundEvent(ResourceHelper.getRL(soundName)).setRegistryName(ResourceHelper.getRL("tombstone", soundName));
        ForgeRegistries.SOUND_EVENTS.register((IForgeRegistryEntry)currentSound);
        sounds.put(soundName, currentSound);
    }

    @Nullable
    public static SoundEvent getSound(String soundName) {
        SoundEvent currentSound = sounds.get(soundName);
        return currentSound != null ? currentSound : (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)ResourceHelper.getRL("minecraft", soundName));
    }

    public static boolean playSoundAllAround(String soundName, World world, BlockPos currentPos) {
        if (world.field_72995_K) {
            return false;
        }
        SoundEvent currentSound = SoundHandler.getSound(soundName);
        if (currentSound == null) {
            return false;
        }
        world.func_184133_a(null, currentPos, currentSound, soundName.equals("magic_use01") ? SoundCategory.PLAYERS : SoundCategory.VOICE, 1.0f, 1.0f);
        return true;
    }
}

