/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.network;

import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.registries.IForgeRegistryEntry;
import ovh.corail.tombstone.api.capability.ITBCapability;
import ovh.corail.tombstone.api.capability.Perk;
import ovh.corail.tombstone.capability.TBCapabilityProvider;
import ovh.corail.tombstone.perk.PerkRegistry;

public class SyncCapClientMessage
implements IMessage {
    private SyncType syncType;
    private long knowledge;
    private HashMap<Perk, Integer> perks;
    private Perk perk;
    private int level;
    private long nextPray;
    private int alignment;

    public SyncCapClientMessage() {
    }

    public SyncCapClientMessage(SyncType syncType, Object ... params) {
        this.syncType = syncType;
        if (syncType == SyncType.ALL) {
            this.knowledge = params.length > 0 ? (Long)params[0] : 0L;
            this.nextPray = params.length > 1 ? (Long)params[1] : -1L;
            this.alignment = params.length > 2 ? (Integer)params[2] : 0;
            this.perks = params.length > 3 ? (HashMap)params[3] : new HashMap();
        } else if (syncType == SyncType.KNOWLEDGE) {
            this.knowledge = params.length > 0 ? (Long)params[0] : 0L;
        } else if (syncType == SyncType.NEXT_PRAY) {
            this.nextPray = params.length > 0 ? (Long)params[0] : -1L;
        } else if (syncType == SyncType.ALIGNMENT) {
            this.alignment = params.length > 0 ? (Integer)params[0] : 0;
        } else if (syncType == SyncType.PERKS) {
            this.perks = params.length > 0 ? (HashMap)params[0] : new HashMap();
        } else if (syncType == SyncType.SET_PERK) {
            this.perk = params.length > 0 ? (Perk)params[0] : null;
            this.level = params.length > 1 ? (Integer)params[1] : 1;
        } else if (syncType == SyncType.REMOVE_PERK) {
            this.perk = params.length > 0 ? (Perk)params[0] : null;
        }
    }

    public void fromBytes(ByteBuf buf) {
        boolean isSyncAll;
        this.syncType = SyncType.values()[buf.readShort()];
        boolean bl = isSyncAll = this.syncType == SyncType.ALL;
        if (isSyncAll || this.syncType == SyncType.KNOWLEDGE) {
            this.knowledge = buf.readLong();
        }
        if (isSyncAll || this.syncType == SyncType.NEXT_PRAY) {
            this.nextPray = buf.readLong();
        }
        if (isSyncAll || this.syncType == SyncType.ALIGNMENT) {
            this.alignment = buf.readInt();
        }
        if (isSyncAll || this.syncType == SyncType.PERKS) {
            NBTTagCompound tag;
            this.perks = new HashMap();
            try {
                tag = ByteBufUtils.readTag((ByteBuf)buf);
            }
            catch (Exception var8) {
                tag = null;
            }
            if (tag != null && tag.func_150297_b("perks", 9)) {
                NBTTagList tagPerks = tag.func_150295_c("perks", 10);
                for (int i = 0; i < tagPerks.func_74745_c(); ++i) {
                    Perk perk;
                    NBTTagCompound tagPerk = tagPerks.func_150305_b(i);
                    if (!tagPerk.func_150297_b("id", 3) || !tagPerk.func_150297_b("level", 3) || (perk = (Perk)PerkRegistry.perkRegistry.getValue(tagPerk.func_74762_e("id"))) == null) continue;
                    this.perks.put(perk, tagPerk.func_74762_e("level"));
                }
            }
        }
        if (this.syncType == SyncType.SET_PERK) {
            this.perk = (Perk)PerkRegistry.perkRegistry.getValue(buf.readInt());
            this.level = buf.readInt();
        }
        if (this.syncType == SyncType.REMOVE_PERK) {
            this.perk = (Perk)PerkRegistry.perkRegistry.getValue(buf.readInt());
        }
    }

    public void toBytes(ByteBuf buf) {
        boolean isSyncAll;
        buf.writeShort(this.syncType.ordinal());
        boolean bl = isSyncAll = this.syncType == SyncType.ALL;
        if (isSyncAll || this.syncType == SyncType.KNOWLEDGE) {
            buf.writeLong(this.knowledge);
        }
        if (isSyncAll || this.syncType == SyncType.NEXT_PRAY) {
            buf.writeLong(this.nextPray);
        }
        if (isSyncAll || this.syncType == SyncType.ALIGNMENT) {
            buf.writeInt(this.alignment);
        }
        if (isSyncAll || this.syncType == SyncType.PERKS) {
            NBTTagCompound tag = new NBTTagCompound();
            NBTTagList tagPerks = new NBTTagList();
            for (Map.Entry<Perk, Integer> entry : this.perks.entrySet()) {
                NBTTagCompound tagPerk = new NBTTagCompound();
                tagPerk.func_74768_a("id", PerkRegistry.perkRegistry.getID((IForgeRegistryEntry)entry.getKey()));
                tagPerk.func_74768_a("level", entry.getValue().intValue());
                tagPerks.func_74742_a((NBTBase)tagPerk);
            }
            tag.func_74782_a("perks", (NBTBase)tagPerks);
            ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)tag);
        }
        if (this.syncType == SyncType.SET_PERK) {
            buf.writeInt(PerkRegistry.perkRegistry.getID((IForgeRegistryEntry)this.perk));
            buf.writeInt(this.level);
        }
        if (this.syncType == SyncType.REMOVE_PERK) {
            buf.writeInt(PerkRegistry.perkRegistry.getID((IForgeRegistryEntry)this.perk));
        }
    }

    public static enum SyncType {
        ALL,
        KNOWLEDGE,
        PERKS,
        SET_PERK,
        REMOVE_PERK,
        NEXT_PRAY,
        ALIGNMENT;

    }

    public static class Handler
    implements IMessageHandler<SyncCapClientMessage, IMessage> {
        public IMessage onMessage(SyncCapClientMessage message, MessageContext ctx) {
            Minecraft mainThread = Minecraft.func_71410_x();
            mainThread.func_152344_a(() -> {
                ITBCapability cap = (ITBCapability)Minecraft.func_71410_x().field_71439_g.getCapability(TBCapabilityProvider.TB_CAPABILITY, null);
                if (cap != null) {
                    switch (message.syncType) {
                        case ALL: {
                            cap.setKnowledge(message.knowledge);
                            cap.setNextPray(message.nextPray);
                            cap.setAlignment(message.alignment);
                            cap.setPerks(message.perks);
                            break;
                        }
                        case KNOWLEDGE: {
                            cap.setKnowledge(message.knowledge);
                            break;
                        }
                        case PERKS: {
                            cap.setPerks(message.perks);
                            break;
                        }
                        case SET_PERK: {
                            cap.setPerk(message.perk, message.level);
                            break;
                        }
                        case REMOVE_PERK: {
                            cap.removePerk(message.perk);
                            break;
                        }
                        case NEXT_PRAY: {
                            cap.setNextPray(message.nextPray);
                            break;
                        }
                        case ALIGNMENT: {
                            cap.setAlignment(message.alignment);
                        }
                    }
                }
            });
            return null;
        }
    }
}

