/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.lib.util.script;

import com.bloodnbonesgaming.lib.BNBGamingLib;
import com.bloodnbonesgaming.lib.util.data.ItemBlockData;
import com.bloodnbonesgaming.lib.util.script.ArgType;
import com.bloodnbonesgaming.lib.util.script.ClientOnly;
import com.bloodnbonesgaming.lib.util.script.ScriptArgs;
import com.bloodnbonesgaming.lib.util.script.ScriptUtil;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.enchantment.Enchantment;
import net.minecraftforge.fml.common.Loader;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class ScriptParser {
    private Object mainObj;
    private final Map<String, Object> localVariables = new HashMap<String, Object>();
    private final List<String> script;
    private final String fileName;
    private final Map<String, Class> classKeywords;
    private static final Object WRONG_SIDE = new Object();
    private boolean canceled = false;

    public ScriptParser(List<String> script, String fileName, Object mainObj, Map<String, Class> classKeywords, Map<String, Object> localVariables) {
        this.mainObj = mainObj;
        this.script = script;
        this.fileName = fileName;
        this.classKeywords = classKeywords;
        if (localVariables != null) {
            this.localVariables.putAll(localVariables);
        }
        this.localVariables.put("Parser", this);
    }

    public void setLocalVariable(String name, Object variable) {
        this.localVariables.put(name, variable);
    }

    public boolean hasLocalVariable(String name) {
        return this.localVariables.containsKey(name);
    }

    public Object getLocalVariable(String name) {
        return this.localVariables.get(name);
    }

    public Class<?> getClassForKeyword(String keyword) {
        if (this.classKeywords != null && this.classKeywords.containsKey(keyword)) {
            return this.classKeywords.get(keyword);
        }
        return ScriptUtil.getClassForKeyword(keyword);
    }

    public boolean parseScript() {
        for (String line : this.script) {
            if (this.canceled) break;
            if (line.isEmpty() || line.startsWith("#") || line.startsWith("//")) continue;
            try {
                if (this.checkLocalVariable(line) || this.checkMethod(line)) continue;
                throw new Exception("Not a local variable or method call.");
            }
            catch (Throwable e) {
                BNBGamingLib.libInstance.getLog().error("Error reading script in file " + this.fileName + " on line " + (this.script.indexOf(line) + 1) + (e.getMessage() != null ? ": " + e.getMessage() : ": See stack trace below."));
                if (e.getMessage() != null) continue;
                e.printStackTrace();
            }
        }
        return this.canceled;
    }

    public boolean checkMethod(String line) throws Throwable {
        if (line.contains("(")) {
            this.handleMethod(line);
            return true;
        }
        return false;
    }

    public Object handleMethod(String line) throws Throwable {
        Object reference = this.getMethodCallObject(line);
        if (reference == WRONG_SIDE) {
            return WRONG_SIDE;
        }
        String method = reference != this.mainObj ? this.splitMethodCall(line) : line;
        return this.splitMethodNameAndBody(method, reference);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object getMethodCallObject(String line) throws Exception {
        if (!line.contains(".")) return this.mainObj;
        if (line.indexOf(".") >= line.indexOf("(")) return this.mainObj;
        String[] split = line.split("\\.", 2);
        if (!this.hasLocalVariable(split[0])) throw new Exception("Referenced variable " + split[0] + " cannot be found.");
        return this.getLocalVariable(split[0]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String splitMethodCall(String line) throws Exception {
        if (!line.contains(".")) return line;
        if (line.indexOf(".") >= line.indexOf("(")) return line;
        String[] split = line.split("\\.", 2);
        if (!this.hasLocalVariable(split[0])) throw new Exception("Referenced variable " + split[0] + " cannot be found.");
        return split[1];
    }

    public Object splitMethodNameAndBody(String line, Object reference) throws Throwable {
        int start = line.indexOf("(");
        int end = StringUtils.lastIndexOf((CharSequence)line, (CharSequence)")");
        String[] split = new String[]{line.substring(0, start), line.substring(start + 1, end)};
        if (split.length > 1) {
            return this.findAndCallMethod(reference, split[0], split[1]);
        }
        return this.findAndCallMethod(reference, split[0], null);
    }

    public String[] trim(String[] array) {
        String[] trimmed = new String[array.length];
        for (int i = 0; i < array.length; ++i) {
            trimmed[i] = array[i].trim();
        }
        return trimmed;
    }

    private String[] splitArguments(String body) {
        if ((body = body.trim()).isEmpty()) {
            return new String[0];
        }
        if (!body.contains(",")) {
            return new String[]{body};
        }
        ArrayList<String> args = new ArrayList<String>();
        int nestCurly = 0;
        int nestSquare = 0;
        int nestAngle = 0;
        int lastArg = -1;
        for (int i = 0; i < body.length(); ++i) {
            if (i == body.length() - 1) {
                args.add(body.substring(lastArg + 1, i + 1));
                break;
            }
            String current = Character.toString(body.charAt(i));
            if (current.equalsIgnoreCase("{")) {
                ++nestCurly;
                continue;
            }
            if (current.equalsIgnoreCase("}")) {
                --nestCurly;
                continue;
            }
            if (nestCurly > 0) continue;
            if (current.equalsIgnoreCase("[")) {
                ++nestSquare;
                continue;
            }
            if (current.equalsIgnoreCase("]")) {
                --nestSquare;
                continue;
            }
            if (nestSquare > 0) continue;
            if (current.equalsIgnoreCase("<")) {
                ++nestAngle;
                continue;
            }
            if (current.equalsIgnoreCase(">")) {
                --nestAngle;
                continue;
            }
            if (nestAngle > 0 || !current.equalsIgnoreCase(",") || StringUtils.countMatches((CharSequence)body.substring(i), (CharSequence)"\"") % 2 == 1) continue;
            args.add(body.substring(lastArg + 1, i));
            lastArg = i;
        }
        String[] argArray = new String[args.size()];
        for (int i = 0; i < argArray.length; ++i) {
            argArray[i] = (String)args.get(i);
        }
        return argArray;
    }

    public Object findAndCallMethod(Object reference, String methodName, String methodBody) throws Throwable {
        ArrayList<Method> possibleMethods = new ArrayList<Method>();
        for (Method method : reference.getClass().getMethods()) {
            if (!method.getName().equals(methodName)) continue;
            possibleMethods.add(method);
        }
        if (possibleMethods.isEmpty()) {
            throw new Exception("No method of name " + methodName + " could be found.");
        }
        if (methodBody != null) {
            String[] trimmed = this.trim(this.splitArguments(methodBody));
            Object[] arguments = this.parseArguments(trimmed);
            AccessibleObject genericMethod = null;
            block9: for (Method method : possibleMethods) {
                Class<?> type;
                if (method.getParameterCount() == 1 && (type = method.getParameterTypes()[0]).isArray() && type.getComponentType() == Object.class) {
                    genericMethod = method;
                    continue;
                }
                if (method.getParameterCount() != arguments.length) continue;
                if (method.isAnnotationPresent(ScriptArgs.class)) {
                    ScriptArgs anno = method.getAnnotation(ScriptArgs.class);
                    ArgType[] argTypes = anno.args();
                    Object[] args = ArgType.transformArgs(arguments, argTypes);
                    if (args != null) {
                        try {
                            if (!BNBGamingLib.proxy.client() && method.isAnnotationPresent(ClientOnly.class)) {
                                return WRONG_SIDE;
                            }
                            return method.invoke(reference, args);
                        }
                        catch (Exception e) {
                            if (e instanceof InvocationTargetException) {
                                throw new Exception(((InvocationTargetException)e).getCause().getLocalizedMessage());
                            }
                            throw new Exception(e.getLocalizedMessage());
                        }
                    }
                    BNBGamingLib.libInstance.getLog().info("Args could not be cast using annotation");
                    continue;
                }
                Parameter[] parameters = method.getParameters();
                Object[] castArgs = new Object[arguments.length];
                System.arraycopy(arguments, 0, castArgs, 0, arguments.length);
                for (int i = 0; i < arguments.length; ++i) {
                    if (arguments[i] == null) {
                        if (!parameters[i].getType().isPrimitive()) continue;
                        continue block9;
                    }
                    Class<?> type2 = parameters[i].getType();
                    if (type2.isPrimitive()) {
                        if (type2 == Boolean.TYPE && arguments[i].getClass() != Boolean.class) continue block9;
                        if (type2 == Byte.TYPE) {
                            if (arguments[i].getClass() != BigDecimal.class) continue block9;
                            castArgs[i] = ((BigDecimal)arguments[i]).byteValueExact();
                            continue;
                        }
                        if (type2 == Short.TYPE) {
                            if (arguments[i].getClass() != BigDecimal.class) continue block9;
                            castArgs[i] = ((BigDecimal)arguments[i]).shortValueExact();
                            continue;
                        }
                        if (type2 == Integer.TYPE) {
                            if (arguments[i].getClass() != BigDecimal.class) continue block9;
                            castArgs[i] = ((BigDecimal)arguments[i]).intValueExact();
                            continue;
                        }
                        if (type2 == Double.TYPE) {
                            if (arguments[i].getClass() != BigDecimal.class) continue block9;
                            castArgs[i] = ((BigDecimal)arguments[i]).doubleValue();
                            continue;
                        }
                        if (type2 == Float.TYPE) {
                            if (arguments[i].getClass() != BigDecimal.class) continue block9;
                            castArgs[i] = Float.valueOf(((BigDecimal)arguments[i]).floatValue());
                            continue;
                        }
                        if (type2 != Long.TYPE) continue;
                        if (arguments[i].getClass() != BigDecimal.class) continue block9;
                        castArgs[i] = ((BigDecimal)arguments[i]).longValueExact();
                        continue;
                    }
                    if (type2 == Byte.class) {
                        if (arguments[i].getClass() != BigDecimal.class) continue block9;
                        castArgs[i] = ((BigDecimal)arguments[i]).byteValueExact();
                        continue;
                    }
                    if (type2 == Short.class) {
                        if (arguments[i].getClass() != BigDecimal.class) continue block9;
                        castArgs[i] = ((BigDecimal)arguments[i]).shortValueExact();
                        continue;
                    }
                    if (type2 == Integer.class) {
                        if (arguments[i].getClass() != BigDecimal.class) continue block9;
                        castArgs[i] = ((BigDecimal)arguments[i]).intValueExact();
                        continue;
                    }
                    if (type2 == Double.class) {
                        if (arguments[i].getClass() != BigDecimal.class) continue block9;
                        castArgs[i] = ((BigDecimal)arguments[i]).doubleValue();
                        continue;
                    }
                    if (type2 == Float.class) {
                        if (arguments[i].getClass() != BigDecimal.class) continue block9;
                        castArgs[i] = Float.valueOf(((BigDecimal)arguments[i]).floatValue());
                        continue;
                    }
                    if (type2 == Long.class) {
                        if (arguments[i].getClass() != BigDecimal.class) continue block9;
                        castArgs[i] = ((BigDecimal)arguments[i]).longValueExact();
                        continue;
                    }
                    if (!type2.isAssignableFrom(arguments[i].getClass())) continue block9;
                }
                try {
                    if (!BNBGamingLib.proxy.client() && method.isAnnotationPresent(ClientOnly.class)) {
                        return WRONG_SIDE;
                    }
                    return method.invoke(reference, castArgs);
                }
                catch (Exception e) {
                    if (e instanceof InvocationTargetException) {
                        throw ((InvocationTargetException)e).getCause();
                    }
                    throw new Exception(e.getLocalizedMessage());
                }
            }
            if (genericMethod != null) {
                try {
                    if (!BNBGamingLib.proxy.client() && genericMethod.isAnnotationPresent(ClientOnly.class)) {
                        return WRONG_SIDE;
                    }
                    return ((Method)genericMethod).invoke(reference, new Object[]{arguments});
                }
                catch (Exception e) {
                    if (e instanceof InvocationTargetException) {
                        throw new Exception(((InvocationTargetException)e).getCause().getLocalizedMessage());
                    }
                    throw new Exception(e.getLocalizedMessage());
                }
            }
            throw new Exception("No method of name " + methodName + " found with the correct parameters.");
        }
        for (Method method : possibleMethods) {
            if (method.getParameterCount() != 0) continue;
            try {
                if (!BNBGamingLib.proxy.client() && method.isAnnotationPresent(ClientOnly.class)) {
                    return WRONG_SIDE;
                }
                return method.invoke(reference, (Object[])null);
            }
            catch (Exception e) {
                if (e instanceof InvocationTargetException) {
                    throw new Exception(((InvocationTargetException)e).getCause().getLocalizedMessage());
                }
                throw new Exception(e.getLocalizedMessage());
            }
        }
        throw new Exception("No method of name " + methodName + " found with the correct number of arguments.");
    }

    public Object findAndCallConstructor(Class<?> clazz, String methodBody) throws Exception {
        if (methodBody != null && !methodBody.isEmpty()) {
            String[] trimmed = this.trim(this.splitArguments(methodBody));
            Object[] arguments = this.parseArguments(trimmed);
            Constructor<?> genericConstructor = null;
            block8: for (Constructor<?> constructor : clazz.getConstructors()) {
                Class<?> type;
                if (constructor.getParameterCount() == 1 && (type = constructor.getParameterTypes()[0]).isArray() && type.getComponentType() == Object.class) {
                    genericConstructor = constructor;
                    continue;
                }
                if (constructor.getParameterCount() != arguments.length) continue;
                if (constructor.isAnnotationPresent(ScriptArgs.class)) {
                    ScriptArgs anno = constructor.getAnnotation(ScriptArgs.class);
                    ArgType[] argTypes = anno.args();
                    Object[] args = ArgType.transformArgs(arguments, argTypes);
                    if (args != null) {
                        try {
                            if (!BNBGamingLib.proxy.client() && constructor.isAnnotationPresent(ClientOnly.class)) {
                                return WRONG_SIDE;
                            }
                            return constructor.newInstance(args);
                        }
                        catch (Exception e) {
                            if (e instanceof InvocationTargetException) {
                                throw new Exception(((InvocationTargetException)e).getCause().getLocalizedMessage());
                            }
                            throw new Exception(e.getLocalizedMessage());
                        }
                    }
                    BNBGamingLib.libInstance.getLog().info("Args could not be cast using annotation");
                    continue;
                }
                Parameter[] parameters = constructor.getParameters();
                Object[] castArgs = new Object[arguments.length];
                System.arraycopy(arguments, 0, castArgs, 0, arguments.length);
                for (int i = 0; i < parameters.length; ++i) {
                    if (arguments[i] == null) {
                        if (!parameters[i].getType().isPrimitive()) continue;
                        continue block8;
                    }
                    Class<?> type2 = parameters[i].getType();
                    if (type2.isPrimitive()) {
                        if (type2 == Boolean.TYPE && arguments[i].getClass() != Boolean.class) continue block8;
                        if (type2 == Byte.TYPE) {
                            if (arguments[i].getClass() != BigDecimal.class) continue block8;
                            castArgs[i] = ((BigDecimal)arguments[i]).byteValueExact();
                            continue;
                        }
                        if (type2 == Short.TYPE) {
                            if (arguments[i].getClass() != BigDecimal.class) continue block8;
                            castArgs[i] = ((BigDecimal)arguments[i]).shortValueExact();
                            continue;
                        }
                        if (type2 == Integer.TYPE) {
                            if (arguments[i].getClass() != BigDecimal.class) continue block8;
                            castArgs[i] = ((BigDecimal)arguments[i]).intValueExact();
                            continue;
                        }
                        if (type2 == Double.TYPE) {
                            if (arguments[i].getClass() != BigDecimal.class) continue block8;
                            castArgs[i] = ((BigDecimal)arguments[i]).doubleValue();
                            continue;
                        }
                        if (type2 == Float.TYPE) {
                            if (arguments[i].getClass() != BigDecimal.class) continue block8;
                            castArgs[i] = Float.valueOf(((BigDecimal)arguments[i]).floatValue());
                            continue;
                        }
                        if (type2 != Long.TYPE) continue;
                        if (arguments[i].getClass() != BigDecimal.class) continue block8;
                        castArgs[i] = ((BigDecimal)arguments[i]).longValueExact();
                        continue;
                    }
                    if (!type2.isAssignableFrom(arguments[i].getClass())) continue block8;
                }
                try {
                    if (!BNBGamingLib.proxy.client() && constructor.isAnnotationPresent(ClientOnly.class)) {
                        return WRONG_SIDE;
                    }
                    return constructor.newInstance(castArgs);
                }
                catch (Exception e) {
                    if (e instanceof InvocationTargetException) {
                        throw new Exception("Failed to create new instance of constructor: " + ((InvocationTargetException)e).getCause().getLocalizedMessage());
                    }
                    throw new Exception("Failed to create new instance of constructor: " + e.getLocalizedMessage());
                }
            }
            if (genericConstructor != null) {
                try {
                    if (!BNBGamingLib.proxy.client() && genericConstructor.isAnnotationPresent(ClientOnly.class)) {
                        return WRONG_SIDE;
                    }
                    return genericConstructor.newInstance(new Object[]{arguments});
                }
                catch (Exception e) {
                    if (e instanceof InvocationTargetException) {
                        throw new Exception(((InvocationTargetException)e).getCause().getLocalizedMessage());
                    }
                    throw new Exception(e.getLocalizedMessage());
                }
            }
            throw new Exception("No constructor found with the correct parameters.");
        }
        for (Constructor<?> constructor : clazz.getConstructors()) {
            if (constructor.getParameterCount() != 0) continue;
            try {
                if (!BNBGamingLib.proxy.client() && constructor.isAnnotationPresent(ClientOnly.class)) {
                    return WRONG_SIDE;
                }
                return constructor.newInstance(null);
            }
            catch (Exception e) {
                if (e instanceof InvocationTargetException) {
                    throw new Exception(((InvocationTargetException)e).getCause().getLocalizedMessage());
                }
                throw new Exception(e.getLocalizedMessage());
            }
        }
        throw new Exception("No constructor found with the correct number of arguments.");
    }

    public Object[] parseArguments(String[] arguments) throws Exception {
        arguments = this.trim(arguments);
        Object[] args = new Object[arguments.length];
        for (int i = 0; i < arguments.length; ++i) {
            if (arguments[i].equalsIgnoreCase("null")) {
                args[i] = null;
                continue;
            }
            if (this.hasLocalVariable(arguments[i])) {
                args[i] = this.getLocalVariable(arguments[i]);
                continue;
            }
            String string = this.parseToString(arguments[i]);
            if (string != null) {
                args[i] = string;
                continue;
            }
            Boolean bool = this.parseToBoolean(arguments[i]);
            if (bool != null) {
                args[i] = bool;
                continue;
            }
            BigDecimal numArg = this.parseToBigDecimal(arguments[i]);
            if (numArg != null) {
                args[i] = numArg;
                continue;
            }
            int[] intArray = this.parseToIntArray(arguments[i]);
            if (intArray != null) {
                args[i] = intArray;
                continue;
            }
            float[] floatArray = this.parseToFloatArray(arguments[i]);
            if (floatArray != null) {
                args[i] = floatArray;
                continue;
            }
            String[] stringArray = this.parseToStringArray(arguments[i]);
            if (stringArray != null) {
                args[i] = stringArray;
                continue;
            }
            ItemBlockData itemBlockData = this.parseToItemBlock(arguments[i]);
            if (itemBlockData != null) {
                args[i] = itemBlockData;
                continue;
            }
            MinMaxBounds bounds = this.parseToMinMaxBounds(arguments[i]);
            if (bounds != null) {
                args[i] = bounds;
                continue;
            }
            throw new Exception("Argument " + (i + 1) + " could not be cast to anything.");
        }
        return args;
    }

    private String parseToString(String arg) {
        if (arg.startsWith("\"") && arg.endsWith("\"")) {
            return arg.substring(1, arg.length() - 1);
        }
        if (arg.startsWith("{") && arg.endsWith("}")) {
            return arg;
        }
        return null;
    }

    private BigDecimal parseToBigDecimal(String arg) {
        try {
            if (arg.startsWith("0x")) {
                return new BigDecimal(Integer.parseUnsignedInt(arg.substring(2), 16));
            }
            if (arg.startsWith("#")) {
                return new BigDecimal(Integer.parseUnsignedInt(arg.substring(1), 16));
            }
            return new BigDecimal(arg);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    private Boolean parseToBoolean(String arg) {
        if (arg.equalsIgnoreCase("true")) {
            return true;
        }
        if (arg.equalsIgnoreCase("false")) {
            return false;
        }
        return null;
    }

    private int[] parseToIntArray(String arg) {
        if (arg.startsWith("[") && arg.endsWith("]")) {
            String array = new String(arg);
            array = StringUtils.removeStart((String)array, (String)"[");
            array = StringUtils.removeEnd((String)array, (String)"]");
            String[] sections = this.splitArguments(array);
            sections = this.trim(sections);
            int[] ints = new int[sections.length];
            for (int ii = 0; ii < sections.length; ++ii) {
                String section = sections[ii];
                try {
                    ints[ii] = Integer.parseInt(section);
                    continue;
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
            return ints;
        }
        return null;
    }

    private float[] parseToFloatArray(String arg) {
        if (arg.startsWith("[") && arg.endsWith("]")) {
            String array = new String(arg);
            array = StringUtils.removeStart((String)array, (String)"[");
            array = StringUtils.removeEnd((String)array, (String)"]");
            String[] sections = this.splitArguments(array);
            sections = this.trim(sections);
            float[] floats = new float[sections.length];
            for (int ii = 0; ii < sections.length; ++ii) {
                String section = sections[ii];
                try {
                    floats[ii] = Float.parseFloat(section);
                    continue;
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
            return floats;
        }
        return null;
    }

    private String[] parseToStringArray(String arg) {
        if (arg.startsWith("[") && arg.endsWith("]")) {
            String array = new String(arg);
            array = StringUtils.removeStart((String)array, (String)"[");
            array = StringUtils.removeEnd((String)array, (String)"]");
            String[] sections = this.splitArguments(array);
            sections = this.trim(sections);
            String[] strings = new String[sections.length];
            for (int i = 0; i < sections.length; ++i) {
                if (!sections[i].startsWith("\"") || !sections[i].endsWith("\"")) {
                    return null;
                }
                strings[i] = sections[i].substring(1, sections[i].length() - 1);
            }
            return strings;
        }
        return null;
    }

    private ItemBlockData parseToItemBlock(String arg) throws Exception {
        if (arg.startsWith("<") && arg.endsWith(">")) {
            ItemBlockData data = new ItemBlockData();
            String[] trimmed = this.trim(this.splitArguments(arg.substring(1, arg.length() - 1)));
            for (int i = 0; i < trimmed.length; ++i) {
                if (trimmed[i].startsWith("ore:")) {
                    data.setOre(trimmed[i].substring(4));
                    continue;
                }
                if (trimmed[i].startsWith("state:")) {
                    data.setStateJson(trimmed[i].substring(6));
                    continue;
                }
                if (trimmed[i].startsWith("meta:")) {
                    data.setMeta(this.parseToMinMaxBounds(trimmed[i].substring(5)));
                    continue;
                }
                if (trimmed[i].startsWith("count:")) {
                    data.setCount(this.parseToMinMaxBounds(trimmed[i].substring(6)));
                    continue;
                }
                if (trimmed[i].startsWith("durability:")) {
                    data.setCount(this.parseToMinMaxBounds(trimmed[i].substring(11)));
                    continue;
                }
                if (trimmed[i].startsWith("enchant:")) {
                    String sub = trimmed[i].substring(8);
                    if (sub.startsWith("[") && sub.endsWith("]")) {
                        String[] splitArray;
                        for (String split : splitArray = this.trim(this.splitArguments(sub.substring(1, sub.length() - 1)))) {
                            data.addEnchantment(this.parseToEnchantPredicate(split));
                        }
                        continue;
                    }
                    data.addEnchantment(this.parseToEnchantPredicate(sub));
                    continue;
                }
                if (trimmed[i].startsWith("potion:")) {
                    data.setPotion(trimmed[i].substring(7));
                    continue;
                }
                if (trimmed[i].startsWith("nbt:")) {
                    data.setNBT(trimmed[i].substring(4));
                    continue;
                }
                if (trimmed[i].startsWith("state:")) {
                    data.setStateJson(trimmed[i].substring(6));
                    continue;
                }
                if (trimmed[i].startsWith("tile:")) {
                    data.setTileNBT(trimmed[i].substring(5));
                    continue;
                }
                String[] split = trimmed[i].split(":");
                if (split.length > 2) {
                    data.setLocation(split[0] + ":" + split[1]);
                    data.setMeta(this.parseToMinMaxBounds(split[2]));
                    continue;
                }
                data.setLocation(trimmed[i]);
            }
            return data;
        }
        return null;
    }

    private EnchantmentPredicate parseToEnchantPredicate(String arg) throws Exception {
        Enchantment enchant = null;
        MinMaxBounds levels = MinMaxBounds.field_192516_a;
        if (Character.isAlphabetic(arg.charAt(0))) {
            String[] split = this.trim(arg.split(":", 3));
            MinMaxBounds bounds = this.parseToMinMaxBounds(split[split.length - 1]);
            if (bounds != null) {
                levels = bounds;
                if (split.length > 2) {
                    String location = split[0] + ":" + split[1];
                    enchant = Enchantment.func_180305_b((String)location);
                    if (enchant == null) {
                        throw new Exception(location + " is not a valid enchantment id!");
                    }
                } else {
                    String location = split[0];
                    enchant = Enchantment.func_180305_b((String)location);
                    if (enchant == null) {
                        throw new Exception(location + " is not a valid enchantment id!");
                    }
                }
                return new EnchantmentPredicate(enchant, levels);
            }
            if (split.length > 1) {
                String location = split[0] + ":" + split[1];
                enchant = Enchantment.func_180305_b((String)location);
                if (enchant == null) {
                    throw new Exception(location + " is not a valid enchantment id!");
                }
            } else {
                String location = split[0];
                enchant = Enchantment.func_180305_b((String)location);
                if (enchant == null) {
                    throw new Exception(location + " is not a valid enchantment id!");
                }
            }
            return new EnchantmentPredicate(enchant, levels);
        }
        return new EnchantmentPredicate(null, this.parseToMinMaxBounds(arg));
    }

    private MinMaxBounds parseToMinMaxBounds(String arg) throws Exception {
        if (arg.contains("~")) {
            if (arg.startsWith("~")) {
                String max = arg.substring(1).trim();
                if (NumberUtils.isCreatable((String)max)) {
                    return new MinMaxBounds(null, Float.valueOf(NumberUtils.createNumber((String)max).floatValue()));
                }
                return null;
            }
            if (arg.endsWith("~")) {
                String min = arg.substring(0, arg.length() - 1);
                if (NumberUtils.isCreatable((String)min)) {
                    return new MinMaxBounds(Float.valueOf(NumberUtils.createNumber((String)min).floatValue()), null);
                }
                return null;
            }
            String[] split = arg.split("~");
            if (NumberUtils.isCreatable((String)split[0].trim()) && NumberUtils.isCreatable((String)split[1].trim())) {
                return new MinMaxBounds(Float.valueOf(NumberUtils.createNumber((String)split[0]).floatValue()), Float.valueOf(NumberUtils.createNumber((String)split[1]).floatValue()));
            }
            return null;
        }
        if (NumberUtils.isCreatable((String)arg)) {
            return new MinMaxBounds(Float.valueOf(NumberUtils.createNumber((String)arg).floatValue()), Float.valueOf(NumberUtils.createNumber((String)arg).floatValue()));
        }
        return null;
    }

    public boolean checkLocalVariable(String line) throws Throwable {
        if (line.contains("=")) {
            String[] split = line.split("=");
            String trimName = split[0].trim();
            String trimMethod = split[1].trim();
            if (!trimMethod.startsWith("new")) {
                Object reference = this.handleMethod(trimMethod);
                if (reference != null) {
                    this.setLocalVariable(trimName, reference);
                    return true;
                }
                throw new Exception("Reference Null");
            }
            trimMethod = trimMethod.replace("new ", "").trim();
            int start = trimMethod.indexOf("(");
            int end = StringUtils.lastIndexOf((CharSequence)trimMethod, (CharSequence)")");
            String[] methodSplit = new String[]{trimMethod.substring(0, start), trimMethod.substring(start + 1, end)};
            Class<?> clazz = this.getClassForKeyword(methodSplit[0]);
            if (clazz != null) {
                Object returnObj;
                if (methodSplit.length == 1) {
                    returnObj = this.findAndCallConstructor(clazz, "");
                } else {
                    methodSplit[1] = methodSplit[1].trim();
                    returnObj = this.findAndCallConstructor(clazz, methodSplit[1]);
                }
                if (returnObj != null) {
                    this.setLocalVariable(trimName, returnObj);
                    return true;
                }
                throw new Exception("Reference Null");
            }
            throw new Exception("No class keyword found for '" + methodSplit[0] + "'");
        }
        return false;
    }

    public void addRequiredMod(String modID) {
        if (!Loader.isModLoaded((String)modID)) {
            this.canceled = true;
            BNBGamingLib.libInstance.getLog().debug("Canceled reading script in file " + this.fileName + " due to: missing mod `" + modID + "`");
        }
    }
}

